/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreadjustmentType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.modelling.arima.x13.CalendarEffectsDetection;
import ec.tstoolkit.modelling.arima.x13.EasterDetection;
import ec.tstoolkit.modelling.arima.x13.LogLevelTest;
import ec.tstoolkit.modelling.arima.x13.MeanController;
import ec.tstoolkit.modelling.arima.x13.OutliersDetector;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.EasterVariable;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.regression.LeapYearVariable;
import ec.tstoolkit.timeseries.simplets.TsData;

public class X13Monitors {
    static void addEaster(ModelDescription desc) {
        EasterVariable easter = new EasterVariable();
        easter.setType(EasterVariable.Correction.PreComputed);
        desc.addVariable(Variable.movingHolidayVariable(easter, RegStatus.ToAdd));
    }

    static void addTradingDays(ModelDescription desc, int ntd) {
        GregorianCalendarVariables td;
        if (ntd == 1 || ntd == 2) {
            td = GregorianCalendarVariables.getDefault(TradingDaysType.WorkingDays);
            desc.addVariable(Variable.calendarVariable(td, RegStatus.ToRemove));
        } else if (ntd == 6 || ntd == 7) {
            td = GregorianCalendarVariables.getDefault(TradingDaysType.TradingDays);
            desc.addVariable(Variable.calendarVariable(td, RegStatus.ToRemove));
        }
        if (ntd == 2 || ntd == 7) {
            LeapYearVariable lp = new LeapYearVariable(LengthOfPeriodType.LeapYear);
            desc.addVariable(Variable.calendarVariable(lp, RegStatus.ToRemove));
            desc.setTransformation(PreadjustmentType.Auto);
        }
    }

    static IPreprocessingModule buildOutliers() {
        OutliersDetector outliers = new OutliersDetector();
        outliers.setDefault();
        return outliers;
    }

    static class Rsa2
    implements IPreprocessor {
        IPreprocessingModule loglevel;
        EasterDetection easterTest = new EasterDetection();
        CalendarEffectsDetection tdTest = new CalendarEffectsDetection();
        MeanController meanTest = new MeanController(1.96);
        IPreprocessingModule outliers;

        Rsa2() {
            this.loglevel = new LogLevelTest();
            this.outliers = X13Monitors.buildOutliers();
        }

        ProcessingResult runRegressionTests(ModellingContext context) {
            ProcessingResult rslt = ProcessingResult.Unchanged;
            if (this.tdTest.process(context) == ProcessingResult.Changed) {
                rslt = ProcessingResult.Changed;
            }
            if (this.easterTest.process(context) == ProcessingResult.Changed) {
                rslt = ProcessingResult.Changed;
            }
            return rslt;
        }

        @Override
        public PreprocessingModel process(TsData originalTs, ModellingContext context) {
            context.description = new ModelDescription(originalTs, null);
            if (!this.check(context)) {
                return null;
            }
            context.automodelling = false;
            context.outliers = true;
            this.initContext(context);
            this.loglevel.process(context);
            this.runRegressionTests(context);
            ProcessingResult rslt = this.outliers.process(context);
            IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
            RegArimaEstimator estimator = new RegArimaEstimator(mapping);
            estimator.setPrecision(1.0E-7);
            context.estimation = new ModelEstimation(context.description.buildRegArima(), context.description.getLikelihoodCorrection());
            context.estimation.compute(estimator, mapping.getDim());
            return context.current(true);
        }

        private void initContext(ModellingContext context) {
            context.description.setTransformation(DefaultTransformationType.Auto);
            context.description.setAirline(context.hasseas);
            X13Monitors.addTradingDays(context.description, 2);
            X13Monitors.addEaster(context.description);
        }

        private boolean check(ModellingContext context) {
            double[] y = context.description.getY();
            return y != null && y.length >= 3 * context.description.getFrequency();
        }
    }

    static class Rsa1
    implements IPreprocessor {
        IPreprocessingModule loglevel = new LogLevelTest();
        IPreprocessingModule outliers = X13Monitors.buildOutliers();

        Rsa1() {
        }

        @Override
        public PreprocessingModel process(TsData originalTs, ModellingContext context) {
            context.description = new ModelDescription(originalTs, null);
            context.automodelling = false;
            context.outliers = true;
            this.initContext(context);
            this.loglevel.process(context);
            ProcessingResult rslt = this.outliers.process(context);
            IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
            RegArimaEstimator estimator = new RegArimaEstimator(mapping);
            estimator.setPrecision(1.0E-7);
            context.estimation = new ModelEstimation(context.description.buildRegArima(), context.description.getLikelihoodCorrection());
            context.estimation.compute(estimator, mapping.getDim());
            return context.current(true);
        }

        private void initContext(ModellingContext context) {
            context.description.setTransformation(DefaultTransformationType.Auto);
            context.description.setAirline(context.hasseas);
        }
    }

    static class Rsa0
    implements IPreprocessor {
        Rsa0() {
        }

        @Override
        public PreprocessingModel process(TsData originalTs, ModellingContext context) {
            context.description = new ModelDescription(originalTs, null);
            context.automodelling = false;
            context.outliers = false;
            this.initContext(context);
            IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
            RegArimaEstimator estimator = new RegArimaEstimator(mapping);
            estimator.setPrecision(1.0E-7);
            context.estimation = new ModelEstimation(context.description.buildRegArima());
            context.estimation.compute(estimator, mapping.getDim());
            return context.current(true);
        }

        private void initContext(ModellingContext context) {
            context.description.setTransformation(DefaultTransformationType.Auto);
            context.description.setAirline(context.hasseas);
        }
    }
}

