/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.utilities;

import ec.tstoolkit.utilities.Jdk6;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefinitionMap {
    private final HashMap<String, String[]> map_ = new HashMap();
    private String name_;
    private int id_ = 1;

    public DefinitionMap(String name) {
        this.name_ = name;
    }

    public void clear() {
        this.map_.clear();
    }

    public List<String> getItems() {
        Set<String> keys = this.map_.keySet();
        return Jdk6.newArrayList(keys);
    }

    public String add() {
        String name = this.nextValidName();
        this.map_.put(name, null);
        return name;
    }

    public boolean rename(String oldname, String newname) {
        if (this.map_.containsKey(newname)) {
            return false;
        }
        String[] dep = this.map_.get(oldname);
        if (dep != null) {
            this.map_.remove(oldname);
            this.map_.put(newname, dep);
        }
        for (String[] sdep : this.map_.values()) {
            if (sdep == null) continue;
            for (int i = 0; i < sdep.length; ++i) {
                if (!sdep[i].equals(oldname)) continue;
                sdep[i] = newname;
            }
        }
        return true;
    }

    public boolean depend(String c, String p) {
        if (c.endsWith(p)) {
            return true;
        }
        String[] dep = this.map_.get(c);
        if (dep != null) {
            for (int i = 0; i < dep.length; ++i) {
                if (!dep[i].equals(p) && !this.depend(dep[i], p)) continue;
                return true;
            }
        }
        return false;
    }

    public void buildSequence(List<String> list) {
        HashSet<String> set = new HashSet<String>();
        for (String s : this.map_.keySet()) {
            this.buildSubSequence(s, list, set);
        }
    }

    private void buildSubSequence(String s, List<String> list, HashSet<String> set) {
        String[] dep = this.map_.get(s);
        if (dep != null) {
            for (int i = 0; i < dep.length; ++i) {
                if (set.contains(dep[i])) continue;
                this.buildSubSequence(dep[i], list, set);
            }
        }
        if (!set.contains(s)) {
            list.add(s);
            set.add(s);
        }
    }

    private String nextName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name_).append(this.id_++);
        return builder.toString();
    }

    public String nextValidName() {
        String s = null;
        while (this.map_.containsKey(s = this.nextName())) {
        }
        return s;
    }

    public boolean add(String name, String[] dep) {
        if (this.map_.containsKey(name)) {
            return false;
        }
        this.map_.put(name, dep);
        return true;
    }

    public boolean contains(String name) {
        return this.map_.containsKey(name);
    }

    public void setDependencies(String obj, String[] source) {
        this.map_.put(obj, source);
    }

    public boolean isLinked(String name) {
        for (String[] dep : this.map_.values()) {
            if (dep == null) continue;
            for (int i = 0; i < dep.length; ++i) {
                if (!name.equals(dep[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void remove(String name) {
        this.map_.remove(name);
    }
}

