/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.sa;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.YearIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jd2.algorithm.IProcResults;
import jd2.information.InformationMapping;

public final class CoherenceDiagnostics
implements IProcResults {
    private static final double EB = 0.5;
    private static final double UB = 0.01;
    private static final double BB = 0.05;
    private static final double SB = 0.1;
    private static final double LDEF = 1.0E-6;
    private static final int YSHORT = 7;
    private static final String SHORTSERIES = "Short series";
    public static final String DEF = "definition";
    public static final String BIAS = "annual totals";
    public static final String NAME = "Basic checks";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("definition", "annual totals"));
    private double maxDA_;
    private double maxDDef_;
    private boolean mul_;
    private boolean short_;
    private double scale;
    static final InformationMapping<CoherenceDiagnostics> MAPPING = new InformationMapping<CoherenceDiagnostics>(CoherenceDiagnostics.class);

    public static CoherenceDiagnostics of(CompositeResults rslts) {
        try {
            if (rslts == null || GenericSaResults.getDecomposition((CompositeResults)rslts, ISaResults.class) == null) {
                return null;
            }
            return new CoherenceDiagnostics(rslts);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static InformationMapping<CoherenceDiagnostics> getMapping() {
        return MAPPING;
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, dic, true);
        return dic;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    private CoherenceDiagnostics(CompositeResults rslts) {
        this.test(rslts);
    }

    private void test(CompositeResults rslts) {
        ISeriesDecomposition decomposition;
        TsData yl = (TsData)rslts.getData("y_lin", TsData.class);
        if (yl != null && yl.getLength() < 7 * yl.getFrequency().intValue()) {
            this.short_ = true;
        }
        this.mul_ = (decomposition = GenericSaResults.getFinalDecomposition((CompositeResults)rslts)).getMode() != DecompositionMode.Additive;
        TsData y = (TsData)rslts.getData("yc", TsData.class);
        DescriptiveStatistics ds = new DescriptiveStatistics((IReadDataBlock)y);
        this.scale = ds.getRmse();
        TsData yc = y;
        TsData sa = (TsData)rslts.getData("sa", TsData.class);
        TsData s = (TsData)rslts.getData("s", TsData.class);
        TsData t = (TsData)rslts.getData("t", TsData.class);
        TsData i = (TsData)rslts.getData("i", TsData.class);
        if (decomposition.getMode() == DecompositionMode.PseudoAdditive) {
            TsData df0 = this.sub(y, TsData.multiply((TsData)t, (TsData)TsData.add((TsData)s, (TsData)i).minus(1.0)));
            TsData df1 = this.sub(sa, TsData.multiply((TsData)t, (TsData)i));
            this.check(df0);
            this.check(df1);
        } else {
            TsData regy = (TsData)rslts.getData("reg_y", TsData.class);
            TsData regsa = (TsData)rslts.getData("reg_sa", TsData.class);
            TsData cy = (TsData)rslts.getData("y_cmp", TsData.class);
            TsData ct = (TsData)rslts.getData("t_cmp", TsData.class);
            TsData cs = (TsData)rslts.getData("s_cmp", TsData.class);
            TsData ci = (TsData)rslts.getData("i_cmp", TsData.class);
            TsData csa = (TsData)rslts.getData("sa_cmp", TsData.class);
            TsData ly = (TsData)rslts.getData("y_lin", TsData.class);
            TsData lt = (TsData)rslts.getData("t_lin", TsData.class);
            TsData ls = (TsData)rslts.getData("s_lin", TsData.class);
            TsData li = (TsData)rslts.getData("i_lin", TsData.class);
            TsData lsa = (TsData)rslts.getData("sa_lin", TsData.class);
            TsData tde = (TsData)rslts.getData("tde", TsData.class);
            TsData ee = (TsData)rslts.getData("ee", TsData.class);
            TsData omhe = (TsData)rslts.getData("omhe", TsData.class);
            TsData cal = (TsData)rslts.getData("cal", TsData.class);
            TsData outs = (TsData)rslts.getData("out_s", TsData.class);
            TsData regs = (TsData)rslts.getData("reg_s", TsData.class);
            TsData outt = (TsData)rslts.getData("out_t", TsData.class);
            TsData regt = (TsData)rslts.getData("reg_t", TsData.class);
            TsData outi = (TsData)rslts.getData("out_i", TsData.class);
            TsData regi = (TsData)rslts.getData("reg_i", TsData.class);
            yc = this.inv_op(y, regy);
            TsData df0 = this.sub(yc, this.op(t, s, i, regsa));
            TsData df1 = this.sub(sa, this.op(t, i, regsa));
            TsData df2 = this.sub(this.inv_op(y, regy), this.op(sa, s));
            TsData df3 = this.sub(s, this.op(cs, cal, regs, outs));
            TsData df4 = this.sub(t, this.op(ct, regt, outt));
            TsData df5 = this.sub(i, this.op(ci, regi, outi));
            TsData dcal = this.sub(cal, this.op(tde, ee, omhe));
            TsData dc0 = this.sub(cy, this.op(ct, cs, ci));
            TsData dc1 = this.sub(csa, this.op(ct, ci));
            TsData dc2 = this.sub(cy, this.op(csa, cs));
            this.maxDDef_ = Double.NaN;
            this.check(df0);
            this.check(df1);
            this.check(df2);
            this.check(df3);
            this.check(df4);
            this.check(df5);
            this.check(dcal);
            this.check(dc0);
            this.check(dc1);
            this.check(dc2);
            if (lsa != null) {
                TsData dl0 = this.sub(ly, this.add(lt, ls, li));
                TsData dl1 = this.sub(lsa, this.add(lt, li));
                TsData dl2 = this.sub(ly, this.add(lsa, ls));
                this.check(dl0);
                this.check(dl1);
                this.check(dl2);
            }
        }
        YearIterator yiter = YearIterator.fullYears((TsData)yc);
        YearIterator saiter = YearIterator.fullYears((TsData)sa);
        this.maxDA_ = 0.0;
        while (yiter.hasMoreElements() && saiter.hasMoreElements()) {
            TsDataBlock ydb = yiter.nextElement();
            TsDataBlock sadb = saiter.nextElement();
            double dcur = Math.abs(ydb.data.sum() - sadb.data.sum());
            if (!(dcur > this.maxDA_)) continue;
            this.maxDA_ = dcur;
        }
        this.maxDA_ /= (double)y.getFrequency().intValue() * this.scale;
    }

    private TsData op(TsData l, TsData r) {
        if (this.mul_) {
            return TsData.multiply((TsData)l, (TsData)r);
        }
        return TsData.add((TsData)l, (TsData)r);
    }

    private TsData op(TsData a, TsData b, TsData c) {
        if (this.mul_) {
            return TsData.multiply((TsData)a, (TsData)TsData.multiply((TsData)b, (TsData)c));
        }
        return TsData.add((TsData)a, (TsData)TsData.add((TsData)b, (TsData)c));
    }

    private TsData add(TsData l, TsData r) {
        return TsData.add((TsData)l, (TsData)r);
    }

    private TsData add(TsData a, TsData b, TsData c) {
        return TsData.add((TsData)a, (TsData)TsData.add((TsData)b, (TsData)c));
    }

    private TsData op(TsData a, TsData b, TsData c, TsData d) {
        return this.op(this.op(a, b), this.op(c, d));
    }

    private TsData inv_op(TsData l, TsData r) {
        if (this.mul_) {
            return TsData.divide((TsData)l, (TsData)r);
        }
        return TsData.subtract((TsData)l, (TsData)r);
    }

    private TsData sub(TsData l, TsData r) {
        return TsData.subtract((TsData)l, (TsData)r);
    }

    public ProcQuality getDiagnostic(String test) {
        if (test.equals(ALL.get(0))) {
            if (Double.isNaN(this.maxDDef_)) {
                return ProcQuality.Error;
            }
            return this.maxDDef_ < 1.0E-6 ? ProcQuality.Good : ProcQuality.Error;
        }
        if (Double.isNaN(this.maxDA_) || this.maxDA_ > 0.5) {
            return ProcQuality.Error;
        }
        if (this.maxDA_ > 0.1) {
            return ProcQuality.Severe;
        }
        if (this.maxDA_ > 0.05) {
            return ProcQuality.Bad;
        }
        if (this.maxDA_ > 0.01) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        double val = test.equals(ALL.get(0)) ? this.maxDDef_ : this.maxDA_;
        return val;
    }

    public List<String> getWarnings() {
        if (this.short_) {
            return Collections.singletonList(SHORTSERIES);
        }
        return null;
    }

    private void check(TsData d) {
        if (d == null || this.scale == 0.0) {
            return;
        }
        DescriptiveStatistics stats = new DescriptiveStatistics((IReadDataBlock)d);
        double dmax = Math.max(Math.abs(stats.getMax()), Math.abs(stats.getMin())) / this.scale;
        if (Double.isNaN(this.maxDDef_) || dmax > this.maxDDef_) {
            this.maxDDef_ = dmax;
        }
    }

    static {
        MAPPING.set("annualtotals.value", Double.class, source -> source.getValue(BIAS));
        MAPPING.set("annualtotals", String.class, source -> source.getDiagnostic(BIAS).name());
        MAPPING.set("definition.value", Double.class, source -> source.getValue(DEF));
        MAPPING.set(DEF, String.class, source -> source.getDiagnostic(DEF).name());
    }
}

