/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.RBFN_CL;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import keel.Algorithms.Neural_Networks.RBFN_CL.ProcDataset;
import keel.Algorithms.Neural_Networks.RBFN_CL.RBFUtils;
import keel.Algorithms.Neural_Networks.RBFN_CL.Rbfn;
import org.core.Randomize;

public class doRbfnCl {
    static String trnFile;
    static String tstFile;
    static String outTrnFile;
    static String outTstFile;
    static String outRbfFile;
    static int neurons;
    static double seed;
    static boolean reallySeed;

    private static boolean setParameters(String fileName) {
        Hashtable parameters = RBFUtils.parameters(fileName);
        RBFUtils.setVerbosity(parameters);
        String tmp = (String)((Vector)parameters.get("inputData")).get(0);
        trnFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parameters.get("inputData")).get(2);
        tstFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parameters.get("outputData")).get(0);
        outTrnFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parameters.get("outputData")).get(1);
        outTstFile = tmp.substring(1, tmp.length() - 1);
        tmp = (String)((Vector)parameters.get("outputData")).get(2);
        outRbfFile = tmp.substring(1, tmp.length() - 1);
        neurons = (int)Double.parseDouble((String)((Vector)parameters.get("neurons")).get(0));
        if (parameters.containsKey("seed")) {
            reallySeed = true;
            seed = Double.parseDouble((String)((Vector)parameters.get("seed")).get(0));
        } else {
            reallySeed = false;
        }
        RBFUtils.verboseln("Training file      : " + trnFile);
        RBFUtils.verboseln("Test file          : " + tstFile);
        RBFUtils.verboseln("Ouput Training file: " + outTrnFile);
        RBFUtils.verboseln("Ouput Test file    : " + outTstFile);
        RBFUtils.verboseln("Ouput RBF file     : " + outRbfFile);
        RBFUtils.verboseln("Neurons            : " + neurons);
        RBFUtils.verbose("Seed               : ");
        if (reallySeed) {
            RBFUtils.verboseln("" + seed);
        } else {
            RBFUtils.verboseln("No seed, i.e., pure random execution");
        }
        RBFUtils.verboseln("Verbosity          : " + RBFUtils.getVerbosity());
        return trnFile != "" && tstFile != "" && outTrnFile != "" && outTstFile != "" && neurons > 0;
    }

    private static void doHelp() {
        System.out.println("Usage: doRbfCl paramFile");
        System.out.println("       doRbfCl --help");
        System.out.println("       (doRbfCl can also be RBFN_CL.jar)");
        System.out.println("  Where: ");
        System.out.println("   paramFile  Name of file containing the parameters according to Keel format.");
        System.out.println("              Example of parameter file: ");
        System.out.println("              algorithm = rbfn");
        System.out.println("              neurons = 5");
        System.out.println("              verbose = true");
        System.out.println("              inputData = \"sintetica.trn\" \"sintetica.tst\" ");
        System.out.println("              outputData = \"result1.trn\" \"result1.tst\" \"result1.rbf\" ");
        System.out.println("\n---\nAuthors: Antonio Rivera (arivera@ujaen.es),  \n         Loli Perez (lperez@ujaen.es), \n         Victor Rivas  (vrivas@ujaen.es)\nFrom:    Univ. of Jaen (Spain)\nFor:     Keel Project.\n\n");
    }

    public static void main(String[] args) throws IOException {
        try {
            int i;
            if (args.length > 0 && (args[0].equals("--help") || args[0].equals("-help") || args[0].equals("-h") || args[0].equals("-?"))) {
                doRbfnCl.doHelp();
                return;
            }
            System.out.println("- Executing doRbfnCl " + args.length);
            String paramFile = args.length > 0 ? args[0] : "parameters.txt";
            doRbfnCl.setParameters(paramFile);
            System.out.println("    - Parameters file: " + paramFile);
            if (reallySeed) {
                Randomize.setSeed((long)seed);
            }
            ProcDataset Dtrn = new ProcDataset(trnFile, true);
            System.out.println("Classification Dataset");
            Dtrn.processClassifierDataset();
            int nInpt = Dtrn.getninputs();
            int nOutp = 1;
            int ndata = Dtrn.getndata();
            double[][] Y = new double[ndata][1];
            double[][] X = Dtrn.getX();
            int[] auxY = Dtrn.getC();
            for (i = 0; i < ndata; ++i) {
                Y[i][0] = auxY[i];
            }
            Rbfn net = new Rbfn(X, ndata, nInpt, nOutp, neurons);
            net.trainLMS(X, Y, ndata, 10, 0.3);
            int[] obtained = new int[ndata];
            net.testClasification(X, ndata, obtained, Dtrn.getnclasses() - 1, 0);
            Dtrn.generateResultsClasification(outTrnFile, auxY, obtained);
            ProcDataset Dtst = new ProcDataset(tstFile, false);
            Dtst.processClassifierDataset();
            nInpt = Dtst.getninputs();
            nOutp = 1;
            ndata = Dtst.getndata();
            Y = new double[ndata][1];
            obtained = new int[ndata];
            X = Dtst.getX();
            auxY = Dtst.getC();
            for (i = 0; i < ndata; ++i) {
                Y[i][0] = auxY[i];
            }
            net.testClasification(X, ndata, obtained, Dtrn.getnclasses() - 1, 0);
            Dtst.generateResultsClasification(outTstFile, auxY, obtained);
            RBFUtils.createOutputFile(trnFile, outRbfFile);
            net.printRbfn(outRbfFile);
            System.out.println("- End of doRbfnCl. See results in output files named according to " + paramFile + " parameters file.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalError(e.toString());
        }
    }
}

