/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Rule_Learning.Prism;

import java.io.IOException;
import java.util.Arrays;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class Dataset {
    private double[][] X = null;
    private String[][] X2 = null;
    private boolean[][] missing = null;
    private int[] C = null;
    private String[] C2 = null;
    private double[] emaximo;
    private double[] eminimo;
    private int ndatos;
    private int nvariables;
    private int nentradas;
    private int nclases;
    static final boolean debug = false;
    private InstanceSet IS = new InstanceSet();
    private int[] comunes;

    public double[][] getX() {
        return this.X;
    }

    public String[][] getX2() {
        return this.X2;
    }

    public double[] getX(int pos) {
        return this.X[pos];
    }

    public InstanceSet getInstanceSet() {
        return this.IS;
    }

    public boolean hayInstanciasDeClaseC(int whichClass) throws ArrayIndexOutOfBoundsException {
        boolean resul = false;
        if (whichClass < 0 || whichClass >= this.nclases) {
            throw new ArrayIndexOutOfBoundsException("You are trying to access to " + whichClass + " class and there are only " + this.nclases + ".");
        }
        Instance[] instanceSet = this.IS.getInstances();
        for (int i = 0; i < this.IS.getNumInstances(); ++i) {
            int cadena = instanceSet[i].getOutputNominalValuesInt(0);
            if (cadena != whichClass) continue;
            resul = true;
        }
        return resul;
    }

    public int[] getC() {
        int[] retorno = new int[this.C.length];
        for (int i = 0; i < this.C.length; ++i) {
            retorno[i] = this.C[i];
        }
        return retorno;
    }

    public String[] getC2() {
        String[] retorno = new String[this.C2.length];
        for (int i = 0; i < this.C2.length; ++i) {
            retorno[i] = this.C2[i];
        }
        return retorno;
    }

    public double[] getemaximo() {
        return this.emaximo;
    }

    public double[] geteminimo() {
        return this.eminimo;
    }

    public int getndatos() {
        return this.ndatos;
    }

    public int getnvariables() {
        return this.nvariables;
    }

    public int getnentradas() {
        return this.nentradas;
    }

    public int getnclases() {
        return this.nclases;
    }

    public boolean isMissing(int i, int j) {
        return this.missing[i][j];
    }

    public void leeConjunto(String nfejemplos, boolean train) throws IOException {
        try {
            this.IS.readSet(nfejemplos, train);
            this.ndatos = this.IS.getNumInstances();
            this.nentradas = Attributes.getInputNumAttributes();
            this.nvariables = this.nentradas + Attributes.getOutputNumAttributes();
            if (Attributes.getOutputNumAttributes() > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
                System.exit(1);
            }
            boolean noOutputs = false;
            if (Attributes.getOutputNumAttributes() < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
                System.exit(1);
            }
            this.X = new double[this.ndatos][this.nentradas];
            this.X2 = new String[this.ndatos][this.nentradas];
            this.missing = new boolean[this.ndatos][this.nentradas];
            this.C = new int[this.ndatos];
            this.C2 = new String[this.ndatos];
            this.emaximo = new double[this.nentradas];
            this.eminimo = new double[this.nentradas];
            this.nclases = 0;
            for (int i = 0; i < this.ndatos; ++i) {
                Instance inst = this.IS.getInstance(i);
                for (int j = 0; j < this.nentradas; ++j) {
                    this.X2[i][j] = this.IS.getInputNominalValue(i, j);
                    this.X[i][j] = this.IS.getInputNumericValue(i, j);
                    this.missing[i][j] = inst.getInputMissingValues(j);
                    if (this.X[i][j] > this.emaximo[j] || i == 0) {
                        this.emaximo[j] = this.X[i][j];
                    }
                    if (!(this.X[i][j] < this.eminimo[j]) && i != 0) continue;
                    this.eminimo[j] = this.X[i][j];
                }
                if (noOutputs) {
                    this.C[i] = 0;
                } else {
                    this.C[i] = (int)this.IS.getOutputNumericValue(i, 0);
                    this.C2[i] = this.IS.getOutputNominalValue(i, 0);
                }
                if (this.C[i] <= this.nclases) continue;
                this.nclases = this.C[i];
            }
            ++this.nclases;
            System.out.println("Number of classes=" + this.nclases);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public String copiaCabeceraTest() {
        String p = new String("");
        p = "@relation " + Attributes.getRelationName() + "\n";
        p = p + Attributes.getInputAttributesHeader();
        p = p + Attributes.getOutputAttributesHeader();
        p = p + Attributes.getInputHeader() + "\n";
        p = p + Attributes.getOutputHeader() + "\n";
        p = p + "@data\n";
        return p;
    }

    public void normaliza() {
        int atts = this.getnentradas();
        double[] maximos = new double[atts];
        for (int j = 0; j < atts; ++j) {
            maximos[j] = 1.0 / (this.emaximo[j] - this.eminimo[j]);
        }
        for (int i = 0; i < this.getndatos(); ++i) {
            for (int j = 0; j < atts; ++j) {
                if (this.isMissing(i, j)) continue;
                this.X[i][j] = (this.X[i][j] - this.eminimo[j]) * maximos[j];
            }
        }
    }

    public int[] tiposVar() {
        int[] tipos = new int[this.nentradas];
        for (int i = 0; i < this.nentradas; ++i) {
            tipos[i] = 1;
            if (Attributes.getAttribute(i).getType() != 0) continue;
            tipos[i] = 0;
        }
        return tipos;
    }

    public void calculaMasComunes() {
        this.comunes = new int[this.nentradas];
        int[] aux = new int[this.ndatos];
        for (int i = 0; i < this.nentradas; ++i) {
            for (int j = 0; j < this.ndatos; ++j) {
                aux[j] = this.isMissing(j, i) ? -1 : (int)this.X[j][i];
            }
            Arrays.sort(aux);
            int mascomun = aux[0];
            int contador = 1;
            int j = 1;
            while (aux[j] == mascomun && j < this.ndatos - 1) {
                ++j;
                ++contador;
            }
            int contador2 = 1;
            int mascomun2 = aux[j];
            if (j + 1 < this.ndatos) {
                ++j;
                while (j < this.ndatos) {
                    if (aux[j] == mascomun2) {
                        ++contador2;
                    } else {
                        mascomun2 = aux[j];
                        if (contador2 > contador) {
                            contador = contador2;
                            mascomun = mascomun2;
                            contador2 = 1;
                        }
                    }
                    ++j;
                }
            }
            this.comunes[i] = mascomun;
        }
    }

    public int masComun(int i) {
        return this.comunes[i];
    }

    public String[] dameNombres() {
        String[] salida = new String[this.nvariables];
        for (int i = 0; i < this.nentradas; ++i) {
            salida[i] = Attributes.getInputAttribute(i).getName();
        }
        salida[this.nentradas] = Attributes.getOutputAttribute(0).getName();
        return salida;
    }

    public String[] dameClases() {
        String[] salida = new String[this.nclases];
        Attribute at = Attributes.getOutputAttribute(0);
        if (at.getType() == 0) {
            for (int i = 0; i < this.nclases; ++i) {
                salida[i] = at.getNominalValue(i);
            }
        } else {
            salida = null;
        }
        return salida;
    }

    public boolean hayAtributosContinuos() {
        return Attributes.hasRealAttributes();
    }

    public boolean hayAtributosDiscretos() {
        return Attributes.hasIntegerAttributes();
    }
}

