/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.GMCA;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.Distance;
import keel.Algorithms.Instance_Generation.utilities.Pair;

public class Cluster {
    static int i = 0;
    static int i2 = 0;
    PrototypeSet set;
    private Prototype representative;
    public int id = i2++;
    private double radius = 0.0;

    private void updateRepresentative() {
        this.representative = this.set.avg();
        this.representative.setIndex(i++);
    }

    public double d(Cluster c) {
        return Distance.d(this.representative, c.representative);
    }

    static double d(Cluster c1, Cluster c2) {
        return Distance.d(c1.representative, c2.representative);
    }

    private void updateRadius() {
        Pair<Prototype, Double> rr = this.set.radius(this.representative);
        this.radius = rr.second();
    }

    public Cluster(PrototypeSet s, Prototype representative) {
        this.set = s;
        this.representative = representative;
        this.updateRadius();
    }

    public Cluster(PrototypeSet s) {
        this.set = s;
        this.updateRepresentative();
        this.updateRadius();
    }

    public Cluster(Prototype p) {
        this.set = new PrototypeSet();
        this.set.add(p);
        this.representative = p;
        this.radius = 0.0;
    }

    public boolean remove(Prototype p) {
        boolean suc1 = this.set.remove(p);
        return suc1;
    }

    public void add(Prototype p) {
        this.set.add(p);
        this.updateRepresentative();
        this.updateRadius();
    }

    boolean isEmpty() {
        return this.set.isEmpty();
    }

    public Prototype getRepresentative() {
        return this.representative;
    }

    public Pair<Prototype, Double> getRadius() {
        return new Pair<Prototype, Double>(this.representative, this.radius);
    }

    public double getRadiusLength() {
        return this.radius;
    }

    public PrototypeSet getSet() {
        return this.set;
    }

    public PrototypeSet getPrototypeSet() {
        return this.getSet();
    }

    public double label() {
        return this.representative.label();
    }

    public double getLabel() {
        return this.representative.label();
    }

    public int size() {
        return this.set.size();
    }

    public Cluster mix(Cluster other) {
        PrototypeSet mergedSet = this.set.union(other.set);
        Cluster merged = new Cluster(mergedSet);
        return merged;
    }
}

