/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.RE_SL_Methods.MamWM;

import java.io.IOException;
import keel.Algorithms.RE_SL_Methods.MamWM.TTABLA;
import keel.Algorithms.RE_SL_Methods.MamWM.TipoIntervalo;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class MiDataset {
    public TTABLA[] datos;
    public int n_variables;
    public int n_var_estado;
    public int n_var_control;
    public int long_tabla;
    public int no_cubiertos;
    public TipoIntervalo[] extremos;
    public String fichero;
    public InstanceSet IS;
    public boolean noOutputs;
    public boolean salir;

    public MiDataset(String f, boolean train) {
        this.fichero = f;
        this.IS = new InstanceSet();
        try {
            this.processModelDataset(f, train);
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public void processModelDataset(String nfejemplos, boolean train) throws IOException {
        try {
            int i;
            this.IS.readSet(nfejemplos, train);
            this.long_tabla = this.IS.getNumInstances();
            this.n_var_estado = Attributes.getInputNumAttributes();
            this.n_var_control = Attributes.getOutputNumAttributes();
            this.no_cubiertos = this.long_tabla;
            if (this.n_var_control > 1) {
                System.out.println("This algorithm can not process MIMO datasets");
                System.out.println("All outputs but the first one will be removed");
            }
            boolean noOutputs = false;
            if (this.n_var_control < 1) {
                System.out.println("This algorithm can not process datasets without outputs");
                System.out.println("Zero-valued output generated");
                noOutputs = true;
            }
            this.n_var_control = 1;
            this.n_variables = this.n_var_estado + this.n_var_control;
            this.datos = new TTABLA[this.long_tabla];
            this.extremos = new TipoIntervalo[this.n_variables];
            for (i = 0; i < this.n_variables; ++i) {
                this.extremos[i] = new TipoIntervalo();
            }
            this.salir = false;
            int k = 0;
            for (i = 0; i < this.long_tabla; ++i) {
                int j;
                Instance inst = this.IS.getInstance(i);
                if (inst.existsAnyMissingValue()) {
                    System.out.println("This algorithm can not process missing values");
                    System.out.println("This algorithm don't use the instance " + (i + 1) + ". You have to apply before a preprocess method");
                    continue;
                }
                this.datos[k] = new TTABLA(this.n_variables);
                for (j = 0; j < this.n_var_estado; ++j) {
                    this.datos[k].ejemplo[j] = this.IS.getInputNumericValue(i, j);
                    if (this.datos[k].ejemplo[j] > this.extremos[j].max || k == 0) {
                        this.extremos[j].max = this.datos[k].ejemplo[j];
                    }
                    if (!(this.datos[k].ejemplo[j] < this.extremos[j].min) && k != 0) continue;
                    this.extremos[j].min = this.datos[k].ejemplo[j];
                }
                this.datos[k].ejemplo[j] = noOutputs ? 0.0 : this.IS.getOutputNumericValue(i, 0);
                if (this.datos[k].ejemplo[j] > this.extremos[j].max || k == 0) {
                    this.extremos[j].max = this.datos[k].ejemplo[j];
                }
                if (this.datos[k].ejemplo[j] < this.extremos[j].min || k == 0) {
                    this.extremos[j].min = this.datos[k].ejemplo[j];
                }
                ++k;
            }
            this.long_tabla = k;
        }
        catch (Exception e) {
            System.out.println("DBG: Exception in readSet");
            e.printStackTrace();
        }
    }

    public String getCabecera() {
        return this.IS.getHeader();
    }
}

