/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.PSO_ACO;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Atributo;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.ComparadorCondicion;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.ComparadorRegla;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Condicion;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Muestra;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;

public class Regla {
    private Vector cNominales;
    private Vector cContinuos;
    private Atributo clase;
    private float calidad;
    private static ComparadorRegla c;
    private int numeroMuestrasCubiertas;

    public Regla() {
        this.cNominales = new Vector();
        this.cContinuos = new Vector();
        this.clase = new Atributo();
        c = new ComparadorRegla();
        this.calidad = 0.0f;
        this.numeroMuestrasCubiertas = 0;
    }

    public Regla(Regla regla) {
        c = new ComparadorRegla();
        this.cNominales = new Vector(regla.cNominales);
        this.cContinuos = new Vector(regla.cContinuos);
        this.clase = new Atributo(regla.clase);
        this.calidad = regla.calidad;
        this.numeroMuestrasCubiertas = regla.numeroMuestrasCubiertas;
    }

    public Regla(Vector continuos, Vector nominales, Atributo claseOriginal) {
        this.cContinuos = new Vector(continuos);
        this.cNominales = new Vector(nominales);
        this.clase = claseOriginal;
        c = new ComparadorRegla();
        this.numeroMuestrasCubiertas = 0;
    }

    public void insertarCondicionNominal(Condicion original) {
        this.cNominales.addElement(original);
    }

    public void insertarCondicionContinua(Condicion original) {
        this.cContinuos.addElement(original);
    }

    public void insertarClase(Atributo original) {
        this.clase = original;
    }

    public void ordenaCondiciones() {
        ComparadorCondicion c = Condicion.getComparadorCondiciones();
        Collections.sort(this.cNominales, c);
        Collections.sort(this.cContinuos, c);
    }

    public void asignarCalidad(float original) {
        this.calidad = original;
    }

    public boolean cubreMuestraTotal(Muestra ejemplo) {
        int columnaComprobar;
        Atributo condicionComprobar;
        Condicion condicionActual;
        int i;
        int numCondicionesNominales = this.cNominales.size();
        int numCondicionesContinuos = this.cContinuos.size();
        for (i = 0; i < numCondicionesNominales; ++i) {
            condicionActual = (Condicion)this.cNominales.get(i);
            if (condicionActual.cubre(condicionComprobar = ejemplo.getValor(columnaComprobar = condicionActual.getIndice()))) continue;
            return false;
        }
        for (i = 0; i < numCondicionesContinuos; ++i) {
            condicionActual = (Condicion)this.cContinuos.get(i);
            if (condicionActual.cubre(condicionComprobar = ejemplo.getValor(columnaComprobar = condicionActual.getIndice()))) continue;
            return false;
        }
        return ejemplo.getClase().esIgual(this.clase);
    }

    public boolean estanCondicionesEn(Muestra ejemplo) {
        int columnaComprobar;
        Atributo condicionComprobar;
        Condicion condicionActual;
        int i;
        int numCondicionesNominales = this.cNominales.size();
        int numCondicionesContinuos = this.cContinuos.size();
        for (i = 0; i < numCondicionesNominales; ++i) {
            condicionActual = (Condicion)this.cNominales.get(i);
            if (condicionActual.cubre(condicionComprobar = ejemplo.getValor(columnaComprobar = condicionActual.getIndice()))) continue;
            return false;
        }
        for (i = 0; i < numCondicionesContinuos; ++i) {
            condicionActual = (Condicion)this.cContinuos.get(i);
            if (condicionActual.cubre(condicionComprobar = ejemplo.getValor(columnaComprobar = condicionActual.getIndice()))) continue;
            return false;
        }
        return true;
    }

    public Atributo obtenerReglaPredicha() {
        return this.clase;
    }

    public Vector listaCondicionesNominales() {
        Vector devolver = new Vector(this.cNominales);
        return devolver;
    }

    public Vector listaCondicionesContinuos() {
        Vector devolver = new Vector(this.cContinuos);
        return devolver;
    }

    public float obtenerCalidad() {
        return this.calidad;
    }

    public int obtenerNumCondicionesContinuas() {
        int devolver = this.cContinuos.size();
        return devolver;
    }

    public int obtenerNumCondicionesNominales() {
        int devolver = this.cNominales.size();
        return devolver;
    }

    public void insertaCondicionesNominales(Vector atributos) {
        this.cNominales = new Vector(atributos);
    }

    public void insertaCondicionesContinuos(Vector atributos) {
        this.cContinuos = new Vector(atributos);
    }

    public void eliminaCondicionNominal(Condicion condicion) {
        this.cNominales.remove(condicion);
    }

    public void eliminaCondicionContinuos(Condicion condicion) {
        this.cContinuos.remove(condicion);
    }

    public static ComparadorRegla obtenerComparador() {
        return c;
    }

    public void copia(Regla regla) {
        Condicion copia;
        Condicion original;
        int i;
        this.cNominales.clear();
        this.cContinuos.clear();
        for (i = 0; i < regla.cNominales.size(); ++i) {
            original = (Condicion)regla.cNominales.get(i);
            copia = new Condicion(original);
            this.cNominales.addElement(copia);
        }
        for (i = 0; i < regla.cContinuos.size(); ++i) {
            original = (Condicion)regla.cContinuos.get(i);
            copia = new Condicion(original);
            this.cContinuos.addElement(copia);
        }
        this.clase = new Atributo(regla.clase);
        this.calidad = regla.calidad;
    }

    public void eliminaCondicionNominal(int indice, Condicion nueva) {
        this.cNominales.remove(indice);
        this.cNominales.insertElementAt(nueva, indice);
    }

    public void eliminaCondicionContinuos(int indice, Condicion nueva) {
        this.cContinuos.remove(indice);
        this.cContinuos.insertElementAt(nueva, indice);
    }

    public void eliminaUltimaCondicionNominal() {
        this.cNominales.remove(this.cNominales.size() - 1);
    }

    public void eliminaUltimaCondicionContinua() {
        this.cContinuos.remove(this.cContinuos.size() - 1);
    }

    public Condicion getCondicionNominal(int indice) {
        Condicion devolver = (Condicion)this.cNominales.get(indice);
        return devolver;
    }

    public Condicion getCondicionContinua(int indice) {
        Condicion devolver = (Condicion)this.cContinuos.get(indice);
        return devolver;
    }

    public void setCondicionNominal(int indice, Condicion co) {
        this.cNominales.set(indice, co);
    }

    public void setCondicionContinua(int indice, Condicion co) {
        this.cContinuos.set(indice, co);
    }

    public void eliminaCondicionesNominales() {
        this.cNominales = new Vector();
    }

    public void imprime(int numCondiciones) {
        float valor2;
        float valor;
        String nombre;
        Vector nombres;
        Attribute actual;
        int indice;
        Condicion co;
        int i;
        Attribute[] listaAtributos = Attributes.getInputAttributes();
        for (i = 0; i < this.cNominales.size() - 1; ++i) {
            co = (Condicion)this.cNominales.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombres = actual.getNominalValuesList();
            nombre = actual.getName();
            valor = co.getValor().getValor();
            System.out.print(nombre + " = < " + valor + " > AND ");
        }
        if (numCondiciones > 0 && i > 0) {
            co = (Condicion)this.cNominales.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombres = actual.getNominalValuesList();
            nombre = actual.getName();
            valor = co.getValor().getValor();
            System.out.print(nombre + " = < " + valor + " > AND ");
        }
        if (numCondiciones == 0 && i > 0) {
            co = (Condicion)this.cNominales.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombres = actual.getNominalValuesList();
            nombre = actual.getName();
            valor = co.getValor().getValor();
            System.out.print(nombre + " = < " + valor + " >");
        }
        for (i = 0; i < this.cContinuos.size() - 2 && numCondiciones > 0; ++i) {
            co = (Condicion)this.cContinuos.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombre = actual.getName();
            valor = co.getValor().getValor();
            co = (Condicion)this.cContinuos.get(++i);
            valor2 = co.getValor().getValor();
            System.out.print(nombre + " = [ " + valor + " , " + valor2 + " ] AND ");
        }
        if (numCondiciones > 0) {
            co = (Condicion)this.cContinuos.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombre = actual.getName();
            valor = co.getValor().getValor();
            co = (Condicion)this.cContinuos.get(++i);
            valor2 = co.getValor().getValor();
            ++i;
            System.out.print(nombre + " = [ " + valor + " , " + valor2 + " ]");
        }
        valor = this.clase.getValor();
        listaAtributos = Attributes.getOutputAttributes();
        actual = listaAtributos[0];
        Vector nombresClases = actual.getNominalValuesList();
        nombre = (String)nombresClases.get((int)valor);
        System.out.print(" ==> " + nombre);
        System.out.println("   ( " + this.calidad + " )");
    }

    public void imprimeFichero(int numCondiciones, PrintStream salida) {
        float valor2;
        float valor;
        String nombre;
        Vector nombres;
        Attribute actual;
        int indice;
        Condicion co;
        int i;
        Attribute[] listaAtributos = Attributes.getInputAttributes();
        for (i = 0; i < this.cNominales.size() - 1; ++i) {
            co = (Condicion)this.cNominales.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombres = actual.getNominalValuesList();
            nombre = actual.getName();
            valor = co.getValor().getValor();
            salida.print(nombre + " = < " + valor + " > AND ");
        }
        if (numCondiciones > 0 && i > 0) {
            co = (Condicion)this.cNominales.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombres = actual.getNominalValuesList();
            nombre = actual.getName();
            valor = co.getValor().getValor();
            salida.print(nombre + " = < " + valor + " > AND ");
        }
        if (numCondiciones == 0 && i > 0) {
            co = (Condicion)this.cNominales.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombres = actual.getNominalValuesList();
            nombre = actual.getName();
            valor = co.getValor().getValor();
            salida.print(nombre + " = < " + valor + " >");
        }
        for (i = 0; i < this.cContinuos.size() - 2 && numCondiciones > 0; ++i) {
            co = (Condicion)this.cContinuos.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombre = actual.getName();
            valor = co.getValor().getValor();
            co = (Condicion)this.cContinuos.get(++i);
            valor2 = co.getValor().getValor();
            salida.print(nombre + " = [ " + valor + " , " + valor2 + " ] AND ");
        }
        if (numCondiciones > 0) {
            co = (Condicion)this.cContinuos.get(i);
            indice = co.getIndice();
            actual = listaAtributos[indice];
            nombre = actual.getName();
            valor = co.getValor().getValor();
            co = (Condicion)this.cContinuos.get(++i);
            valor2 = co.getValor().getValor();
            ++i;
            salida.print(nombre + " = [ " + valor + " , " + valor2 + " ]");
        }
        valor = this.clase.getValor();
        listaAtributos = Attributes.getOutputAttributes();
        actual = listaAtributos[0];
        Vector nombresClases = actual.getNominalValuesList();
        nombre = (String)nombresClases.get((int)valor);
        salida.print(" ==> " + nombre);
        salida.println("   ( " + this.calidad + " )");
    }

    public Atributo prediccion(Muestra mt) {
        if (this.estanCondicionesEn(mt)) {
            return this.clase;
        }
        return null;
    }

    public void limpiaCNominales() {
        this.cNominales = new Vector();
    }

    public void asignarNumeroMuestrasCubiertas(int num) {
        this.numeroMuestrasCubiertas = num;
    }

    public int obtenerNumeroMuestrasCubiertas() {
        return this.numeroMuestrasCubiertas;
    }
}

