/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.compiler;

import org.drools.compiler.compiler.ProcessBuilder;
import org.drools.compiler.compiler.ProcessBuilderFactoryService;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.utils.ServiceRegistryImpl;

public class ProcessBuilderFactory {
    private static final String PROVIDER_CLASS = "org.jbpm.process.builder.ProcessBuilderFactoryServiceImpl";
    private static IllegalArgumentException initializationException;
    private static ProcessBuilderFactoryService provider;

    public static ProcessBuilder newProcessBuilder(KnowledgeBuilder kBuilder) {
        return ProcessBuilderFactory.getProcessBuilderFactoryService().newProcessBuilder(kBuilder);
    }

    public static synchronized void setProcessBuilderFactoryService(ProcessBuilderFactoryService provider) {
        ProcessBuilderFactory.provider = provider;
    }

    public static synchronized ProcessBuilderFactoryService getProcessBuilderFactoryService() {
        if (provider == null && !ProcessBuilderFactory.initialized()) {
            try {
                ProcessBuilderFactory.loadProvider();
            }
            catch (IllegalArgumentException e) {
                initializationException = e;
            }
        }
        if (initializationException != null) {
            throw initializationException;
        }
        return provider;
    }

    private static void loadProvider() {
        ServiceRegistryImpl.getInstance().addDefault(ProcessBuilderFactoryService.class, PROVIDER_CLASS);
        ProcessBuilderFactory.setProcessBuilderFactoryService((ProcessBuilderFactoryService)ServiceRegistryImpl.getInstance().get(ProcessBuilderFactoryService.class));
    }

    public static synchronized void loadProvider(ClassLoader cl) {
        if (provider == null) {
            try {
                provider = (ProcessBuilderFactoryService)Class.forName(PROVIDER_CLASS, true, cl).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean initialized() {
        return initializationException != null;
    }

    public static synchronized void resetInitialization() {
        initializationException = null;
    }
}

