/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.common.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import uno.informatics.common.io.RowReader;
import uno.informatics.common.io.RowWriter;
import uno.informatics.common.io.text.TextFileRowReader;
import uno.informatics.common.io.text.TextFileRowWriter;
import uno.informatics.data.io.FileType;

public class IOUtilities {
    public static final RowReader createRowReader(Path filePath, FileType type, int ... options) throws IOException {
        return IOUtilities.createRowReader(filePath, type, null, options);
    }

    public static final RowReader createRowReader(Path path, FileType type, DateFormat dateFormat, int ... options) throws IOException {
        TextFileRowReader reader = null;
        switch (type) {
            case CSV: {
                TextFileRowReader textFileRowStringReader = new TextFileRowReader(path);
                textFileRowStringReader.setDelimiterString(",");
                if (dateFormat != null) {
                    textFileRowStringReader.setDateFormat(dateFormat);
                }
                textFileRowStringReader.setOptions(IOUtilities.getOptions(options));
                reader = textFileRowStringReader;
                break;
            }
            case TXT: {
                TextFileRowReader textFileRowStringReader = new TextFileRowReader(path);
                textFileRowStringReader.setDelimiterString("\t");
                if (dateFormat != null) {
                    textFileRowStringReader.setDateFormat(dateFormat);
                }
                textFileRowStringReader.setOptions(IOUtilities.getOptions(options));
                reader = textFileRowStringReader;
                break;
            }
            case XLS: {
                throw new IOException("XLS Type not supported");
            }
            case XLSX: {
                throw new IOException("XLSX Type not supported");
            }
        }
        return reader;
    }

    public static final RowReader createRowReader(BufferedReader bufferedReader, FileType type, int ... options) throws IOException {
        return IOUtilities.createRowReader(bufferedReader, type, null, options);
    }

    public static RowReader createRowReader(BufferedReader bufferedReader, FileType type, DateFormat dateFormat, int ... options) throws IOException {
        TextFileRowReader reader = null;
        switch (type) {
            case CSV: {
                TextFileRowReader textFileRowStringReader = new TextFileRowReader(bufferedReader);
                textFileRowStringReader.setDelimiterString(",");
                if (dateFormat != null) {
                    textFileRowStringReader.setDateFormat(dateFormat);
                }
                textFileRowStringReader.setOptions(IOUtilities.getOptions(options));
                reader = textFileRowStringReader;
                break;
            }
            case TXT: {
                TextFileRowReader textFileRowStringReader = new TextFileRowReader(bufferedReader);
                textFileRowStringReader.setDelimiterString("\t");
                if (dateFormat != null) {
                    textFileRowStringReader.setDateFormat(dateFormat);
                }
                textFileRowStringReader.setOptions(IOUtilities.getOptions(options));
                reader = textFileRowStringReader;
                break;
            }
            case XLS: {
                throw new IOException("XLS Type not supported");
            }
            case XLSX: {
                throw new IOException("XLSX Type not supported");
            }
        }
        return reader;
    }

    public static final RowWriter createRowWriter(Path filePath, FileType type, int ... options) throws IOException {
        return IOUtilities.createRowWriter(filePath, type, null, options);
    }

    public static final RowWriter createRowWriter(Path filePath, FileType type, DateFormat dateFormat, int ... options) throws IOException {
        TextFileRowWriter writer = null;
        switch (type) {
            case CSV: {
                TextFileRowWriter textFileRowStringWriter = new TextFileRowWriter(filePath);
                textFileRowStringWriter.setDelimiterString(",");
                if (dateFormat != null) {
                    textFileRowStringWriter.setDateFormat(dateFormat);
                }
                textFileRowStringWriter.setOptions(IOUtilities.getOptions(options));
                writer = textFileRowStringWriter;
                break;
            }
            case TXT: {
                TextFileRowWriter textFileRowStringWriter = new TextFileRowWriter(filePath);
                textFileRowStringWriter.setDelimiterString("\t");
                if (dateFormat != null) {
                    textFileRowStringWriter.setDateFormat(dateFormat);
                }
                textFileRowStringWriter.setOptions(IOUtilities.getOptions(options));
                writer = textFileRowStringWriter;
                break;
            }
            case XLS: {
                throw new IOException("XLS Type not supported");
            }
            case XLSX: {
                throw new IOException("XLSX Type not supported");
            }
        }
        return writer;
    }

    public static final RowWriter createRowWriter(BufferedWriter bufferedWriter, FileType type, int ... options) throws IOException {
        return IOUtilities.createRowWriter(bufferedWriter, type, null, options);
    }

    public static final RowWriter createRowWriter(BufferedWriter bufferedWriter, FileType type, DateFormat dateFormat, int ... options) throws IOException {
        TextFileRowWriter writer = null;
        switch (type) {
            case CSV: {
                TextFileRowWriter textFileRowStringWriter = new TextFileRowWriter(bufferedWriter);
                textFileRowStringWriter.setDelimiterString(",");
                if (dateFormat != null) {
                    textFileRowStringWriter.setDateFormat(dateFormat);
                }
                textFileRowStringWriter.setOptions(IOUtilities.getOptions(options));
                writer = textFileRowStringWriter;
                break;
            }
            case TXT: {
                TextFileRowWriter textFileRowStringWriter = new TextFileRowWriter(bufferedWriter);
                textFileRowStringWriter.setDelimiterString("\t");
                if (dateFormat != null) {
                    textFileRowStringWriter.setDateFormat(dateFormat);
                }
                textFileRowStringWriter.setOptions(IOUtilities.getOptions(options));
                writer = textFileRowStringWriter;
                break;
            }
            case XLS: {
                throw new IOException("XLS Type not supported");
            }
            case XLSX: {
                throw new IOException("XLSX Type not supported");
            }
        }
        return writer;
    }

    public static final List<String> getSheets(Path filePath, FileType type, int ... options) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("File path not defined.");
        }
        if (!filePath.toFile().exists()) {
            throw new IOException("File does not exist : " + filePath + ".");
        }
        if (type == null) {
            throw new IllegalArgumentException("File type not defined.");
        }
        if (type != FileType.TXT && type != FileType.CSV) {
            throw new IllegalArgumentException(String.format("Only file types TXT and CSV are supported. Got: %s.", new Object[]{type}));
        }
        switch (type) {
            case CSV: {
                return new ArrayList<String>();
            }
            case TXT: {
                return new ArrayList<String>();
            }
            case XLS: {
                return new ArrayList<String>();
            }
            case XLSX: {
                return new ArrayList<String>();
            }
        }
        return new ArrayList<String>();
    }

    private static final int getOptions(int ... options) {
        int combinedOptions = 0;
        for (int i = 0; i < options.length; ++i) {
            combinedOptions |= options[i];
        }
        return combinedOptions;
    }
}

