/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import optimization.Uncmin_f77;
import optimization.Uncmin_methods;
import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.JohnsonSystem;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.RootFinder;

public class JohnsonSLDist
extends JohnsonSystem {
    private static double[] initPar(double[] x, int n, double xmin) {
        double t;
        double v;
        int j;
        double sum = 0.0;
        for (j = 0; j < n; ++j) {
            sum += x[j];
        }
        double mean = sum / (double)n;
        double sum3 = 0.0;
        sum = 0.0;
        for (j = 0; j < n; ++j) {
            v = x[j] - mean;
            sum += v * v;
            sum3 += v * v * v;
        }
        double m2 = sum / (double)n;
        double m3 = sum3 / (double)n;
        v = m3 / Math.pow(m2, 1.5);
        Function f = new Function(v);
        double t0 = 0.0;
        double tlim = Math.cbrt(v);
        if (tlim <= 0.0) {
            t0 = tlim;
            tlim = 10.0;
        }
        if ((t = RootFinder.brentDekker(t0, tlim, f, 1.0E-5)) <= 0.0) {
            throw new UnsupportedOperationException("t <= 0;   no MLE");
        }
        double xi = mean - Math.sqrt(m2 / t);
        if (xi >= xmin) {
            xi = xmin - 0.1;
        }
        v = 1.0 + m2 / ((mean - xi) * (mean - xi));
        double delta = 1.0 / Math.sqrt(Math.log(v));
        v = Math.sqrt(v);
        double lambda = (mean - xi) / v;
        double[] param = new double[]{delta, xi, lambda};
        return param;
    }

    public JohnsonSLDist(double gamma, double delta) {
        this(gamma, delta, 0.0, 1.0);
    }

    public JohnsonSLDist(double gamma, double delta, double xi, double lambda) {
        super(gamma, delta, xi, lambda);
        this.setLastParams(xi);
    }

    private void setLastParams(double xi) {
        this.supportA = xi;
    }

    public double density(double x) {
        return JohnsonSLDist.density(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double cdf(double x) {
        return JohnsonSLDist.cdf(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double barF(double x) {
        return JohnsonSLDist.barF(this.gamma, this.delta, this.xi, this.lambda, x);
    }

    public double inverseF(double u) {
        return JohnsonSLDist.inverseF(this.gamma, this.delta, this.xi, this.lambda, u);
    }

    public double getMean() {
        return JohnsonSLDist.getMean(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getVariance() {
        return JohnsonSLDist.getVariance(this.gamma, this.delta, this.xi, this.lambda);
    }

    public double getStandardDeviation() {
        return JohnsonSLDist.getStandardDeviation(this.gamma, this.delta, this.xi, this.lambda);
    }

    public static double density(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi) {
            return 0.0;
        }
        double y = (x - xi) / lambda;
        double z = gamma + delta * Math.log(y);
        if (z >= 1.0E10) {
            return 0.0;
        }
        return delta * Math.exp(-z * z / 2.0) / (lambda * y * Math.sqrt(Math.PI * 2));
    }

    public static double cdf(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi) {
            return 0.0;
        }
        double y = (x - xi) / lambda;
        double z = gamma + delta * Math.log(y);
        return NormalDist.cdf01(z);
    }

    public static double barF(double gamma, double delta, double xi, double lambda, double x) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (x <= xi) {
            return 1.0;
        }
        double y = (x - xi) / lambda;
        double z = gamma + delta * Math.log(y);
        return NormalDist.barF01(z);
    }

    public static double inverseF(double gamma, double delta, double xi, double lambda, double u) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        if (u > 1.0 || u < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return xi;
        }
        double z = NormalDist.inverseF01(u);
        double t = (z - gamma) / delta;
        if (t >= 709.782712893384) {
            return Double.POSITIVE_INFINITY;
        }
        if (t <= -707.7032713517042) {
            return xi;
        }
        return xi + lambda * Math.exp(t);
    }

    public static double[] getMLE(double[] x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        double xmin = Double.MAX_VALUE;
        for (int j = 0; j < n; ++j) {
            if (!(x[j] < xmin)) continue;
            xmin = x[j];
        }
        double[] paramIn = new double[3];
        paramIn = JohnsonSLDist.initPar(x, n, xmin);
        double[] paramOpt = new double[4];
        for (int i = 0; i < 3; ++i) {
            paramOpt[i + 1] = paramIn[i];
        }
        Optim system = new Optim(x, n, xmin);
        double[] xpls = new double[4];
        double[] fpls = new double[4];
        double[] gpls = new double[4];
        int[] itrcmd = new int[2];
        double[][] a = new double[4][4];
        double[] udiag = new double[4];
        Uncmin_f77.optif0_f77((int)3, (double[])paramOpt, (Uncmin_methods)system, (double[])xpls, (double[])fpls, (double[])gpls, (int[])itrcmd, (double[][])a, (double[])udiag);
        double[] param = new double[4];
        param[0] = 0.0;
        for (int i = 1; i <= 3; ++i) {
            param[i] = xpls[i];
        }
        return param;
    }

    public static JohnsonSLDist getInstanceFromMLE(double[] x, int n) {
        double[] param = JohnsonSLDist.getMLE(x, n);
        return new JohnsonSLDist(0.0, param[0], param[1], param[2]);
    }

    public static double getMean(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double t = 1.0 / (2.0 * delta * delta) - gamma / delta;
        return xi + lambda * Math.exp(t);
    }

    public static double getVariance(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        double t = 1.0 / (delta * delta) - 2.0 * gamma / delta;
        return lambda * lambda * Math.exp(t) * (Math.exp(1.0 / (delta * delta)) - 1.0);
    }

    public static double getStandardDeviation(double gamma, double delta, double xi, double lambda) {
        return Math.sqrt(JohnsonSLDist.getVariance(gamma, delta, xi, lambda));
    }

    public void setParams(double gamma, double delta, double xi, double lambda) {
        this.setParams0(gamma, delta, xi, lambda);
        this.setLastParams(xi);
    }

    private static class Optim
    implements Uncmin_methods {
        private int n;
        private double[] X;
        private double xmin;
        private static final double BARRIER = 1.0E100;

        public Optim(double[] X, int n, double xmin) {
            this.n = n;
            this.X = X;
            this.xmin = xmin;
        }

        public double f_to_minimize(double[] par) {
            double delta = par[1];
            double xi = par[2];
            double lambda = par[3];
            if (delta <= 0.0 || lambda <= 0.0) {
                return 1.0E100;
            }
            if (xi >= this.xmin) {
                return 1.0E100;
            }
            double loglam = Math.log(lambda);
            double sumv = 0.0;
            double sumz = 0.0;
            for (int j = 0; j < this.n; ++j) {
                double v = Math.log(this.X[j] - xi);
                double z = delta * (v - loglam);
                sumv += v;
                sumz += z * z;
            }
            return sumv + sumz / 2.0 - (double)this.n * Math.log(delta);
        }

        public void gradient(double[] x, double[] g) {
        }

        public void hessian(double[] x, double[][] h) {
        }
    }

    private static class Function
    implements MathFunction {
        protected double a;

        public Function(double sb1) {
            this.a = sb1;
        }

        public double evaluate(double t) {
            return t * t * t - 3.0 * t - this.a;
        }
    }
}

