/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.lookandfeel;

import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;

public class ExtendedListUI
extends BasicListUI {
    private PropertyChangeDelegate delegate = null;
    private MouseHandler handler = null;
    private boolean dndStartOnExit = false;

    public ExtendedListUI(JList jList) {
        this.list = jList;
    }

    public void setDragAndDropStartOnExit(boolean bl) {
        this.dndStartOnExit = bl;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent instanceof JList) {
            return new ExtendedListUI((JList)jComponent);
        }
        return BasicListUI.createUI(jComponent);
    }

    @Override
    protected void installListeners() {
        int n;
        super.installListeners();
        MouseListener[] mouseListenerArray = this.list.getMouseListeners();
        MouseMotionListener[] mouseMotionListenerArray = this.list.getMouseMotionListeners();
        for (n = 0; n < mouseListenerArray.length; ++n) {
            if (!mouseListenerArray[n].getClass().getPackage().getName().startsWith("javax.swing.plaf")) continue;
            this.list.removeMouseListener(mouseListenerArray[n]);
        }
        for (n = 0; n < mouseMotionListenerArray.length; ++n) {
            if (!mouseMotionListenerArray[n].getClass().getPackage().getName().startsWith("javax.swing.plaf")) continue;
            this.list.removeMouseMotionListener(mouseMotionListenerArray[n]);
        }
        this.handler = new MouseHandler();
        this.list.addMouseListener(this.handler);
        this.list.addMouseMotionListener(this.handler);
        this.list.setDropTarget(new SimpleDropTarget());
        PropertyChangeListener[] propertyChangeListenerArray = this.list.getPropertyChangeListeners();
        boolean bl = false;
        for (int i = 0; i < propertyChangeListenerArray.length && !bl; ++i) {
            bl = propertyChangeListenerArray[i].getClass().getPackage().getName().startsWith("javax.swing.plaf");
            if (!bl) continue;
            PropertyChangeListener propertyChangeListener = propertyChangeListenerArray[i];
            this.list.removePropertyChangeListener(propertyChangeListener);
            this.delegate = new PropertyChangeDelegate(propertyChangeListener);
            this.list.addPropertyChangeListener(this.delegate);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.list.removePropertyChangeListener(this.delegate);
        this.list.removeMouseListener(this.handler);
        this.list.removeMouseMotionListener(this.handler);
    }

    protected class MouseHandler
    implements MouseInputListener {
        private int indexOnPress = -1;
        private MouseEvent dndArmedEvent = null;
        private int motionThreshold;
        private boolean checkedMotionThreshold = false;
        private boolean mouseExited = false;

        protected MouseHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (ExtendedListUI.this.dndStartOnExit && !this.mouseExited) {
                return;
            }
            if (this.shouldIgnore2(mouseEvent)) {
                return;
            }
            if (this.dndArmedEvent != null) {
                int n = this.mapDragOperationFromModifiers(mouseEvent);
                if (n == 0) {
                    return;
                }
                int n2 = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
                int n3 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY());
                if (n2 > this.getMotionThreshold() || n3 > this.getMotionThreshold()) {
                    JComponent jComponent = this.getComponent(mouseEvent);
                    TransferHandler transferHandler = jComponent.getTransferHandler();
                    transferHandler.exportAsDrag(jComponent, this.dndArmedEvent, n);
                    this.dndArmedEvent = null;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.mouseExited = true;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            block10: {
                block9: {
                    this.mouseExited = false;
                    if (this.shouldIgnore(mouseEvent)) {
                        return;
                    }
                    this.indexOnPress = ExtendedListUI.this.list.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
                    if (this.indexOnPress <= -1) break block9;
                    this.dndArmedEvent = mouseEvent;
                    if (!ExtendedListUI.this.list.hasFocus() && ExtendedListUI.this.list.isRequestFocusEnabled()) {
                        ExtendedListUI.this.list.requestFocus();
                    }
                    switch (ExtendedListUI.this.list.getSelectionMode()) {
                        case 0: {
                            ExtendedListUI.this.list.setSelectedIndex(this.indexOnPress);
                            break;
                        }
                        default: {
                            if (!mouseEvent.isControlDown()) {
                                if (mouseEvent.isShiftDown()) {
                                    int n = ExtendedListUI.this.list.getAnchorSelectionIndex();
                                    ExtendedListUI.this.list.getSelectionModel().clearSelection();
                                    if (this.indexOnPress > n) {
                                        ExtendedListUI.this.list.getSelectionModel().addSelectionInterval(n, this.indexOnPress);
                                        break;
                                    }
                                    ExtendedListUI.this.list.getSelectionModel().addSelectionInterval(this.indexOnPress, n);
                                    break;
                                }
                                if (!ExtendedListUI.this.list.isSelectedIndex(this.indexOnPress)) {
                                    ExtendedListUI.this.list.setSelectedIndex(this.indexOnPress);
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                break;
                            }
                        }
                    }
                    break block10;
                }
                this.dndArmedEvent = null;
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isShiftDown()) {
                return;
            }
            int n = ExtendedListUI.this.list.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
            if (mouseEvent.isControlDown()) {
                switch (ExtendedListUI.this.list.getSelectionMode()) {
                    case 1: {
                        int n2 = ExtendedListUI.this.list.getSelectionModel().getMinSelectionIndex();
                        int n3 = ExtendedListUI.this.list.getSelectionModel().getMaxSelectionIndex();
                        if (ExtendedListUI.this.list.isSelectedIndex(n)) {
                            if (n != n2 && n != n3) break;
                            ExtendedListUI.this.list.getSelectionModel().addSelectionInterval(n, n);
                            break;
                        }
                        if (n != n2 - 1 && n != n3 + 1) break;
                        ExtendedListUI.this.list.getSelectionModel().addSelectionInterval(n, n);
                        break;
                    }
                    case 2: {
                        if (ExtendedListUI.this.list.isSelectedIndex(n)) {
                            ExtendedListUI.this.list.getSelectionModel().removeSelectionInterval(n, n);
                            break;
                        }
                        ExtendedListUI.this.list.getSelectionModel().addSelectionInterval(n, n);
                    }
                }
            } else if (ExtendedListUI.this.list.isSelectedIndex(n) && !SwingUtilities.isRightMouseButton(mouseEvent)) {
                ExtendedListUI.this.list.setSelectedIndex(n);
            }
        }

        private int getMotionThreshold() {
            if (this.checkedMotionThreshold) {
                return this.motionThreshold;
            }
            this.checkedMotionThreshold = true;
            try {
                this.motionThreshold = (Integer)Toolkit.getDefaultToolkit().getDesktopProperty("DnD.gestureMotionThreshold");
            }
            catch (Exception exception) {
                this.motionThreshold = 5;
            }
            return this.motionThreshold;
        }

        protected int mapDragOperationFromModifiers(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                JComponent jComponent = this.getComponent(mouseEvent);
                TransferHandler transferHandler = jComponent.getTransferHandler();
                return transferHandler.getSourceActions(jComponent);
            }
            return 0;
        }

        protected JComponent getComponent(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                return jComponent;
            }
            return null;
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !ExtendedListUI.this.list.isEnabled();
        }

        private boolean shouldIgnore2(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !ExtendedListUI.this.list.getDragEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || !ExtendedListUI.this.list.isEnabled();
        }
    }

    public class SimpleDropTarget
    extends DropTarget
    implements UIResource {
        @Override
        public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    public class PropertyChangeDelegate
    implements PropertyChangeListener {
        private PropertyChangeListener delegate;

        public PropertyChangeDelegate(PropertyChangeListener propertyChangeListener) {
            this.delegate = propertyChangeListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("transferHandler".equals(string)) {
                DropTarget dropTarget = ExtendedListUI.this.list.getDropTarget();
                if (dropTarget instanceof UIResource) {
                    try {
                        dropTarget.addDropTargetListener(new SimpleDropTarget());
                    }
                    catch (TooManyListenersException tooManyListenersException) {}
                }
            } else {
                this.delegate.propertyChange(propertyChangeEvent);
            }
        }
    }
}

