/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnainchi;

import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiCheckStatus;
import io.github.dan2097.jnainchi.InchiFlag;
import io.github.dan2097.jnainchi.InchiInput;
import io.github.dan2097.jnainchi.InchiInputFromAuxinfoOutput;
import io.github.dan2097.jnainchi.InchiInputFromInchiOutput;
import io.github.dan2097.jnainchi.InchiKeyCheckStatus;
import io.github.dan2097.jnainchi.InchiKeyOutput;
import io.github.dan2097.jnainchi.InchiKeyStatus;
import io.github.dan2097.jnainchi.InchiOptions;
import io.github.dan2097.jnainchi.InchiOutput;
import io.github.dan2097.jnainchi.InchiRadical;
import io.github.dan2097.jnainchi.InchiStatus;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnainchi.InchiStereoType;
import io.github.dan2097.jnainchi.inchi.InchiLibrary;
import io.github.dan2097.jnainchi.inchi.IxaFunctions;
import io.github.dan2097.jnainchi.inchi.tagINCHIStereo0D;
import io.github.dan2097.jnainchi.inchi.tagINCHI_Input;
import io.github.dan2097.jnainchi.inchi.tagINCHI_InputINCHI;
import io.github.dan2097.jnainchi.inchi.tagINCHI_Output;
import io.github.dan2097.jnainchi.inchi.tagINCHI_OutputStruct;
import io.github.dan2097.jnainchi.inchi.tagInchiAtom;
import io.github.dan2097.jnainchi.inchi.tagInchiInpData;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JnaInchi {
    private static final String platform;
    private static final Throwable libraryLoadingError;

    public static InchiOutput toInchi(InchiInput inchiInput) {
        return JnaInchi.toInchi(inchiInput, InchiOptions.DEFAULT_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InchiOutput toInchi(InchiInput inchiInput, InchiOptions options) {
        JnaInchi.checkLibrary();
        List<InchiAtom> atoms = inchiInput.getAtoms();
        int atomCount = atoms.size();
        if (atomCount > Short.MAX_VALUE) {
            throw new IllegalStateException("InChI is limited to 32767 atoms, input contained " + atomCount + " atoms");
        }
        List<InchiBond> bonds = inchiInput.getBonds();
        List<InchiStereo> stereos = inchiInput.getStereos();
        if (stereos.size() > Short.MAX_VALUE) {
            throw new IllegalStateException("Too many stereochemistry elements in input");
        }
        IxaFunctions.IXA_STATUS_HANDLE logger = IxaFunctions.IXA_STATUS_Create();
        IxaFunctions.IXA_MOL_HANDLE nativeMol = IxaFunctions.IXA_MOL_Create(logger);
        IxaFunctions.IXA_MOL_ReserveSpace(logger, nativeMol, atomCount, bonds.size(), stereos.size());
        try {
            Map<InchiAtom, IxaFunctions.IXA_ATOMID> atomToNativeAtom = JnaInchi.addAtoms(nativeMol, logger, atoms);
            JnaInchi.addBonds(nativeMol, logger, bonds, atomToNativeAtom);
            JnaInchi.addStereos(nativeMol, logger, stereos, atomToNativeAtom);
            InchiOutput inchiOutput = JnaInchi.buildInchi(logger, nativeMol, options);
            return inchiOutput;
        }
        finally {
            IxaFunctions.IXA_MOL_Destroy(logger, nativeMol);
            IxaFunctions.IXA_STATUS_Destroy(logger);
        }
    }

    private static Map<InchiAtom, IxaFunctions.IXA_ATOMID> addAtoms(IxaFunctions.IXA_MOL_HANDLE mol, IxaFunctions.IXA_STATUS_HANDLE logger, List<InchiAtom> atoms) {
        HashMap<InchiAtom, IxaFunctions.IXA_ATOMID> atomToNativeAtom = new HashMap<InchiAtom, IxaFunctions.IXA_ATOMID>();
        for (InchiAtom atom : atoms) {
            String elName;
            IxaFunctions.IXA_ATOMID nativeAtom = IxaFunctions.IXA_MOL_CreateAtom(logger, mol);
            atomToNativeAtom.put(atom, nativeAtom);
            if (atom.getX() != 0.0) {
                IxaFunctions.IXA_MOL_SetAtomX(logger, mol, nativeAtom, atom.getX());
            }
            if (atom.getY() != 0.0) {
                IxaFunctions.IXA_MOL_SetAtomY(logger, mol, nativeAtom, atom.getY());
            }
            if (atom.getZ() != 0.0) {
                IxaFunctions.IXA_MOL_SetAtomZ(logger, mol, nativeAtom, atom.getZ());
            }
            if (!(elName = atom.getElName()).equals("C")) {
                if (elName.length() > 5) {
                    throw new IllegalArgumentException("Element name was too long: " + elName);
                }
                IxaFunctions.IXA_MOL_SetAtomElement(logger, mol, nativeAtom, elName);
            }
            if (atom.getIsotopicMass() != 0) {
                IxaFunctions.IXA_MOL_SetAtomMass(logger, mol, nativeAtom, atom.getIsotopicMass());
            }
            if (atom.getCharge() != 0) {
                IxaFunctions.IXA_MOL_SetAtomCharge(logger, mol, nativeAtom, atom.getCharge());
            }
            if (atom.getRadical() != InchiRadical.NONE) {
                IxaFunctions.IXA_MOL_SetAtomRadical(logger, mol, nativeAtom, atom.getRadical().getCode());
            }
            if (atom.getImplicitHydrogen() != 0) {
                IxaFunctions.IXA_MOL_SetAtomHydrogens(logger, mol, nativeAtom, 0, atom.getImplicitHydrogen());
            }
            if (atom.getImplicitProtium() != 0) {
                IxaFunctions.IXA_MOL_SetAtomHydrogens(logger, mol, nativeAtom, 1, atom.getImplicitProtium());
            }
            if (atom.getImplicitDeuterium() != 0) {
                IxaFunctions.IXA_MOL_SetAtomHydrogens(logger, mol, nativeAtom, 2, atom.getImplicitDeuterium());
            }
            if (atom.getImplicitTritium() == 0) continue;
            IxaFunctions.IXA_MOL_SetAtomHydrogens(logger, mol, nativeAtom, 3, atom.getImplicitTritium());
        }
        return atomToNativeAtom;
    }

    private static void addBonds(IxaFunctions.IXA_MOL_HANDLE mol, IxaFunctions.IXA_STATUS_HANDLE logger, List<InchiBond> bonds, Map<InchiAtom, IxaFunctions.IXA_ATOMID> atomToNativeAtom) {
        for (InchiBond bond : bonds) {
            IxaFunctions.IXA_ATOMID nativeAtom1 = atomToNativeAtom.get(bond.getStart());
            IxaFunctions.IXA_ATOMID nativeAtom2 = atomToNativeAtom.get(bond.getEnd());
            if (nativeAtom1 == null || nativeAtom2 == null) {
                throw new IllegalStateException("Bond referenced an atom that was not part of the InchiInput");
            }
            IxaFunctions.IXA_BONDID nativeBond = IxaFunctions.IXA_MOL_CreateBond(logger, mol, nativeAtom1, nativeAtom2);
            InchiBondType bondType = bond.getType();
            if (bondType != InchiBondType.SINGLE) {
                IxaFunctions.IXA_MOL_SetBondType(logger, mol, nativeBond, bondType.getCode());
            }
            switch (bond.getStereo()) {
                case DOUBLE_EITHER: {
                    IxaFunctions.IXA_MOL_SetDblBondConfig(logger, mol, nativeBond, 1);
                    break;
                }
                case SINGLE_1DOWN: {
                    IxaFunctions.IXA_MOL_SetBondWedge(logger, mol, nativeBond, nativeAtom1, 2);
                    break;
                }
                case SINGLE_1EITHER: {
                    IxaFunctions.IXA_MOL_SetBondWedge(logger, mol, nativeBond, nativeAtom1, 3);
                    break;
                }
                case SINGLE_1UP: {
                    IxaFunctions.IXA_MOL_SetBondWedge(logger, mol, nativeBond, nativeAtom1, 1);
                    break;
                }
                case SINGLE_2DOWN: {
                    IxaFunctions.IXA_MOL_SetBondWedge(logger, mol, nativeBond, nativeAtom2, 2);
                    break;
                }
                case SINGLE_2EITHER: {
                    IxaFunctions.IXA_MOL_SetBondWedge(logger, mol, nativeBond, nativeAtom2, 3);
                    break;
                }
                case SINGLE_2UP: {
                    IxaFunctions.IXA_MOL_SetBondWedge(logger, mol, nativeBond, nativeAtom2, 1);
                    break;
                }
            }
        }
    }

    private static void addStereos(IxaFunctions.IXA_MOL_HANDLE nativeMol, IxaFunctions.IXA_STATUS_HANDLE logger, List<InchiStereo> stereos, Map<InchiAtom, IxaFunctions.IXA_ATOMID> atomToNativeAtom) {
        for (InchiStereo stereo : stereos) {
            IxaFunctions.IXA_STEREOID center;
            InchiStereoType type = stereo.getType();
            if (type == InchiStereoType.None) continue;
            InchiAtom[] atomsInCenter = stereo.getAtoms();
            IxaFunctions.IXA_ATOMID vertex1 = JnaInchi.getStereoVertex(atomToNativeAtom, atomsInCenter[0]);
            IxaFunctions.IXA_ATOMID vertex2 = JnaInchi.getStereoVertex(atomToNativeAtom, atomsInCenter[1]);
            IxaFunctions.IXA_ATOMID vertex3 = JnaInchi.getStereoVertex(atomToNativeAtom, atomsInCenter[2]);
            IxaFunctions.IXA_ATOMID vertex4 = JnaInchi.getStereoVertex(atomToNativeAtom, atomsInCenter[3]);
            switch (type) {
                case Tetrahedral: {
                    IxaFunctions.IXA_ATOMID centralAtom = atomToNativeAtom.get(stereo.getCentralAtom());
                    if (centralAtom == null) {
                        throw new IllegalStateException("Stereo configuration central atom referenced an atom that does not exist");
                    }
                    center = IxaFunctions.IXA_MOL_CreateStereoTetrahedron(logger, nativeMol, centralAtom, vertex1, vertex2, vertex3, vertex4);
                    break;
                }
                case Allene: {
                    IxaFunctions.IXA_ATOMID centralAtom = atomToNativeAtom.get(stereo.getCentralAtom());
                    if (centralAtom == null) {
                        throw new IllegalStateException("Stereo configuration central atom referenced an atom that does not exist");
                    }
                    center = IxaFunctions.IXA_MOL_CreateStereoAntiRectangle(logger, nativeMol, centralAtom, vertex1, vertex2, vertex3, vertex4);
                    break;
                }
                case DoubleBond: {
                    IxaFunctions.IXA_BONDID centralBond = IxaFunctions.IXA_MOL_GetCommonBond(logger, nativeMol, vertex2, vertex3);
                    if (centralBond == null) {
                        throw new IllegalStateException("Could not find olefin/cumulene central bond");
                    }
                    center = IxaFunctions.IXA_MOL_CreateStereoRectangle(logger, nativeMol, centralBond, vertex1, IxaFunctions.IXA_ATOMID_IMPLICIT_H, IxaFunctions.IXA_ATOMID_IMPLICIT_H, vertex4);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected InChI stereo type:" + (Object)((Object)type));
                }
            }
            byte parity = stereo.getParity().getCode();
            IxaFunctions.IXA_MOL_SetStereoParity(logger, nativeMol, center, parity);
        }
    }

    private static IxaFunctions.IXA_ATOMID getStereoVertex(Map<InchiAtom, IxaFunctions.IXA_ATOMID> atomToNativeAtom, InchiAtom inchiAtom) {
        if (InchiStereo.STEREO_IMPLICIT_H == inchiAtom) {
            return IxaFunctions.IXA_ATOMID_IMPLICIT_H;
        }
        IxaFunctions.IXA_ATOMID vertex = atomToNativeAtom.get(inchiAtom);
        if (vertex == null) {
            throw new IllegalStateException("Stereo configuration referenced an atom that does not exist");
        }
        return vertex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InchiOutput buildInchi(IxaFunctions.IXA_STATUS_HANDLE logger, IxaFunctions.IXA_MOL_HANDLE nativeMol, InchiOptions options) {
        IxaFunctions.IXA_INCHIBUILDER_HANDLE builder = IxaFunctions.IXA_INCHIBUILDER_Create(logger);
        try {
            IxaFunctions.IXA_INCHIBUILDER_SetMolecule(logger, builder, nativeMol);
            long timeoutMilliSecs = options.getTimeoutMilliSeconds();
            if (timeoutMilliSecs != 0L) {
                IxaFunctions.IXA_INCHIBUILDER_SetOption_Timeout_MilliSeconds(logger, builder, timeoutMilliSecs);
            }
            block34: for (InchiFlag flag : options.getFlags()) {
                switch (flag) {
                    case AuxNone: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 9, true);
                        continue block34;
                    }
                    case ChiralFlagOFF: {
                        IxaFunctions.IXA_MOL_SetChiral(logger, nativeMol, false);
                        continue block34;
                    }
                    case ChiralFlagON: {
                        IxaFunctions.IXA_MOL_SetChiral(logger, nativeMol, true);
                        continue block34;
                    }
                    case DoNotAddH: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 1, true);
                        continue block34;
                    }
                    case FixedH: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 4, true);
                        continue block34;
                    }
                    case KET: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 6, true);
                        continue block34;
                    }
                    case LargeMolecules: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 11, true);
                        continue block34;
                    }
                    case NEWPSOFF: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 0, true);
                        continue block34;
                    }
                    case OneFiveT: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 7, true);
                        continue block34;
                    }
                    case RecMet: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 5, true);
                        continue block34;
                    }
                    case SLUUD: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 3, true);
                        continue block34;
                    }
                    case SNon: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption_Stereo(logger, builder, 1);
                        continue block34;
                    }
                    case SRac: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption_Stereo(logger, builder, 3);
                        continue block34;
                    }
                    case SRel: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption_Stereo(logger, builder, 2);
                        continue block34;
                    }
                    case SUCF: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption_Stereo(logger, builder, 4);
                        continue block34;
                    }
                    case SAbs: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption_Stereo(logger, builder, 0);
                        continue block34;
                    }
                    case SUU: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 2, true);
                        continue block34;
                    }
                    case SaveOpt: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 8, true);
                        continue block34;
                    }
                    case WarnOnEmptyStructure: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 10, true);
                        continue block34;
                    }
                    case NoWarnings: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 24, true);
                        continue block34;
                    }
                    case LooseTSACheck: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 22, true);
                        continue block34;
                    }
                    case Polymers: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 12, true);
                        continue block34;
                    }
                    case Polymers105: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 13, true);
                        continue block34;
                    }
                    case FoldCRU: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 20, true);
                        continue block34;
                    }
                    case NoFrameShift: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 19, true);
                        continue block34;
                    }
                    case NoEdits: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 21, true);
                        continue block34;
                    }
                    case NPZz: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 17, true);
                        continue block34;
                    }
                    case SAtZz: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 18, true);
                        continue block34;
                    }
                    case OutErrInChI: {
                        IxaFunctions.IXA_INCHIBUILDER_SetOption(logger, builder, 23, true);
                        continue block34;
                    }
                }
                throw new IllegalStateException("Unexpected InChI option flag: " + (Object)((Object)flag));
            }
            String inchi = IxaFunctions.IXA_INCHIBUILDER_GetInChI(logger, builder);
            String auxInfo = IxaFunctions.IXA_INCHIBUILDER_GetAuxInfo(logger, builder);
            String log = IxaFunctions.IXA_INCHIBUILDER_GetLog(logger, builder);
            InchiStatus status = InchiStatus.SUCCESS;
            if (IxaFunctions.IXA_STATUS_HasError(logger)) {
                status = InchiStatus.ERROR;
            } else if (IxaFunctions.IXA_STATUS_HasWarning(logger)) {
                status = InchiStatus.WARNING;
            }
            StringBuilder sb = new StringBuilder();
            int messageCount = IxaFunctions.IXA_STATUS_GetCount(logger);
            for (int i = 0; i < messageCount; ++i) {
                if (i > 0) {
                    sb.append("; ");
                }
                sb.append(IxaFunctions.IXA_STATUS_GetMessage(logger, i));
            }
            InchiOutput inchiOutput = new InchiOutput(inchi, auxInfo, sb.toString(), log, status);
            return inchiOutput;
        }
        finally {
            IxaFunctions.IXA_INCHIBUILDER_Destroy(logger, builder);
        }
    }

    public static InchiOutput molToInchi(String molText) {
        return JnaInchi.molToInchi(molText, InchiOptions.DEFAULT_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InchiOutput molToInchi(String molText, InchiOptions options) {
        JnaInchi.checkLibrary();
        tagINCHI_Output nativeOutput = new tagINCHI_Output();
        try {
            InchiStatus status;
            int ret = InchiLibrary.MakeINCHIFromMolfileText(molText, options.toString(), nativeOutput);
            switch (ret) {
                case 0: {
                    status = InchiStatus.SUCCESS;
                    break;
                }
                case 1: {
                    status = InchiStatus.WARNING;
                    break;
                }
                case -1: 
                case 2: 
                case 4: 
                case 5: {
                    status = InchiStatus.ERROR;
                    break;
                }
                default: {
                    status = InchiStatus.ERROR;
                }
            }
            InchiOutput inchiOutput = new InchiOutput(nativeOutput.szInChI, nativeOutput.szAuxInfo, nativeOutput.szMessage, nativeOutput.szLog, status);
            return inchiOutput;
        }
        finally {
            InchiLibrary.FreeINCHI(nativeOutput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InchiOutput inchiToInchi(String inchi, InchiOptions options) {
        JnaInchi.checkLibrary();
        IxaFunctions.IXA_STATUS_HANDLE logger = IxaFunctions.IXA_STATUS_Create();
        IxaFunctions.IXA_MOL_HANDLE nativeMol = IxaFunctions.IXA_MOL_Create(logger);
        try {
            IxaFunctions.IXA_MOL_ReadInChI(logger, nativeMol, inchi);
            InchiOutput inchiOutput = JnaInchi.buildInchi(logger, nativeMol, options);
            return inchiOutput;
        }
        finally {
            IxaFunctions.IXA_MOL_Destroy(logger, nativeMol);
            IxaFunctions.IXA_STATUS_Destroy(logger);
        }
    }

    public static InchiKeyOutput inchiToInchiKey(String inchi) {
        JnaInchi.checkLibrary();
        byte[] inchiKeyBytes = new byte[28];
        byte[] szXtra1Bytes = new byte[65];
        byte[] szXtra2Bytes = new byte[65];
        InchiKeyStatus ret = InchiKeyStatus.of(InchiLibrary.GetINCHIKeyFromINCHI(inchi, 1, 1, inchiKeyBytes, szXtra1Bytes, szXtra2Bytes));
        String inchiKeyStr = new String(inchiKeyBytes, StandardCharsets.UTF_8).trim();
        String szXtra1 = new String(szXtra1Bytes, StandardCharsets.UTF_8).trim();
        String szXtra2 = new String(szXtra2Bytes, StandardCharsets.UTF_8).trim();
        return new InchiKeyOutput(inchiKeyStr, ret, szXtra1, szXtra2);
    }

    public static InchiCheckStatus checkInchi(String inchi, boolean strict) {
        JnaInchi.checkLibrary();
        return InchiCheckStatus.of(InchiLibrary.CheckINCHI(inchi, strict));
    }

    public static InchiKeyCheckStatus checkInchiKey(String inchiKey) {
        JnaInchi.checkLibrary();
        return InchiKeyCheckStatus.of(InchiLibrary.CheckINCHIKey(inchiKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InchiInputFromAuxinfoOutput getInchiInputFromAuxInfo(String auxInfo, boolean doNotAddH, boolean diffUnkUndfStereo) {
        JnaInchi.checkLibrary();
        tagINCHI_Input pInp = new tagINCHI_Input();
        tagInchiInpData input = new tagInchiInpData(pInp);
        try {
            InchiStatus status = JnaInchi.getInchiStatus(InchiLibrary.Get_inchi_Input_FromAuxInfo(auxInfo, doNotAddH, diffUnkUndfStereo, input));
            InchiInput inchiInput = new InchiInput();
            tagINCHI_Input populatedInput = input.pInp;
            if (populatedInput.num_atoms > 0) {
                Structure[] nativeAtoms = new tagInchiAtom[populatedInput.num_atoms];
                populatedInput.atom.toArray(nativeAtoms);
                JnaInchi.nativeToJavaAtoms(inchiInput, (tagInchiAtom[])nativeAtoms);
                JnaInchi.nativeToJavaBonds(inchiInput, (tagInchiAtom[])nativeAtoms);
            }
            if (populatedInput.num_stereo0D > 0) {
                Structure[] nativeStereos = new tagINCHIStereo0D[populatedInput.num_stereo0D];
                populatedInput.stereo0D.toArray(nativeStereos);
                JnaInchi.nativeToJavaStereos(inchiInput, (tagINCHIStereo0D[])nativeStereos);
            }
            String message = JnaInchi.toString(input.szErrMsg);
            Boolean chiralFlag = null;
            if (input.bChiral == 1) {
                chiralFlag = true;
            } else if (input.bChiral == 2) {
                chiralFlag = false;
            }
            InchiInputFromAuxinfoOutput inchiInputFromAuxinfoOutput = new InchiInputFromAuxinfoOutput(inchiInput, chiralFlag, message, status);
            return inchiInputFromAuxinfoOutput;
        }
        finally {
            InchiLibrary.Free_inchi_Input(pInp);
            input.clear();
        }
    }

    public static InchiInputFromInchiOutput getInchiInputFromInchi(String inchi) {
        return JnaInchi.getInchiInputFromInchi(inchi, InchiOptions.DEFAULT_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InchiInputFromInchiOutput getInchiInputFromInchi(String inchi, InchiOptions options) {
        JnaInchi.checkLibrary();
        tagINCHI_InputINCHI input = new tagINCHI_InputINCHI(inchi, options.toString());
        tagINCHI_OutputStruct output = new tagINCHI_OutputStruct();
        try {
            InchiStatus status = JnaInchi.getInchiStatus(InchiLibrary.GetStructFromINCHI(input, output));
            InchiInput inchiInput = new InchiInput();
            if (output.num_atoms > 0) {
                Structure[] nativeAtoms = new tagInchiAtom[output.num_atoms];
                output.atom.toArray(nativeAtoms);
                JnaInchi.nativeToJavaAtoms(inchiInput, (tagInchiAtom[])nativeAtoms);
                JnaInchi.nativeToJavaBonds(inchiInput, (tagInchiAtom[])nativeAtoms);
            }
            if (output.num_stereo0D > 0) {
                Structure[] nativeStereos = new tagINCHIStereo0D[output.num_stereo0D];
                output.stereo0D.toArray(nativeStereos);
                JnaInchi.nativeToJavaStereos(inchiInput, (tagINCHIStereo0D[])nativeStereos);
            }
            String message = output.szMessage;
            String log = output.szLog;
            NativeLong[] nativeFlags = output.WarningFlags;
            long[][] warningFlags = new long[2][2];
            block9: for (int i = 0; i < nativeFlags.length; ++i) {
                long val = nativeFlags[i].longValue();
                switch (i) {
                    case 0: {
                        warningFlags[0][0] = val;
                        continue block9;
                    }
                    case 1: {
                        warningFlags[0][1] = val;
                        continue block9;
                    }
                    case 2: {
                        warningFlags[1][0] = val;
                        continue block9;
                    }
                    case 3: {
                        warningFlags[1][1] = val;
                        continue block9;
                    }
                }
            }
            InchiInputFromInchiOutput inchiInputFromInchiOutput = new InchiInputFromInchiOutput(inchiInput, message, log, status, warningFlags);
            return inchiInputFromInchiOutput;
        }
        finally {
            InchiLibrary.FreeStructFromINCHI(output);
            input.clear();
        }
    }

    private static void nativeToJavaAtoms(InchiInput inchiInput, tagInchiAtom[] nativeAtoms) {
        for (tagInchiAtom nativeAtom : nativeAtoms) {
            InchiAtom atom = new InchiAtom(JnaInchi.toString(nativeAtom.elname));
            atom.setX(nativeAtom.x);
            atom.setY(nativeAtom.y);
            atom.setZ(nativeAtom.z);
            atom.setImplicitHydrogen(nativeAtom.num_iso_H[0]);
            atom.setImplicitProtium(nativeAtom.num_iso_H[1]);
            atom.setImplicitDeuterium(nativeAtom.num_iso_H[2]);
            atom.setImplicitTritium(nativeAtom.num_iso_H[3]);
            atom.setIsotopicMass(nativeAtom.isotopic_mass);
            atom.setRadical(InchiRadical.of(nativeAtom.radical));
            atom.setCharge(nativeAtom.charge);
            inchiInput.addAtom(atom);
        }
    }

    private static void nativeToJavaBonds(InchiInput inchiInput, tagInchiAtom[] nativeAtoms) {
        int numAtoms = nativeAtoms.length;
        boolean[] seenAtoms = new boolean[numAtoms];
        for (int i = 0; i < numAtoms; ++i) {
            tagInchiAtom nativeAtom = nativeAtoms[i];
            int numBonds = nativeAtom.num_bonds;
            if (numBonds > 0) {
                InchiAtom atom = inchiInput.getAtom(i);
                for (int j = 0; j < numBonds; ++j) {
                    short neighborIdx = nativeAtom.neighbor[j];
                    if (seenAtoms[neighborIdx]) continue;
                    InchiAtom neighbor = inchiInput.getAtom(neighborIdx);
                    InchiBondType bondType = InchiBondType.of(nativeAtom.bond_type[j]);
                    InchiBondStereo bondStereo = InchiBondStereo.of(nativeAtom.bond_stereo[j]);
                    inchiInput.addBond(new InchiBond(atom, neighbor, bondType, bondStereo));
                }
            }
            seenAtoms[i] = true;
        }
    }

    private static void nativeToJavaStereos(InchiInput inchiInput, tagINCHIStereo0D[] nativeStereos) {
        for (tagINCHIStereo0D nativeStereo : nativeStereos) {
            InchiAtom[] atoms = new InchiAtom[4];
            for (int i = 0; i < 4; ++i) {
                short idx = nativeStereo.neighbor[i];
                atoms[i] = idx >= 0 ? inchiInput.getAtom(idx) : null;
            }
            InchiAtom centralAtom = nativeStereo.central_atom >= 0 ? inchiInput.getAtom(nativeStereo.central_atom) : null;
            InchiStereoType stereoType = InchiStereoType.of(nativeStereo.type);
            InchiStereoParity parity = InchiStereoParity.of(nativeStereo.parity);
            inchiInput.addStereo(new InchiStereo(atoms, centralAtom, stereoType, parity));
        }
    }

    private static InchiStatus getInchiStatus(int ret) {
        switch (ret) {
            case 0: {
                return InchiStatus.SUCCESS;
            }
            case -1: 
            case 1: {
                return InchiStatus.WARNING;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return InchiStatus.ERROR;
            }
        }
        return InchiStatus.ERROR;
    }

    private static String toString(byte[] cstr) {
        char ch;
        StringBuilder sb = new StringBuilder(cstr.length);
        for (int i = 0; i < cstr.length && (ch = (char)cstr[i]) != '\u0000'; ++i) {
            sb.append(ch);
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getInchiLibraryVersion() {
        try (InputStream is = JnaInchi.class.getResourceAsStream("jnainchi_build.props");){
            Properties props = new Properties();
            props.load(is);
            String string = props.getProperty("inchi_version");
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJnaInchiVersion() {
        try (InputStream is = JnaInchi.class.getResourceAsStream("jnainchi_build.props");){
            Properties props = new Properties();
            props.load(is);
            String string = props.getProperty("jnainchi_version");
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void checkLibrary() {
        if (libraryLoadingError != null) {
            throw new RuntimeException("Error loading InChI native code. Please check that the binaries for your platform (" + platform + ") have been included on the classpath.", libraryLoadingError);
        }
    }

    static {
        Throwable t = null;
        String p = null;
        try {
            p = Platform.RESOURCE_PREFIX;
            InchiLibrary.JNA_NATIVE_LIB.getName();
        }
        catch (Throwable e) {
            t = e;
        }
        platform = p;
        libraryLoadingError = t;
    }
}

