/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.invariant.ConjugatedPiSystemsDetector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.qsar.AbstractAtomicDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.BooleanResult;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class IsProtonInConjugatedPiSystemDescriptor
extends AbstractAtomicDescriptor
implements IAtomicDescriptor {
    private static final String[] NAMES = new String[]{"protonInConjSystem"};
    private boolean checkAromaticity = false;
    private IAtomContainer acold = null;
    private IAtomContainerSet acSet = null;

    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#isProtonInConjugatedPiSystem", ((Object)((Object)this)).getClass().getName(), "The Chemistry Development Kit");
    }

    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("IsProtonInConjugatedPiSystemDescriptor only expects one parameters");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    public String[] getDescriptorNames() {
        return NAMES;
    }

    public DescriptorValue calculate(IAtom atom, IAtomContainer atomContainer) {
        IAtomContainer clonedAtomContainer;
        try {
            clonedAtomContainer = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new BooleanResult(false), NAMES, (Exception)e);
        }
        IAtom clonedAtom = clonedAtomContainer.getAtom(atomContainer.indexOf(atom));
        boolean isProtonInPiSystem = false;
        IAtomContainer mol = (IAtomContainer)clonedAtom.getBuilder().newInstance(IAtomContainer.class, new Object[]{clonedAtomContainer});
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)mol);
                Aromaticity.cdkLegacy().apply(mol);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new BooleanResult(false), NAMES, (Exception)((Object)e));
            }
        }
        if (atom.getAtomicNumber() == 1) {
            if (this.acold != clonedAtomContainer) {
                this.acold = clonedAtomContainer;
                this.acSet = ConjugatedPiSystemsDetector.detect((IAtomContainer)mol);
            }
            Iterator detected = this.acSet.atomContainers().iterator();
            List neighboors = mol.getConnectedAtomsList(clonedAtom);
            block4: for (IAtom neighboor : neighboors) {
                while (detected.hasNext()) {
                    IAtomContainer detectedAC = (IAtomContainer)detected.next();
                    if (detectedAC == null || !detectedAC.contains(neighboor)) continue;
                    isProtonInPiSystem = true;
                    continue block4;
                }
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), (IDescriptorResult)new BooleanResult(isProtonInPiSystem), NAMES);
    }

    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    public Object getParameterType(String name) {
        return true;
    }
}

