/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.NodeFactory;
import nu.xom.ParsingException;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLNodeFactory;
import org.xmlcml.cml.base.CMLUtil;

public class CMLBuilder
extends Builder
implements CMLConstants {
    public CMLBuilder() {
        this(CMLNodeFactory.nodeFactory);
    }

    public CMLBuilder(boolean validate) {
        this(validate, CMLNodeFactory.nodeFactory);
    }

    public CMLBuilder(NodeFactory nodeFactory) {
        super(nodeFactory);
    }

    public CMLBuilder(boolean validate, NodeFactory nodeFactory) {
        super(validate, nodeFactory);
    }

    public Element parseString(String xmlString) {
        Document doc = null;
        try {
            doc = this.build(new StringReader(xmlString));
        }
        catch (IOException e) {
            throw new RuntimeException("BUG ", e);
        }
        catch (Exception e) {
            throw new RuntimeException("cannot parse: ", e);
        }
        return doc == null ? null : doc.getRootElement();
    }

    public static Document ensureCML(Document doc) {
        Element root = doc.getRootElement();
        String nameURI = root.getNamespaceURI();
        if (!"http://www.xml-cml.org/schema".equals(nameURI)) {
            try {
                System.err.println("No CML namespace; munging one in");
                ByteArrayOutputStream ss = new ByteArrayOutputStream();
                CMLUtil.debug(root, ss, 0);
                ss.close();
                String s = ss.toString();
                int idx = s.indexOf(">\n");
                if (s.startsWith("<?")) {
                    idx = s.indexOf(">\n", idx);
                }
                String sss = s.substring(0, idx) + " " + "xmlns='http://www.xml-cml.org/schema'" + s.substring(idx);
                Element newRoot = new CMLBuilder().parseString(sss);
                doc = newRoot.getDocument();
            }
            catch (Exception e) {
                throw new RuntimeException("BUG " + e);
            }
        }
        return doc;
    }

    public Document buildEnsureCML(InputStream is) throws IOException, ParsingException {
        Document doc = super.build(is);
        return CMLBuilder.ensureCML(doc);
    }

    public Document buildEnsureCML(Reader reader) throws IOException, ParsingException {
        Document doc = super.build(reader);
        return CMLBuilder.ensureCML(doc);
    }

    public static CMLElement ensureCML(Element xml) {
        if (xml == null) {
            throw new RuntimeException("null cml");
        }
        if (xml instanceof CMLElement) {
            return (CMLElement)xml.copy();
        }
        Document doc = new Document(xml.copy());
        try {
            Document doc2 = new CMLBuilder().build(doc.toXML(), doc.getBaseURI());
            CMLElement cmlElement = (CMLElement)doc2.getRootElement();
            return cmlElement;
        }
        catch (Exception e) {
            CMLUtil.debug(xml, "ensureCMLProblem " + e);
            throw new RuntimeException("ensureCMLProblem", e);
        }
    }
}

