/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.euclid.test;

import org.junit.Assert;

public class DoubleTestBase {
    static String S_SLASH = "/";
    static String S_RBRAK = ")";

    public static void assertEquals(String message, double[] expected, double[] actual, double eps) {
        String s = DoubleTestBase.testEquals(expected, actual, eps);
        if (s != null) {
            Assert.fail((String)(message + "; " + s));
        }
    }

    private static boolean isEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    private static boolean isEqual(double[] a, double[] b, double epsilon) {
        if (a == null || b == null || a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (DoubleTestBase.isEqual(a[i], b[i], epsilon)) continue;
            return false;
        }
        return true;
    }

    public static void assertObjectivelyEquals(String message, double[] a, double[] b, double eps) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (a.length != b.length) {
            s = "unequal arrays: " + a.length + S_SLASH + b.length;
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (DoubleTestBase.isEqual(a[i], b[i], eps)) continue;
                s = "unequal element at (" + i + "), " + a[i] + " != " + b[i];
                break;
            }
        }
        if (s != null) {
            Assert.fail((String)(message + "; " + s));
        }
    }

    public static void assertNotEquals(String message, double[] a, double[] b, double eps) {
        String s = DoubleTestBase.testEquals(a, b, eps);
        if (s == null) {
            Assert.fail((String)(message + "; arrays are equal"));
        }
    }

    static String testEquals(double[] a, double[] b, double eps) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (a.length != b.length) {
            s = "unequal arrays: " + a.length + S_SLASH + b.length;
        } else {
            for (int i = 0; i < a.length; ++i) {
                if (DoubleTestBase.isEqual(a[i], b[i], eps)) continue;
                s = "unequal element at (" + i + "), " + a[i] + " != " + b[i];
                break;
            }
        }
        return s;
    }

    static String testEquals(double[][] a, double[][] b, double eps) {
        String s = null;
        if (a == null) {
            s = "a is null";
        } else if (b == null) {
            s = "b is null";
        } else if (a.length != b.length) {
            s = "unequal arrays: " + a.length + S_SLASH + b.length;
        } else {
            block0: for (int i = 0; i < a.length; ++i) {
                if (a[i].length != b[i].length) {
                    s = "row (" + i + ") has unequal lengths: " + a[i].length + S_SLASH + b[i].length;
                    break;
                }
                for (int j = 0; j < a[i].length; ++j) {
                    if (DoubleTestBase.isEqual(a[i][j], b[i][j], eps)) continue;
                    s = "unequal element at (" + i + ", " + j + "), (" + a[i][j] + " != " + b[i][j] + S_RBRAK;
                    continue block0;
                }
            }
        }
        return s;
    }
}

