/* File created on 15.11.2019 (CET) by User: wrightp */
/* Source system: secuTrial 5.5.1.10 */
/* Data from Project secuTrialR example CDMA */
/* Only Data from Centre 'Charité Berlin (RPACK)' contained in export */
/* Only Data from Centre 'Inselspital Bern (RPACK)' contained in export */
/* Only Data from Centre 'Universitätsspital Basel (RPACK)' contained in export */
/* NOTE: It is recommended to replace the relative paths to the data   */
/*       files in "dat" with the absolute paths before execution.      */
/*       Execute the *_fmt.sas script first!                           */

DATA vp (LABEL='Project visit plan');
infile 'dat/vp.dat'
        encoding='UTF-8'
        missover
        LRECL=260
;
input   mnpvisid 1-10
        visitnumber 12-15
        visittype 17-18
        previsid 20-29
        visitday 31-40
        minusoffset 42-51
        plusoffset 53-62
        visitarm $ 64-163
        hidden 165-166
        mnpvislabel $ 168-217
        mnpvsno 219-228
        mnpvslbl $ 230-259
;
ATTRIB  mnpvisid LABEL='Visit-ID'
        visitnumber LABEL='Visit sequence'
        visittype LABEL='Type of visit' FORMAT=clvt.
        previsid LABEL='Preceding visit-ID'
        visitday LABEL='Time lag to preceding visit (days)'
        minusoffset LABEL='Possible negative time frame (days)'
        plusoffset LABEL='Possible positive time frame (days)'
        visitarm LABEL='Treatment arm'
        hidden LABEL='hidden in DataCapture' FORMAT=clhd.
        mnpvislabel LABEL='Visit label'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
;
run;
/* == end of vp == */


DATA vpfs (LABEL='Forms in visit plan');
infile 'dat/vpfs.dat'
        encoding='UTF-8'
        missover
        LRECL=22
;
input   mnpvisid 1-10
        formid 12-21
;
ATTRIB  mnpvisid LABEL='Visit-ID'
        formid LABEL='Form-ID'
;
run;
/* == end of vpfs == */


DATA fs (label='Form');
infile 'dat/fs.dat'
        encoding='UTF-8'
        missover
        LRECL=394
;
input   formid 1-10
        formtablename $ 12-35
        hidden 37-38
        formname $ 40-239
        formfamily $ 241-340
        sequence 342-351
        mnpvsno 353-362
        mnpvslbl $ 364-393
;
ATTRIB  formid LABEL='Form-ID'
        formtablename LABEL='DB table name'
         hidden LABEL='hidden in DataCapture' FORMAT=clhd.
        formname LABEL='Form name (as in matrix)'
        formfamily LABEL='Form family name'
        sequence LABEL='Form sequence in form family'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
;
run;
/* == end of fs == */


DATA qs (label='Questions');
infile 'dat/qs.dat'
        encoding='UTF-8'
        missover
        LRECL=487
;
input   fgid 1-10
        formid 12-21
        formtablename $ 23-46
        formname $ 48-247
        sequence 249-258
        hidden 260-261
        fglabel $ 263-462
        subformtablename $ 464-487
;
ATTRIB  fgid LABEL='Question-ID'
        formid LABEL='Form-ID'
        formtablename LABEL='DB table name'
        formname LABEL='Form name (as in matrix)'
        sequence LABEL='Question sequence in form'
        hidden LABEL='hidden in DataCapture' FORMAT=clhd.
        fglabel LABEL='Question label (or unique label for search)'
        subformtablename LABEL='Sub-form DB table name'
;
run;
/* == end of qs == */


DATA is (label='Items');
infile 'dat/is.dat'
        encoding='UTF-8'
        missover
        LRECL=3005
;
input   ffid 1-10
        fgid 12-21
        sequence 23-32
        ffcolname $ 34-65
        itemtype $ 67-266
        hidden 268-269
        fflabel $ 271-2770
        unit $ 2772-2971
        lookuptable $ 2973-3002
;
ATTRIB  ffid LABEL='Item-ID'
        fgid LABEL='Question-ID'
        sequence LABEL='Item sequence in question'
        ffcolname LABEL='DB column name'
        itemtype LABEL='Item component type'
        hidden LABEL='hidden in DataCapture' FORMAT=clhd.
        fflabel LABEL='Item label (or question label or unique label for search)'
        unit LABEL='Unit / additional text'
        lookuptable LABEL='Name of lookup table'
;
run;
/* == end of is == */


DATA ctr (label='Centres');
infile 'dat/ctr.dat'
        encoding='UTF-8'
        missover
        LRECL=313
;
input   mnpctrid 1-10
        mnpctrname $ 12-111
        mnpcname $ 113-312
;
ATTRIB mnpctrid LABEL='Centre-ID'
        mnpctrname LABEL='Centre name'
        mnpcname LABEL='Country name'
;
run;
/* == end of ctr == */


DATA cn (label='Patient information');
infile 'dat/cn.dat'
        encoding='UTF-8'
        missover
        LRECL=191
;
input   mnppid 1-10
        mnpaid $ 12-31
        mnp_rando_treatment_gr $ 33-132
        mnpcnptnid 134-143
        mnpctrid 145-154
        mnpcs0 156-157
        mnpcs1 159-160
        mnpcs2 162-163
        mnpcs3 165-166
        mnpcs4 168-169
        mnpcs5 171-172
        mnpcs6 174-175
        mnpcs7 177-178
        @180 mnpvisstartdate
;
ATTRIB  mnppid LABEL='Patient-ID'
        mnpaid LABEL='Patient identifier'
        mnp_rando_treatment_gr LABEL='Randomization (group)'
        mnpcnptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpctrid LABEL='Centre-ID'
        mnpcs0 LABEL='Case status 0' FORMAT=clcs_0x.
        mnpcs1 LABEL='Case status 1' FORMAT=clcs_1x.
        mnpcs2 LABEL='Case status 2' FORMAT=clcs_2x.
        mnpcs3 LABEL='Case status 3' FORMAT=clcs_3x.
        mnpcs4 LABEL='Case status 4' FORMAT=clcs_4x.
        mnpcs5 LABEL='Case status 5' FORMAT=clcs_5x.
        mnpcs6 LABEL='Case status 6' FORMAT=clcs_6x.
        mnpcs7 LABEL='Case status 7' FORMAT=clcs_7x.
        mnpvisstartdate LABEL='Entry date' INFORMAT=DATE11. FORMAT=DATE9.
;
run;
/* == end of cn == */


DATA atcn (label='Patient information history');
infile 'dat/atcn.dat'
        encoding='UTF-8'
        missover
        LRECL=268
;
input   mnppid 1-10
        @12 oldvisitstartdate
        @24 newvisitstartdate
        mnpptnid 36-45
        @47 changedate
        changereason $ 68-267
;
ATTRIB  mnppid LABEL='Patient-ID'
        oldvisitstartdate LABEL='Old entry date' INFORMAT=DATE11. FORMAT=DATE9.
        newvisitstartdate LABEL='New entry date' INFORMAT=DATE11. FORMAT=DATE9.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        changedate LABEL='Date of change' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        changereason LABEL='Reason for change'
;
run;
/* == end of atcn == */


DATA atcvp (label='Patient visit plan history');
infile 'dat/atcvp.dat'
        encoding='UTF-8'
        missover
        LRECL=329
;
input   mnppid 1-10
        mnpcvpid 12-21
        @23 oldmnpvispdt
        @35 newmnpvispdt
        oldmnpvisid 47-56
        newmnpvisid 58-67
        oldmnpvisno 69-78
        newmnpvisno 80-89
        oldhidden 91-92
        newhidden 94-95
        mnpptnid 97-106
        @108 changedate
        changereason $ 129-328
;
ATTRIB  mnppid LABEL='Patient-ID'
        mnpcvpid LABEL='Patient visit-ID'
        oldmnpvispdt LABEL='Old planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        newmnpvispdt LABEL='New planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        oldmnpvisid LABEL='Old visit-ID'
        newmnpvisid LABEL='New visit-ID'
        oldmnpvisno LABEL='Old patient-visit number'
        newmnpvisno LABEL='New patient-visit number'
        oldhidden LABEL='Old hidden flag' FORMAT=clhd.
        newhidden LABEL='New hidden flag' FORMAT=clhd.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        changedate LABEL='Date of change' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        changereason LABEL='Reason for change'
;
run;
/* == end of atcvp == */


DATA atae1 (LABEL='Audit Trail Adverse Event Dates');
infile 'dat/atae1.dat'
        encoding='UTF-8'
        missover
        LRECL=336
;
input   mnppid 1-10
        mnpaeid 12-21
        mnpaefuid 23-32
        @34 olddate
        @55 newdate
        oldmnpaeno 76-85
        newmnpaeno 87-96
        oldhidden 98-99
        newhidden 101-102
        mnpptnid 104-113
        @115 changedate
        changereason $ 136-335
;
ATTRIB  mnppid LABEL='Patient-ID'
        mnpaeid LABEL='Adverse Event-ID'
        mnpaefuid LABEL='Adverse Event Follow-up-ID'
        olddate LABEL='Old date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        newdate LABEL='New date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        oldmnpaeno LABEL='Old patient adverse event number'
        newmnpaeno LABEL='New patient adverse event number'
        oldhidden LABEL='Old hidden flag' FORMAT=clhd.
        newhidden LABEL='New hidden flag' FORMAT=clhd.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        changedate LABEL='Date of change' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        changereason LABEL='Reason for change'
;
run;
/* == end of atae1 == */


DATA qac (label='Queries');
infile 'dat/qac.dat'
        encoding='UTF-8'
        missover
        LRECL=1119
;
input   mnppid 1-10
        mnpdocid 12-21
        ffid 23-32
        ffcolname $ 34-65
        hidden 67-68
        @70 qacdate
        mnpqueryid 91-100
        querystatus 102-103
        qacstatus 105-106
        mnpptnid 108-117
        qaccontent $ 119-1118
;
ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        ffid LABEL='Item-ID'
        ffcolname LABEL='DB column name'
        hidden LABEL='hidden in DataCapture' FORMAT=clhd.
        qacdate LABEL='Date of entry' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpqueryid LABEL='Query-ID'
        querystatus LABEL='Query status (calculated status)' FORMAT=clqa.
        qacstatus LABEL='QAC status (type of query-entry)' FORMAT=clqa.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        qaccontent LABEL='Content'
;
run;
/* == end of qac == */


DATA cts (label='Comments');
infile 'dat/cts.dat'
        encoding='UTF-8'
        missover
        LRECL=1113
;
input   mnppid 1-10
        mnpdocid 12-21
        ffid 23-32
        ffcolname $ 34-65
        hidden 67-68
        @70 qacdate
        mnpcommentid 91-100
        mnpptnid 102-111
        qaccontent $ 113-1112
;
ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        ffid LABEL='Item-ID'
        ffcolname LABEL='DB column name'
        hidden LABEL='hidden in DataCapture' FORMAT=clhd.
        qacdate LABEL='Date of entry' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpcommentid LABEL='Comment-ID'
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        qaccontent LABEL='Content'
;
run;
/* == end of cts == */


DATA miv (label='Missing Values');
infile 'dat/miv.dat'
        encoding='UTF-8'
        missover
        LRECL=355
;
input   mnppid 1-10
        mnpdocid 12-21
        ffid 23-32
        ffcolname $ 34-65
        hidden 67-68
        @70 editdate
        mivstatus 91-92
        mivstatustext $ 94-343
        mnpptnid 345-354
;
ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        ffid LABEL='Item-ID'
        ffcolname LABEL='DB column name'
        hidden LABEL='hidden in DataCapture' FORMAT=clhd.
        editdate LABEL='Date of entry' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mivstatus LABEL='Status MV' FORMAT=clmiv.
        mivstatustext LABEL='Other reason for MV'
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
;
run;
/* == end of miv == */


DATA atmiv (label='Audit Trail Missing Values');
infile 'dat/atmiv.dat'
        encoding='UTF-8'
        missover
        LRECL=355
;
input   mnppid 1-10
        mnpatdocid 12-21
        ffid 23-32
        ffcolname $ 34-65
        hidden 67-68
        @70 editdate
        mivstatus 91-92
        mivstatustext $ 94-343
        mnpptnid 345-354
;
ATTRIB  mnppid LABEL='Patient-ID'
        mnpatdocid LABEL='ATDocument-ID'
        ffid LABEL='Item-ID'
        ffcolname LABEL='DB column name'
        hidden LABEL='hidden in DataCapture' FORMAT=clhd.
        editdate LABEL='Date of entry' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mivstatus LABEL='Status MV' FORMAT=clmiv.
        mivstatustext LABEL='Other reason for MV'
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
;
run;
/* == end of atmiv == */


DATA baseline (label='General screen');
infile 'dat/baseline.dat'
        encoding='UTF-8'
        missover
        LRECL=1672
;
input   mnppid 1-10
        mnpdocid 12-21
        @23 mnplastedit
        mnpptnid 44-53
        mnpvisid 55-64
        mnpcvpid 66-75
        mnpvisno 77-86
        @88 mnpvispdt
        @100 mnpvisfdt
        mnpfs0 121-122
        mnpfs1 124-125
        mnpfs2 127-128
        mnpfs3 130-131
        mnpfcs0 133-134
        mnpfcs1 136-137
        mnpfcs2 139-140
        mnpfcs3 142-143
        mnpfsqa 145-146
        mnpfsct 148-149
        mnphide 151-152
        sigstatus 154-155
        sigreason $ 157-356
        mnpvsno 358-367
        mnpvslbl $ 369-398
        visit_date $ 400-407
        birth_year $ 409-412
        age 414-435
        gender 437-441
        height 443-449
        weight 451-458
        no_clinical_data 460-462
        hospitalisation 464-468
        icu 470-474
        surgery 476-480
        immunodeficiency 482-486
        hiv 488-492
        hiv_date_uknwn 494-496
        hiv_date $ 498-509
        liver_cirrh 511-515
        liver_cirrh_type 517-521
        other_comorb 523-527
        other_comorb_type $ 529-568
        painkiller 570-574
        paracetamol 576-578
        treat_type_paracet 580-584
        paracetamol_unknown 586-588
        paracetamol_start $ 590-597
        paracetamol_stop $ 599-606
        ibuprofen 608-610
        treat_type_ibuprofen 612-616
        ibuprofen_unknown 618-620
        ibuprofen_start $ 622-629
        ibuprofen_stop $ 631-638
        aspirin 640-642
        treat_type_aspirin 644-648
        aspirin_unknown 650-652
        aspirin_start $ 654-661
        aspirin_stop $ 663-670
        baseline_comments $ 672-1671
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpvisid LABEL='Visit-ID'
        mnpcvpid LABEL='Patient visit-ID'
        mnpvisno LABEL='Patient visit number'
        mnpvispdt LABEL='Planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        mnpvisfdt LABEL='Date of first data entry in visit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        visit_date LABEL='Date of visit'
        birth_year LABEL='Birth year'
        age LABEL='Age'
        gender LABEL='Gender' FORMAT=cl_vsdg.
        height LABEL='Height'
        weight LABEL='Weight'
        no_clinical_data LABEL='No clinical data' FORMAT=clcb.
        hospitalisation LABEL='Hospitalisation' FORMAT=cl_vsim.
        icu LABEL='ICU => ICU' FORMAT=cl_vsew.
        surgery LABEL='Surgery since last screen?' FORMAT=cl_vsgk.
        immunodeficiency LABEL='Immunodeficiency' FORMAT=cl_vsdy.
        hiv LABEL='HIV => HIV' FORMAT=cl_vsfj.
        hiv_date_uknwn LABEL='HIV date unknown' FORMAT=clcb.
        hiv_date LABEL='HIV HIV diagnosis date'
        liver_cirrh LABEL='Liver cirrhosis Liver cirrhosis' FORMAT=cl_vsij.
        liver_cirrh_type LABEL='Liver cirrhosis type => type' FORMAT=cl_vshh.
        other_comorb LABEL='Other comorbidity Other comorbidity' FORMAT=cl_vsfw.
        other_comorb_type LABEL='Other comorbidity type => type'
        painkiller LABEL='Treatment with painkillers?' FORMAT=cl_vsdt.
        paracetamol LABEL='Paracetamol' FORMAT=cl_vsfg.
        treat_type_paracet LABEL='prior treatment type Paracetamol Treatment Type' FORMAT=cl_vsfk.
        paracetamol_unknown LABEL='prior Paracetamol unknown Treatment interval unknown' FORMAT=clcb.
        paracetamol_start LABEL='prior Paracetamol start Treatment start'
        paracetamol_stop LABEL='prior Paracetamol stop Treatment stop'
        ibuprofen LABEL='Ibuprofen' FORMAT=cl_vsen.
        treat_type_ibuprofen LABEL='prior treatment type Ibuprofen Treatment Type' FORMAT=cl_vsgm.
        ibuprofen_unknown LABEL='prior Ibuprofen unknown Treatment interval unknown' FORMAT=clcb.
        ibuprofen_start LABEL='prior Ibuprofen start Treatment start'
        ibuprofen_stop LABEL='prior Ibuprofen stop Treatment stop'
        aspirin LABEL='Aspirin' FORMAT=cl_vscr.
        treat_type_aspirin LABEL='prior treatment type Aspirin Treatment Type' FORMAT=cl_vsdb.
        aspirin_unknown LABEL='prior Aspirin unknown Treatment interval unknown' FORMAT=clcb.
        aspirin_start LABEL='prior Aspirin start Treatment start'
        aspirin_stop LABEL='prior Aspirin stop Treatment stop'
        baseline_comments LABEL='Comments'
;
run;
/* == end of baseline == */


DATA atbaseline (label='General screen (Audit-Records)');
infile 'dat/atbaseline.dat'
        encoding='UTF-8'
        missover
        LRECL=1683
;
input   mnppid 1-10
        mnpdocid 12-21
        mnpatdocid 23-32
        @34 mnplastedit
        mnpptnid 55-64
        mnpvisid 66-75
        mnpcvpid 77-86
        mnpvisno 88-97
        @99 mnpvispdt
        @111 mnpvisfdt
        mnpfs0 132-133
        mnpfs1 135-136
        mnpfs2 138-139
        mnpfs3 141-142
        mnpfcs0 144-145
        mnpfcs1 147-148
        mnpfcs2 150-151
        mnpfcs3 153-154
        mnpfsqa 156-157
        mnpfsct 159-160
        mnphide 162-163
        sigstatus 165-166
        sigreason $ 168-367
        mnpvsno 369-378
        mnpvslbl $ 380-409
        visit_date $ 411-418
        birth_year $ 420-423
        age 425-446
        gender 448-452
        height 454-460
        weight 462-469
        no_clinical_data 471-473
        hospitalisation 475-479
        icu 481-485
        surgery 487-491
        immunodeficiency 493-497
        hiv 499-503
        hiv_date_uknwn 505-507
        hiv_date $ 509-520
        liver_cirrh 522-526
        liver_cirrh_type 528-532
        other_comorb 534-538
        other_comorb_type $ 540-579
        painkiller 581-585
        paracetamol 587-589
        treat_type_paracet 591-595
        paracetamol_unknown 597-599
        paracetamol_start $ 601-608
        paracetamol_stop $ 610-617
        ibuprofen 619-621
        treat_type_ibuprofen 623-627
        ibuprofen_unknown 629-631
        ibuprofen_start $ 633-640
        ibuprofen_stop $ 642-649
        aspirin 651-653
        treat_type_aspirin 655-659
        aspirin_unknown 661-663
        aspirin_start $ 665-672
        aspirin_stop $ 674-681
        baseline_comments $ 683-1682
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnpatdocid LABEL='ATDocument-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpvisid LABEL='Visit-ID'
        mnpcvpid LABEL='Patient visit-ID'
        mnpvisno LABEL='Patient visit number'
        mnpvispdt LABEL='Planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        mnpvisfdt LABEL='Date of first data entry in visit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        visit_date LABEL='Date of visit'
        birth_year LABEL='Birth year'
        age LABEL='Age'
        gender LABEL='Gender' FORMAT=cl_vsdg.
        height LABEL='Height'
        weight LABEL='Weight'
        no_clinical_data LABEL='No clinical data' FORMAT=clcb.
        hospitalisation LABEL='Hospitalisation' FORMAT=cl_vsim.
        icu LABEL='ICU => ICU' FORMAT=cl_vsew.
        surgery LABEL='Surgery since last screen?' FORMAT=cl_vsgk.
        immunodeficiency LABEL='Immunodeficiency' FORMAT=cl_vsdy.
        hiv LABEL='HIV => HIV' FORMAT=cl_vsfj.
        hiv_date_uknwn LABEL='HIV date unknown' FORMAT=clcb.
        hiv_date LABEL='HIV HIV diagnosis date'
        liver_cirrh LABEL='Liver cirrhosis Liver cirrhosis' FORMAT=cl_vsij.
        liver_cirrh_type LABEL='Liver cirrhosis type => type' FORMAT=cl_vshh.
        other_comorb LABEL='Other comorbidity Other comorbidity' FORMAT=cl_vsfw.
        other_comorb_type LABEL='Other comorbidity type => type'
        painkiller LABEL='Treatment with painkillers?' FORMAT=cl_vsdt.
        paracetamol LABEL='Paracetamol' FORMAT=cl_vsfg.
        treat_type_paracet LABEL='prior treatment type Paracetamol Treatment Type' FORMAT=cl_vsfk.
        paracetamol_unknown LABEL='prior Paracetamol unknown Treatment interval unknown' FORMAT=clcb.
        paracetamol_start LABEL='prior Paracetamol start Treatment start'
        paracetamol_stop LABEL='prior Paracetamol stop Treatment stop'
        ibuprofen LABEL='Ibuprofen' FORMAT=cl_vsen.
        treat_type_ibuprofen LABEL='prior treatment type Ibuprofen Treatment Type' FORMAT=cl_vsgm.
        ibuprofen_unknown LABEL='prior Ibuprofen unknown Treatment interval unknown' FORMAT=clcb.
        ibuprofen_start LABEL='prior Ibuprofen start Treatment start'
        ibuprofen_stop LABEL='prior Ibuprofen stop Treatment stop'
        aspirin LABEL='Aspirin' FORMAT=cl_vscr.
        treat_type_aspirin LABEL='prior treatment type Aspirin Treatment Type' FORMAT=cl_vsdb.
        aspirin_unknown LABEL='prior Aspirin unknown Treatment interval unknown' FORMAT=clcb.
        aspirin_start LABEL='prior Aspirin start Treatment start'
        aspirin_stop LABEL='prior Aspirin stop Treatment stop'
        baseline_comments LABEL='Comments'
;
run;
/* == end of atbaseline == */


DATA outcome (label='Follow-up');
infile 'dat/outcome.dat'
        encoding='UTF-8'
        missover
        LRECL=1415
;
input   mnppid 1-10
        mnpdocid 12-21
        @23 mnplastedit
        mnpptnid 44-53
        mnpvisid 55-64
        mnpcvpid 66-75
        mnpvisno 77-86
        @88 mnpvispdt
        @100 mnpvisfdt
        mnpfs0 121-122
        mnpfs1 124-125
        mnpfs2 127-128
        mnpfs3 130-131
        mnpfcs0 133-134
        mnpfcs1 136-137
        mnpfcs2 139-140
        mnpfcs3 142-143
        mnpfsqa 145-146
        mnpfsct 148-149
        mnphide 151-152
        sigstatus 154-155
        sigreason $ 157-356
        mnpvsno 358-367
        mnpvslbl $ 369-398
        follow_up 400-404
        death_date $ 406-413
        outcome_description $ 415-1414
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpvisid LABEL='Visit-ID'
        mnpcvpid LABEL='Patient visit-ID'
        mnpvisno LABEL='Patient visit number'
        mnpvispdt LABEL='Planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        mnpvisfdt LABEL='Date of first data entry in visit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        follow_up LABEL='Follow-up' FORMAT=cl_vsga.
        death_date LABEL='Exact date of death'
        outcome_description LABEL='Optional description of outcome'
;
run;
/* == end of outcome == */


DATA atoutcome (label='Follow-up (Audit-Records)');
infile 'dat/atoutcome.dat'
        encoding='UTF-8'
        missover
        LRECL=1426
;
input   mnppid 1-10
        mnpdocid 12-21
        mnpatdocid 23-32
        @34 mnplastedit
        mnpptnid 55-64
        mnpvisid 66-75
        mnpcvpid 77-86
        mnpvisno 88-97
        @99 mnpvispdt
        @111 mnpvisfdt
        mnpfs0 132-133
        mnpfs1 135-136
        mnpfs2 138-139
        mnpfs3 141-142
        mnpfcs0 144-145
        mnpfcs1 147-148
        mnpfcs2 150-151
        mnpfcs3 153-154
        mnpfsqa 156-157
        mnpfsct 159-160
        mnphide 162-163
        sigstatus 165-166
        sigreason $ 168-367
        mnpvsno 369-378
        mnpvslbl $ 380-409
        follow_up 411-415
        death_date $ 417-424
        outcome_description $ 426-1425
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnpatdocid LABEL='ATDocument-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpvisid LABEL='Visit-ID'
        mnpcvpid LABEL='Patient visit-ID'
        mnpvisno LABEL='Patient visit number'
        mnpvispdt LABEL='Planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        mnpvisfdt LABEL='Date of first data entry in visit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        follow_up LABEL='Follow-up' FORMAT=cl_vsga.
        death_date LABEL='Exact date of death'
        outcome_description LABEL='Optional description of outcome'
;
run;
/* == end of atoutcome == */


DATA treatment (label='Treatment');
infile 'dat/treatment.dat'
        encoding='UTF-8'
        missover
        LRECL=500
;
input   mnppid 1-10
        mnpdocid 12-21
        @23 mnplastedit
        mnpptnid 44-53
        mnpvisid 55-64
        mnpcvpid 66-75
        mnpvisno 77-86
        @88 mnpvispdt
        @100 mnpvisfdt
        mnpfs0 121-122
        mnpfs1 124-125
        mnpfs2 127-128
        mnpfs3 130-131
        mnpfcs0 133-134
        mnpfcs1 136-137
        mnpfcs2 139-140
        mnpfcs3 142-143
        mnpfsqa 145-146
        mnpfsct 148-149
        mnphide 151-152
        sigstatus 154-155
        sigreason $ 157-356
        mnpvsno 358-367
        mnpvslbl $ 369-398
        rando_treatment $ 400-499
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpvisid LABEL='Visit-ID'
        mnpcvpid LABEL='Patient visit-ID'
        mnpvisno LABEL='Patient visit number'
        mnpvispdt LABEL='Planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        mnpvisfdt LABEL='Date of first data entry in visit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        rando_treatment LABEL='Randomization'
;
run;
/* == end of treatment == */


DATA attreatment (label='Treatment (Audit-Records)');
infile 'dat/attreatment.dat'
        encoding='UTF-8'
        missover
        LRECL=511
;
input   mnppid 1-10
        mnpdocid 12-21
        mnpatdocid 23-32
        @34 mnplastedit
        mnpptnid 55-64
        mnpvisid 66-75
        mnpcvpid 77-86
        mnpvisno 88-97
        @99 mnpvispdt
        @111 mnpvisfdt
        mnpfs0 132-133
        mnpfs1 135-136
        mnpfs2 138-139
        mnpfs3 141-142
        mnpfcs0 144-145
        mnpfcs1 147-148
        mnpfcs2 150-151
        mnpfcs3 153-154
        mnpfsqa 156-157
        mnpfsct 159-160
        mnphide 162-163
        sigstatus 165-166
        sigreason $ 168-367
        mnpvsno 369-378
        mnpvslbl $ 380-409
        rando_treatment $ 411-510
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnpatdocid LABEL='ATDocument-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpvisid LABEL='Visit-ID'
        mnpcvpid LABEL='Patient visit-ID'
        mnpvisno LABEL='Patient visit number'
        mnpvispdt LABEL='Planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        mnpvisfdt LABEL='Date of first data entry in visit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        rando_treatment LABEL='Randomization'
;
run;
/* == end of attreatment == */


DATA allmedi (label='Further medication');
infile 'dat/allmedi.dat'
        encoding='UTF-8'
        missover
        LRECL=436
;
input   mnppid 1-10
        mnpdocid 12-21
        @23 mnplastedit
        mnpptnid 44-53
        mnpvisid 55-64
        mnpcvpid 66-75
        mnpvisno 77-86
        @88 mnpvispdt
        @100 mnpvisfdt
        mnpfs0 121-122
        mnpfs1 124-125
        mnpfs2 127-128
        mnpfs3 130-131
        mnpfcs0 133-134
        mnpfcs1 136-137
        mnpfcs2 139-140
        mnpfcs3 142-143
        mnpfsqa 145-146
        mnpfsct 148-149
        mnphide 151-152
        sigstatus 154-155
        sigreason $ 157-356
        mnpvsno 358-367
        mnpvslbl $ 369-398
        no_more_meds 400-402
        med_family $ 404-418
        med_product $ 420-435
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpvisid LABEL='Visit-ID'
        mnpcvpid LABEL='Patient visit-ID'
        mnpvisno LABEL='Patient visit number'
        mnpvispdt LABEL='Planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        mnpvisfdt LABEL='Date of first data entry in visit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        no_more_meds LABEL='No further medication' FORMAT=clcb.
        med_family LABEL='Family'
        med_product LABEL='Product'
;
run;
/* == end of allmedi == */


DATA atallmedi (label='Further medication (Audit-Records)');
infile 'dat/atallmedi.dat'
        encoding='UTF-8'
        missover
        LRECL=447
;
input   mnppid 1-10
        mnpdocid 12-21
        mnpatdocid 23-32
        @34 mnplastedit
        mnpptnid 55-64
        mnpvisid 66-75
        mnpcvpid 77-86
        mnpvisno 88-97
        @99 mnpvispdt
        @111 mnpvisfdt
        mnpfs0 132-133
        mnpfs1 135-136
        mnpfs2 138-139
        mnpfs3 141-142
        mnpfcs0 144-145
        mnpfcs1 147-148
        mnpfcs2 150-151
        mnpfcs3 153-154
        mnpfsqa 156-157
        mnpfsct 159-160
        mnphide 162-163
        sigstatus 165-166
        sigreason $ 168-367
        mnpvsno 369-378
        mnpvslbl $ 380-409
        no_more_meds 411-413
        med_family $ 415-429
        med_product $ 431-446
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnpatdocid LABEL='ATDocument-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpvisid LABEL='Visit-ID'
        mnpcvpid LABEL='Patient visit-ID'
        mnpvisno LABEL='Patient visit number'
        mnpvispdt LABEL='Planned date of visit' INFORMAT=DATE11. FORMAT=DATE9.
        mnpvisfdt LABEL='Date of first data entry in visit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        no_more_meds LABEL='No further medication' FORMAT=clcb.
        med_family LABEL='Family'
        med_product LABEL='Product'
;
run;
/* == end of atallmedi == */


DATA studyterminat (label='Study termination');
infile 'dat/studyterminat.dat'
        encoding='UTF-8'
        missover
        LRECL=345
;
input   mnppid 1-10
        mnpdocid 12-21
        @23 mnplastedit
        mnpptnid 44-53
        mnpfs0 55-56
        mnpfs1 58-59
        mnpfs2 61-62
        mnpfs3 64-65
        mnpfcs0 67-68
        mnpfcs1 70-71
        mnpfcs2 73-74
        mnpfcs3 76-77
        mnpfsqa 79-80
        mnpfsct 82-83
        mnphide 85-86
        sigstatus 88-89
        sigreason $ 91-290
        mnpvsno 292-301
        mnpvslbl $ 303-332
        term_planned 334-336
        term_toxicity 338-340
        term_death 342-344
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        term_planned LABEL='Planned' FORMAT=cl_vtuz.
        term_toxicity LABEL='Toxicity' FORMAT=cl_vtva.
        term_death LABEL='Death' FORMAT=cl_vtvb.
;
run;
/* == end of studyterminat == */


DATA atstudyterminat (label='Study termination (Audit-Records)');
infile 'dat/atstudyterminat.dat'
        encoding='UTF-8'
        missover
        LRECL=356
;
input   mnppid 1-10
        mnpdocid 12-21
        mnpatdocid 23-32
        @34 mnplastedit
        mnpptnid 55-64
        mnpfs0 66-67
        mnpfs1 69-70
        mnpfs2 72-73
        mnpfs3 75-76
        mnpfcs0 78-79
        mnpfcs1 81-82
        mnpfcs2 84-85
        mnpfcs3 87-88
        mnpfsqa 90-91
        mnpfsct 93-94
        mnphide 96-97
        sigstatus 99-100
        sigreason $ 102-301
        mnpvsno 303-312
        mnpvslbl $ 314-343
        term_planned 345-347
        term_toxicity 349-351
        term_death 353-355
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnpatdocid LABEL='ATDocument-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        term_planned LABEL='Planned' FORMAT=cl_vtuz.
        term_toxicity LABEL='Toxicity' FORMAT=cl_vtva.
        term_death LABEL='Death' FORMAT=cl_vtvb.
;
run;
/* == end of atstudyterminat == */


DATA ae (label='Adverse Events');
infile 'dat/ae.dat'
        encoding='UTF-8'
        missover
        LRECL=2642
;
input   mnppid 1-10
        mnpdocid 12-21
        @23 mnplastedit
        mnpptnid 44-53
        mnpaeid 55-64
        @66 mnpaedate
        mnpaeno 87-96
        mnpaefuid 98-107
        @109 mnpaefudt
        mnpfs0 130-131
        mnpfs1 133-134
        mnpfs2 136-137
        mnpfs3 139-140
        mnpfcs0 142-143
        mnpfcs1 145-146
        mnpfcs2 148-149
        mnpfcs3 151-152
        mnpfsqa 154-155
        mnpfsct 157-158
        mnphide 160-161
        sigstatus 163-164
        sigreason $ 166-365
        mnpvsno 367-376
        mnpvslbl $ 378-407
        ae_description $ 409-948
        ae_onset_date $ 950-957
        ae_onset_time $ 959-962
        ae_ongoing 964-968
        ae_end_date $ 970-977
        ae_end_time $ 979-982
        ae_is_sae 984-988
        ae_intensity 990-994
        ae_drug_relation 996-1000
        ae_frequency 1002-1006
        ae_action 1008-1012
        ae_action_spec $ 1014-1553
        ae_outcome 1555-1559
        ae_outcome_spec $ 1561-2100
        notes $ 2102-2641
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpaeid LABEL='Adverse Event-ID'
        mnpaedate LABEL='Adverse Event date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpaeno LABEL='Adverse Event case number'
        mnpaefuid LABEL='Adverse Event Follow-up-ID'
        mnpaefudt LABEL='Adverse Event Follow-up date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        ae_description LABEL='Description of Adverse Event'
        ae_onset_date LABEL='Onset of AE'
        ae_onset_time LABEL='Timepoints'
        ae_ongoing LABEL='Ongoing' FORMAT=cl_vscv.
        ae_end_date LABEL='End of AE'
        ae_end_time LABEL='Timepoints'
        ae_is_sae LABEL='Is an SAE' FORMAT=cl_vsha.
        ae_intensity LABEL='Intensity' FORMAT=cl_vscw.
        ae_drug_relation LABEL='Relation to study' FORMAT=cl_vsdh.
        ae_frequency LABEL='Frequency' FORMAT=cl_vseo.
        ae_action LABEL='Action taken' FORMAT=cl_vshk.
        ae_action_spec LABEL='Specify therapy / concomitant medication / Comments'
        ae_outcome LABEL='Outcome' FORMAT=cl_vsfn.
        ae_outcome_spec LABEL='If others, please specify'
        notes LABEL='Notes'
;
run;
/* == end of ae == */


DATA atae (label='Adverse Events (Audit-Records)');
infile 'dat/atae.dat'
        encoding='UTF-8'
        missover
        LRECL=2653
;
input   mnppid 1-10
        mnpdocid 12-21
        mnpatdocid 23-32
        @34 mnplastedit
        mnpptnid 55-64
        mnpaeid 66-75
        @77 mnpaedate
        mnpaeno 98-107
        mnpaefuid 109-118
        @120 mnpaefudt
        mnpfs0 141-142
        mnpfs1 144-145
        mnpfs2 147-148
        mnpfs3 150-151
        mnpfcs0 153-154
        mnpfcs1 156-157
        mnpfcs2 159-160
        mnpfcs3 162-163
        mnpfsqa 165-166
        mnpfsct 168-169
        mnphide 171-172
        sigstatus 174-175
        sigreason $ 177-376
        mnpvsno 378-387
        mnpvslbl $ 389-418
        ae_description $ 420-959
        ae_onset_date $ 961-968
        ae_onset_time $ 970-973
        ae_ongoing 975-979
        ae_end_date $ 981-988
        ae_end_time $ 990-993
        ae_is_sae 995-999
        ae_intensity 1001-1005
        ae_drug_relation 1007-1011
        ae_frequency 1013-1017
        ae_action 1019-1023
        ae_action_spec $ 1025-1564
        ae_outcome 1566-1570
        ae_outcome_spec $ 1572-2111
        notes $ 2113-2652
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnpatdocid LABEL='ATDocument-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpaeid LABEL='Adverse Event-ID'
        mnpaedate LABEL='Adverse Event date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpaeno LABEL='Adverse Event case number'
        mnpaefuid LABEL='Adverse Event Follow-up-ID'
        mnpaefudt LABEL='Adverse Event Follow-up date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        ae_description LABEL='Description of Adverse Event'
        ae_onset_date LABEL='Onset of AE'
        ae_onset_time LABEL='Timepoints'
        ae_ongoing LABEL='Ongoing' FORMAT=cl_vscv.
        ae_end_date LABEL='End of AE'
        ae_end_time LABEL='Timepoints'
        ae_is_sae LABEL='Is an SAE' FORMAT=cl_vsha.
        ae_intensity LABEL='Intensity' FORMAT=cl_vscw.
        ae_drug_relation LABEL='Relation to study' FORMAT=cl_vsdh.
        ae_frequency LABEL='Frequency' FORMAT=cl_vseo.
        ae_action LABEL='Action taken' FORMAT=cl_vshk.
        ae_action_spec LABEL='Specify therapy / concomitant medication / Comments'
        ae_outcome LABEL='Outcome' FORMAT=cl_vsfn.
        ae_outcome_spec LABEL='If others, please specify'
        notes LABEL='Notes'
;
run;
/* == end of atae == */


DATA sae (label='Serious Adverse Events');
infile 'dat/sae.dat'
        encoding='UTF-8'
        missover
        LRECL=2636
;
input   mnppid 1-10
        mnpdocid 12-21
        @23 mnplastedit
        mnpptnid 44-53
        mnpaeid 55-64
        @66 mnpaedate
        mnpaeno 87-96
        mnpaefuid 98-107
        @109 mnpaefudt
        mnpfs0 130-131
        mnpfs1 133-134
        mnpfs2 136-137
        mnpfs3 139-140
        mnpfcs0 142-143
        mnpfcs1 145-146
        mnpfcs2 148-149
        mnpfcs3 151-152
        mnpfsqa 154-155
        mnpfsct 157-158
        mnphide 160-161
        sigstatus 163-164
        sigreason $ 166-365
        mnpvsno 367-376
        mnpvslbl $ 378-407
        sae_description $ 409-948
        sae_onset_date $ 950-957
        sae_onset_time $ 959-962
        sae_ongoing 964-968
        sae_end_date $ 970-977
        sae_end_time $ 979-982
        sae_intensity 984-988
        sae_drug_relation 990-994
        sae_frequency 996-1000
        sae_action 1002-1006
        sae_action_spec $ 1008-1547
        sae_outcome 1549-1553
        sae_outcome_spec $ 1555-2094
        notes $ 2096-2635
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpaeid LABEL='Adverse Event-ID'
        mnpaedate LABEL='Adverse Event date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpaeno LABEL='Adverse Event case number'
        mnpaefuid LABEL='Adverse Event Follow-up-ID'
        mnpaefudt LABEL='Adverse Event Follow-up date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        sae_description LABEL='Description of Serious Adverse Event'
        sae_onset_date LABEL='Onset of SAE'
        sae_onset_time LABEL='Timepoints'
        sae_ongoing LABEL='Ongoing' FORMAT=cl_vtuc.
        sae_end_date LABEL='End of SAE'
        sae_end_time LABEL='Timepoints'
        sae_intensity LABEL='Intensity' FORMAT=cl_vttw.
        sae_drug_relation LABEL='Relation to study' FORMAT=cl_vtue.
        sae_frequency LABEL='Frequency' FORMAT=cl_vttt.
        sae_action LABEL='Action taken' FORMAT=cl_vttz.
        sae_action_spec LABEL='Specify therapy / concomitant medication / Comments'
        sae_outcome LABEL='Outcome' FORMAT=cl_vttu.
        sae_outcome_spec LABEL='If others, please specify'
        notes LABEL='Notes'
;
run;
/* == end of sae == */


DATA atsae (label='Serious Adverse Events (Audit-Records)');
infile 'dat/atsae.dat'
        encoding='UTF-8'
        missover
        LRECL=2647
;
input   mnppid 1-10
        mnpdocid 12-21
        mnpatdocid 23-32
        @34 mnplastedit
        mnpptnid 55-64
        mnpaeid 66-75
        @77 mnpaedate
        mnpaeno 98-107
        mnpaefuid 109-118
        @120 mnpaefudt
        mnpfs0 141-142
        mnpfs1 144-145
        mnpfs2 147-148
        mnpfs3 150-151
        mnpfcs0 153-154
        mnpfcs1 156-157
        mnpfcs2 159-160
        mnpfcs3 162-163
        mnpfsqa 165-166
        mnpfsct 168-169
        mnphide 171-172
        sigstatus 174-175
        sigreason $ 177-376
        mnpvsno 378-387
        mnpvslbl $ 389-418
        sae_description $ 420-959
        sae_onset_date $ 961-968
        sae_onset_time $ 970-973
        sae_ongoing 975-979
        sae_end_date $ 981-988
        sae_end_time $ 990-993
        sae_intensity 995-999
        sae_drug_relation 1001-1005
        sae_frequency 1007-1011
        sae_action 1013-1017
        sae_action_spec $ 1019-1558
        sae_outcome 1560-1564
        sae_outcome_spec $ 1566-2105
        notes $ 2107-2646
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Document-ID'
        mnpatdocid LABEL='ATDocument-ID'
        mnplastedit LABEL='Date of last edit' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpptnid LABEL='Participant-ID' FORMAT=cltn.
        mnpaeid LABEL='Adverse Event-ID'
        mnpaedate LABEL='Adverse Event date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpaeno LABEL='Adverse Event case number'
        mnpaefuid LABEL='Adverse Event Follow-up-ID'
        mnpaefudt LABEL='Adverse Event Follow-up date' INFORMAT=DATETIME20. FORMAT=DATETIME20.
        mnpfs0 LABEL='Form status (Review A)' FORMAT=clfs_0x.
        mnpfs1 LABEL='Form status (Review B)' FORMAT=clfs_1x.
        mnpfs2 LABEL='Form status (Freeze)' FORMAT=clfs_2x.
        mnpfs3 LABEL='Form status (System-Freeze)' FORMAT=clfs_3x.
        mnpfcs0 LABEL='Form completion status' FORMAT=clfcs_0x.
        mnpfcs1 LABEL='Form validation status (error)' FORMAT=clfcs_1x.
        mnpfcs2 LABEL='Form validation status (warning)' FORMAT=clfcs_2x.
        mnpfcs3 LABEL='Data entry complete status' FORMAT=clfcs_3x.
        mnpfsqa LABEL='Form status Queries' FORMAT=clfqa.
        mnpfsct LABEL='Form status Comments' FORMAT=clct.
        mnphide LABEL='hidden in DataCapture' FORMAT=clhd.
        sigstatus LABEL='Signature / storage type' FORMAT=clsig.
        sigreason LABEL='Reason for modification'
        mnpvsno LABEL='Version number'
        mnpvslbl LABEL='Version label'
        sae_description LABEL='Description of Serious Adverse Event'
        sae_onset_date LABEL='Onset of SAE'
        sae_onset_time LABEL='Timepoints'
        sae_ongoing LABEL='Ongoing' FORMAT=cl_vtuc.
        sae_end_date LABEL='End of SAE'
        sae_end_time LABEL='Timepoints'
        sae_intensity LABEL='Intensity' FORMAT=cl_vttw.
        sae_drug_relation LABEL='Relation to study' FORMAT=cl_vtue.
        sae_frequency LABEL='Frequency' FORMAT=cl_vttt.
        sae_action LABEL='Action taken' FORMAT=cl_vttz.
        sae_action_spec LABEL='Specify therapy / concomitant medication / Comments'
        sae_outcome LABEL='Outcome' FORMAT=cl_vttu.
        sae_outcome_spec LABEL='If others, please specify'
        notes LABEL='Notes'
;
run;
/* == end of atsae == */


DATA esurgeries (label='Surgeries');
infile 'dat/esurgeries.dat'
        encoding='UTF-8'
        missover
        LRECL=67
;
input   mnppid 1-10
        mnpdocid 12-21
        mnpsubdocid 23-32
        fgid 34-43
        position 45-54
        surgery_type 56-60
        surgery_organ 62-66
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpdocid LABEL='Parent document-ID'
        mnpsubdocid LABEL='Subdocument-ID'
        fgid LABEL='Question-ID of Repetition'
        position LABEL='Position in Repetition'
        surgery_type LABEL='Type' FORMAT=cl_vsgf.
        surgery_organ LABEL='Organ' FORMAT=cl_vsdp.
;

run;
/* == end  of esurgeries== */


DATA atesurgeries (label='Surgeries');
infile 'dat/atesurgeries.dat'
        encoding='UTF-8'
        missover
        LRECL=67
;
input   mnppid 1-10
        mnpatdocid 12-21
        mnpatsubdocid 23-32
        fgid 34-43
        position 45-54
        surgery_type 56-60
        surgery_organ 62-66
;

ATTRIB  mnppid LABEL='Patient-ID'
        mnpatdocid LABEL='Parent ATDocument-ID'
        mnpatsubdocid LABEL='ATSubdocument-ID'
        fgid LABEL='Question-ID of Repetition'
        position LABEL='Position in Repetition'
        surgery_type LABEL='Type' FORMAT=cl_vsgf.
        surgery_organ LABEL='Organ' FORMAT=cl_vsdp.
;

run;
/* == end  of atesurgeries== */


/* == end of file == */

