/*
 * Decompiled with CFR 0.152.
 */
package moa.classifiers.rules.multilabel.core.voting;

import com.yahoo.labs.samoa.instances.Prediction;

public class MultiLabelVote {
    protected Prediction vote;
    protected double error;

    public MultiLabelVote(Prediction vote, double error) {
        this.vote = vote;
        this.error = error;
    }

    public Prediction getVote() {
        return this.vote;
    }

    public void setVote(Prediction vote) {
        this.vote = vote;
    }

    public double getError() {
        return this.error;
    }

    public void setError(double error) {
        this.error = error;
    }

    public double[] sumVoteDistrib() {
        int numOutputs = this.vote.numOutputAttributes();
        double[] sum = new double[numOutputs];
        for (int j = 0; j < numOutputs; ++j) {
            for (int i = 0; i < this.vote.numClasses(j); ++i) {
                int n = j;
                sum[n] = sum[n] + this.vote.getVote(j, i);
            }
        }
        return sum;
    }

    public void normalize() {
        double[] sum = this.sumVoteDistrib();
        for (int j = 0; j < this.vote.numOutputAttributes(); ++j) {
            for (int i = 0; i < this.vote.numClasses(j); ++i) {
                if (sum[j] == 0.0) continue;
                this.vote.setVote(j, i, this.vote.getVote(j, i) / sum[j]);
            }
        }
    }
}

