## ----intro-dense---------------------------------------------------------
dims <- c(2,2,2)
z <- array(c(10,0,0,0,20,0,0,0), dims)
z

## ----into-sparse, message = FALSE----------------------------------------
library(tensorr)

subs <- list(c(1,1,1), c(1,1,2))
vals <- c(10, 20)
dims <- c(2,2,2)
x <- sptensor(subs, vals, dims)
x

## ----intro-ops, eval = FALSE---------------------------------------------
#  # element-wise math operations
#  x + x
#  2 * x
#  x * x
#  max(x)
#  
#  # extracting
#  x[1,1,1]
#  x[1:4]
#  x[list(c(1,1,1), c(1,1,2), c(2,2,2))]
#  
#  # replacing
#  x[1,1,2] <- 30
#  
#  # converting
#  as_dtensor(x)
#  
#  # tensor multiplication
#  m <- matrix(1:6, nrow = 3, ncol = 2)
#  ttm(x, m, 2)
#  
#  # unfolding
#  unfold(x, 1)

## ----sptensor-constructor------------------------------------------------
subs <- list(c(1,1,1), c(1,1,2))
vals <- c(10, 20)
dims <- c(2,2,2)
x <- sptensor(subs, vals, dims)

## ----sptensor-constructor2-----------------------------------------------
subs <- matrix(c(1,1,1, 1,1,2), nrow = length(dims))
x <- sptensor(subs, vals, dims)

## ----sptensor-slots, eval = TRUE-----------------------------------------
# subscripts for non-zero values
nzsubs(x)

# non-zero values
nzvals(x)

# dimensions
dim(x)

## ----dtensor-constructor-------------------------------------------------
dims <- c(2,2,2)
arr <- array(c(10,0,0,0,20,0,0,0), dims)
z <- dtensor(arr)

## ----dtensor-slots-------------------------------------------------------
nzsubs(z)
nzvals(z)
dim(z)

## ----unfold--------------------------------------------------------------
unfold(x, 1)
refold(unfold(x,1))

## ----as-tensor-----------------------------------------------------------
# convert dense tensor to sparse
as_sptensor(z)

# convert sparse tensor to dense
as_dtensor(x)

## ------------------------------------------------------------------------
df <- data.frame(i = c(1, 1), j = c(1, 1), k = c(1,2), val = c(10, 20))
df

as_sptensor(df, dims = dims)

## ----extract-standard----------------------------------------------------
x[1,1,1]
x[1,2,2]

## ----replace-standard----------------------------------------------------
x[1,1,1] <- 100
x[2,2,2] <- 200
x

## ----extract-missing-----------------------------------------------------
x[1,,]
x[1,1:2,1:2]
x[1,,,drop=TRUE]

## ------------------------------------------------------------------------
array(1:8, c(2,2,2))

## ------------------------------------------------------------------------
# get the first three values
x[c(1,2,3)]

# alternatively
x[1:3]

# replace the first and fifth values
x[c(1,5)] <- c(-10, -20)
x

## ------------------------------------------------------------------------
subs <- list(c(1,1,1), c(1,2,1), c(1,1,2))
x[subs]
x[subs] <- c(50, 60, 70)
x

## ------------------------------------------------------------------------
dimnames(x) <- list(LETTERS[1:2], letters[1:2], month.abb[1:2])
dimnames(x)

x[,,"Feb"]
identical(x[,,"Feb"], x[,,2])

## ------------------------------------------------------------------------
x

## ------------------------------------------------------------------------
x + x

## ------------------------------------------------------------------------
x - x

## ------------------------------------------------------------------------
x > 100
x > 2*x

## ------------------------------------------------------------------------
x == x

## ------------------------------------------------------------------------
sqrt(x)
log1p(x)
abs(x)

## ------------------------------------------------------------------------
log(x)

## ------------------------------------------------------------------------
max(x)
range(x)
range(nzvals(x))

## ------------------------------------------------------------------------
u <- unfold(x,1)
u

## ------------------------------------------------------------------------
refold(u)

## ----ttm-----------------------------------------------------------------
m <- matrix(1:6, nrow = 3, ncol = 2)
ttm(x, m, 2)

## ------------------------------------------------------------------------
v <- 1:3
ttv(x,c(3,4),2)

## ------------------------------------------------------------------------
outerprod(x,x)
identical(ttt(x,x), outerprod(x,x))

## ------------------------------------------------------------------------
norm(x)
sqrt(innerprod(x,x))

