/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.rosuda.REngine.REXP;

public class RList
extends Vector
implements List {
    public Vector names;

    public RList() {
        this.names = null;
    }

    public RList(REXP[] contents) {
        super(contents.length);
        int i = 0;
        while (i < contents.length) {
            super.add(contents[i++]);
        }
        this.names = null;
    }

    public RList(int initSize, boolean hasNames) {
        super(initSize);
        this.names = null;
        if (hasNames) {
            this.names = new Vector(initSize);
        }
    }

    public RList(Collection contents) {
        super(contents);
        this.names = null;
    }

    public RList(REXP[] contents, String[] names) {
        this(contents);
        if (names != null && names.length > 0) {
            this.names = new Vector(names.length);
            int i = 0;
            while (i < names.length) {
                this.names.add(names[i++]);
            }
            while (this.names.size() < this.size()) {
                this.names.add(null);
            }
        }
    }

    public RList(Collection contents, String[] names) {
        this(contents);
        if (names != null && names.length > 0) {
            this.names = new Vector(names.length);
            int i = 0;
            while (i < names.length) {
                this.names.add(names[i++]);
            }
            while (this.names.size() < this.size()) {
                this.names.add(null);
            }
        }
    }

    public RList(Collection contents, Collection names) {
        this(contents);
        if (names != null && names.size() > 0) {
            this.names = new Vector(names);
            while (this.names.size() < this.size()) {
                this.names.add(null);
            }
        }
    }

    public boolean isNamed() {
        return this.names != null;
    }

    public REXP at(String v) {
        if (this.names == null) {
            return null;
        }
        int i = this.names.indexOf(v);
        if (i < 0) {
            return null;
        }
        return (REXP)this.elementAt(i);
    }

    public REXP at(int i) {
        return i >= 0 && i < this.size() ? (REXP)this.elementAt(i) : null;
    }

    public String keyAt(int i) {
        return this.names == null || i < 0 || i >= this.names.size() ? null : (String)this.names.get(i);
    }

    public void setKeyAt(int i, String value) {
        if (i < 0) {
            return;
        }
        if (this.names == null) {
            this.names = new Vector();
        }
        if (this.names.size() < this.size()) {
            this.names.setSize(this.size());
        }
        if (i < this.size()) {
            this.names.set(i, value);
        }
    }

    public String[] keys() {
        if (this.names == null) {
            return null;
        }
        String[] k = new String[this.names.size()];
        for (int i = 0; i < k.length; ++i) {
            k[i] = this.keyAt(i);
        }
        return k;
    }

    @Override
    public void add(int index, Object element) {
        super.add(index, element);
        if (this.names == null) {
            return;
        }
        this.names.add(index, null);
    }

    @Override
    public boolean add(Object element) {
        super.add(element);
        if (this.names != null) {
            this.names.add(null);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        boolean ch = super.addAll(c);
        if (this.names == null) {
            return ch;
        }
        int l = this.size();
        while (this.names.size() < l) {
            this.names.add(null);
        }
        return ch;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        boolean ch = super.addAll(index, c);
        if (this.names == null) {
            return ch;
        }
        int l = c.size();
        while (l-- > 0) {
            this.names.add(index, null);
        }
        return ch;
    }

    @Override
    public void clear() {
        super.clear();
        this.names = null;
    }

    @Override
    public Object clone() {
        return new RList((Collection)this, this.names);
    }

    @Override
    public Object remove(int index) {
        Object o = super.remove(index);
        if (this.names != null) {
            this.names.remove(index);
            if (this.size() == 0) {
                this.names = null;
            }
        }
        return o;
    }

    @Override
    public boolean remove(Object elem) {
        int i = this.indexOf(elem);
        if (i < 0) {
            return false;
        }
        this.remove(i);
        if (this.size() == 0) {
            this.names = null;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (this.names == null) {
            return super.removeAll(c);
        }
        boolean changed = false;
        Iterator it = c.iterator();
        while (it.hasNext()) {
            changed |= this.remove(it.next());
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection c) {
        int i;
        if (this.names == null) {
            return super.retainAll(c);
        }
        boolean[] rm = new boolean[this.size()];
        boolean changed = false;
        for (i = 0; i < rm.length; ++i) {
            rm[i] = !c.contains(this.get(i));
            changed |= rm[i];
        }
        while (i > 0) {
            if (!rm[--i]) continue;
            this.remove(i);
        }
        return changed;
    }

    @Override
    public void removeAllElements() {
        this.clear();
    }

    public void insertElementAt(Object obj, int index) {
        this.add(index, obj);
    }

    public void addElement(Object obj) {
        this.add(obj);
    }

    @Override
    public void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public boolean removeElement(Object obj) {
        return this.remove(obj);
    }

    public boolean containsKey(Object key) {
        return this.names == null ? false : this.names.contains(key);
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public Set entrySet() {
        return null;
    }

    public Object get(Object key) {
        return this.at((String)key);
    }

    public Set keySet() {
        if (this.names == null) {
            return null;
        }
        return new HashSet(this.names);
    }

    public Object put(Object key, Object value) {
        int p;
        if (key == null) {
            this.add(value);
            return null;
        }
        if (this.names != null && (p = this.names.indexOf(key)) >= 0) {
            return super.set(p, value);
        }
        int i = this.size();
        super.add(value);
        if (this.names == null) {
            this.names = new Vector(i + 1);
        }
        while (this.names.size() < i) {
            this.names.add(null);
        }
        this.names.add(key);
        return null;
    }

    public void putAll(Map t) {
        if (t == null) {
            return;
        }
        if (t instanceof RList) {
            RList l = (RList)((Object)t);
            if (this.names == null) {
                this.addAll((Collection)l);
                return;
            }
            int n = l.size();
            for (int i = 0; i < n; ++i) {
                String key = l.keyAt(i);
                if (key == null) {
                    this.add(l.at(i));
                    continue;
                }
                this.put(key, l.at(i));
            }
        } else {
            Set ks = t.keySet();
            for (Object key : ks) {
                this.put(key, t.get(key));
            }
        }
    }

    public void putAll(RList t) {
        if (t == null) {
            return;
        }
        RList l = t;
        if (this.names == null) {
            this.addAll((Collection)l);
            return;
        }
        int n = l.size();
        for (int i = 0; i < n; ++i) {
            String key = l.keyAt(i);
            if (key == null) {
                this.add(l.at(i));
                continue;
            }
            this.put(key, l.at(i));
        }
    }

    public Object removeByKey(Object key) {
        if (this.names == null) {
            return null;
        }
        int i = this.names.indexOf(key);
        if (i < 0) {
            return null;
        }
        Object o = this.elementAt(i);
        this.removeElementAt(i);
        this.names.removeElementAt(i);
        return o;
    }

    public Collection values() {
        return this;
    }

    @Override
    public String toString() {
        return "RList" + super.toString() + "{" + (this.isNamed() ? "named," : "") + this.size() + "}";
    }
}

