/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.filters;

import com.sosnoski.util.array.IntArray;
import uk.ac.rhul.cs.cl1.MutableNodeSet;
import uk.ac.rhul.cs.cl1.filters.NodeSetFilter;
import uk.ac.rhul.cs.graph.Directedness;
import uk.ac.rhul.cs.graph.Graph;

public class KCoreFilter
implements NodeSetFilter {
    protected int k = 2;

    public KCoreFilter() {
        this(2);
    }

    public KCoreFilter(int k) {
        this.setK(k);
    }

    public boolean filter(MutableNodeSet nodeSet) {
        boolean finished = false;
        Graph graph = nodeSet.getGraph();
        MutableNodeSet nodeSetCopy = new MutableNodeSet(nodeSet);
        if (this.k <= 0) {
            return true;
        }
        while (!finished) {
            IntArray toRemove = new IntArray();
            for (int i : nodeSetCopy) {
                int[] neis = graph.getAdjacentNodeIndicesArray(i, Directedness.ALL);
                int numNeis = 0;
                for (int nei : neis) {
                    if (!nodeSetCopy.contains(nei)) continue;
                    ++numNeis;
                }
                if (numNeis >= this.k) continue;
                toRemove.add(i);
            }
            nodeSetCopy.remove(toRemove.toArray());
            finished = toRemove.size() == 0;
        }
        return !nodeSetCopy.isEmpty();
    }

    public int getK() {
        return this.k;
    }

    public void setK(int k) {
        this.k = k;
    }
}

