/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import cytoscape.view.cytopanels.CytoPanel;
import cytoscape.view.cytopanels.CytoPanelState;
import giny.model.Node;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.ui.NodeSetTableModel;
import uk.ac.rhul.cs.cl1.ui.PopupMenuTrigger;
import uk.ac.rhul.cs.cl1.ui.RemoveClusterFromResultAction;
import uk.ac.rhul.cs.cl1.ui.ResultViewerPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CopyClusterToClipboardAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.ExtractClusterAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.FindAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.SaveClusterAction;
import uk.ac.rhul.cs.cl1.ui.cytoscape.SaveClusteringAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CytoscapeResultViewerPanel
extends ResultViewerPanel
implements ListSelectionListener {
    private Integer serialNumber = null;
    private static int lastUsedSerialNumber = 1;
    protected List<Node> nodeMapping;
    protected WeakReference<CyNetwork> networkRef;
    protected WeakReference<CyNetworkView> networkViewRef;
    protected JPopupMenu clusterPopup;
    protected AbstractAction copyToClipboardAction;
    protected AbstractAction extractClusterAction;
    protected AbstractAction saveClusterAction;
    protected AbstractAction removeClusterAction;
    protected AbstractAction saveClusterAsCyGroupAction;

    public CytoscapeResultViewerPanel(CyNetwork network, CyNetworkView networkView) {
        this.initializeClusterPopup();
        this.networkRef = new WeakReference<CyNetwork>(network);
        this.networkViewRef = new WeakReference<CyNetworkView>(networkView);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CytoscapeResultViewerPanel.this.extractClusterAction.actionPerformed(null);
                }
            }
        });
        this.table.addMouseListener(new PopupMenuTrigger(this.clusterPopup));
        this.addAction(new FindAction(this));
        this.addAction(new SaveClusteringAction(this));
        this.addAction(new CloseAction(this));
    }

    public void addToCytoscapeResultPanel() {
        if (this.serialNumber == null) {
            this.serialNumber = lastUsedSerialNumber;
            ++lastUsedSerialNumber;
        }
        CytoPanel cytoPanel = Cytoscape.getDesktop().getCytoPanel(3);
        String title = "ClusterONE result " + this.serialNumber;
        cytoPanel.add(title, null, (Component)this, title);
        cytoPanel.setSelectedIndex(cytoPanel.indexOfComponent((Component)this));
        if (cytoPanel.getState() == CytoPanelState.HIDE) {
            cytoPanel.setState(CytoPanelState.DOCK);
        }
    }

    protected List<Node> convertIterableToCytoscapeNodeList(Iterable<Integer> iterable) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int idx : iterable) {
            Node node = this.nodeMapping.get(idx);
            if (node == null) continue;
            result.add(node);
        }
        return result;
    }

    public CyNetwork getNetwork() {
        if (this.networkRef == null) {
            return null;
        }
        return (CyNetwork)this.networkRef.get();
    }

    public CyNetworkView getNetworkView() {
        if (this.networkViewRef == null) {
            return null;
        }
        return (CyNetworkView)this.networkViewRef.get();
    }

    public List<Node> getNodeMapping() {
        return this.nodeMapping;
    }

    public List<Node> getSelectedCytoscapeNodeSet() {
        TreeSet<Integer> selectedIndices = new TreeSet<Integer>();
        for (NodeSet selectedNodeSet : this.getSelectedNodeSets()) {
            for (Integer idx : selectedNodeSet) {
                selectedIndices.add(idx);
            }
        }
        return this.convertIterableToCytoscapeNodeList(selectedIndices);
    }

    public List<List<Node>> getSelectedCytoscapeNodeSets() {
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        for (NodeSet selectedNodeSet : this.getSelectedNodeSets()) {
            result.add(this.convertIterableToCytoscapeNodeList(selectedNodeSet));
        }
        return result;
    }

    public List<List<Node>> getAllCytoscapeNodeSets() {
        NodeSetTableModel model = this.getTableModel();
        int numRows = model.getRowCount();
        ArrayList<List<Node>> result = new ArrayList<List<Node>>();
        for (int i = 0; i < numRows; ++i) {
            result.add(this.convertIterableToCytoscapeNodeList(model.getNodeSetByIndex(i)));
        }
        return result;
    }

    private void initializeClusterPopup() {
        this.clusterPopup = new JPopupMenu();
        this.copyToClipboardAction = new CopyClusterToClipboardAction(this);
        this.copyToClipboardAction.setEnabled(false);
        this.clusterPopup.add(this.copyToClipboardAction);
        this.extractClusterAction = new ExtractClusterAction(this);
        this.extractClusterAction.setEnabled(false);
        this.clusterPopup.add(this.extractClusterAction);
        this.saveClusterAction = new SaveClusterAction(this);
        this.saveClusterAction.setEnabled(false);
        this.clusterPopup.add(this.saveClusterAction);
        this.removeClusterAction = new RemoveClusterFromResultAction(this);
        this.removeClusterAction.setEnabled(false);
        this.clusterPopup.add(this.removeClusterAction);
    }

    public void setNodeMapping(List<Node> mapping) {
        this.nodeMapping = mapping;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        CyNetwork network = this.getNetwork();
        CyNetworkView networkView = this.getNetworkView();
        if (network == null) {
            this.copyToClipboardAction.setEnabled(false);
            this.extractClusterAction.setEnabled(false);
            this.saveClusterAction.setEnabled(false);
            return;
        }
        List<Node> nodes = this.getSelectedCytoscapeNodeSet();
        network.unselectAllNodes();
        network.unselectAllEdges();
        network.setSelectedNodeState(nodes, true);
        network.setSelectedEdgeState((Collection)network.getConnectingEdges(nodes), true);
        networkView.redrawGraph(false, true);
        boolean enabled = nodes.size() > 0;
        this.extractClusterAction.setEnabled(enabled);
        this.copyToClipboardAction.setEnabled(enabled);
        this.saveClusterAction.setEnabled(enabled);
        this.removeClusterAction.setEnabled(enabled);
    }

    class CloseAction
    extends AbstractAction {
        CytoscapeResultViewerPanel panel;

        public CloseAction(CytoscapeResultViewerPanel panel) {
            super("Close");
            this.panel = panel;
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("../../resources/close.png")));
            this.putValue("ShortDescription", "Close this result panel");
        }

        public void actionPerformed(ActionEvent event) {
            CytoPanel cytoPanel = Cytoscape.getDesktop().getCytoPanel(3);
            cytoPanel.remove((Component)this.panel);
            if (cytoPanel.getCytoPanelComponentCount() == 0) {
                cytoPanel.setState(CytoPanelState.HIDE);
            }
        }
    }
}

