/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.cl1.ui.cytoscape;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import uk.ac.rhul.cs.cl1.ClusterONEAlgorithmParameters;
import uk.ac.rhul.cs.cl1.NodeSet;
import uk.ac.rhul.cs.cl1.ValuedNodeSet;
import uk.ac.rhul.cs.cl1.seeding.NodeSetCollectionBasedSeedGenerator;
import uk.ac.rhul.cs.cl1.ui.cytoscape.ControlPanel;
import uk.ac.rhul.cs.cl1.ui.cytoscape.CytoscapePlugin;
import uk.ac.rhul.cs.cl1.ui.cytoscape.Graph;

public class GrowClusterAction
extends CytoscapeAction {
    private static GrowClusterAction globalInstance;
    private Node node = null;

    private GrowClusterAction() {
        super("Grow cluster from selected nodes");
        this.putValue("MnemonicKey", 83);
        this.setPreferredMenu("Plugins.ClusterONE");
    }

    public GrowClusterAction(Node node) {
        super("Grow cluster from this node");
        this.putValue("MnemonicKey", 71);
        this.node = node;
    }

    public void actionPerformed(ActionEvent event) {
        ControlPanel panel = ControlPanel.getShownInstance();
        if (panel == null) {
            return;
        }
        CyNetworkView networkView = Cytoscape.getCurrentNetworkView();
        ClusterONEAlgorithmParameters parameters = panel.getParameters();
        String weightAttr = panel.getWeightAttributeName();
        CyNetwork network = Cytoscape.getCurrentNetwork();
        Graph graph = CytoscapePlugin.convertCyNetworkToGraph(network, weightAttr);
        if (graph == null) {
            return;
        }
        List<Node> nodeMapping = graph.getNodeMapping();
        ArrayList<Integer> nodeIndices = new ArrayList<Integer>();
        if (this.node != null) {
            nodeIndices.add(nodeMapping.indexOf(this.node));
            if ((Integer)nodeIndices.get(0) < 0) {
                CytoscapePlugin.showBugMessage("The selected node does not belong to the selected graph.");
                return;
            }
        } else {
            Set selectedNodes = network.getSelectedNodes();
            for (int idx = 0; idx < nodeMapping.size(); ++idx) {
                if (!selectedNodes.contains(nodeMapping.get(idx))) continue;
                nodeIndices.add(idx);
            }
        }
        if (nodeIndices.size() == 0) {
            CytoscapePlugin.showErrorMessage("There are no selected nodes in the current graph.");
            return;
        }
        parameters.setSeedGenerator(new NodeSetCollectionBasedSeedGenerator(new NodeSet((uk.ac.rhul.cs.graph.Graph)graph, nodeIndices)));
        List<ValuedNodeSet> clusters = CytoscapePlugin.runAlgorithm(graph, parameters, weightAttr);
        if (clusters == null) {
            CytoscapePlugin.showBugMessage("No results returned from ClusterONE.");
            return;
        }
        if (clusters.size() == 0) {
            CytoscapePlugin.showInformationMessage("There is no cluster associated to this node.\nMaybe it was filtered out by the size or the density filter?");
            return;
        }
        if (clusters.size() > 1) {
            CytoscapePlugin.showBugMessage("More than one cluster was returned from ClusterONE.");
            return;
        }
        NodeSet cluster = clusters.get(0);
        ArrayList<Node> selectedNodes = new ArrayList<Node>();
        for (int idx : cluster) {
            selectedNodes.add(nodeMapping.get(idx));
        }
        network.unselectAllNodes();
        network.unselectAllEdges();
        network.setSelectedNodeState(selectedNodes, true);
        network.setSelectedEdgeState((Collection)network.getConnectingEdges(selectedNodes), true);
        if (networkView != null) {
            networkView.redrawGraph(false, true);
        }
    }

    public static synchronized GrowClusterAction getGlobalInstance() {
        if (globalInstance == null) {
            globalInstance = new GrowClusterAction();
        }
        return globalInstance;
    }

    public boolean isInToolBar() {
        return false;
    }
}

