/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.data.SubTableOfInt;
import ec.tstoolkit.data.TableOfInt;

public class GaSpecification
implements Cloneable {
    private boolean m_f0;
    private int m_fmin;
    private int m_fmax;
    private boolean m_bfgs;
    private EstimationMode m_emode = EstimationMode.Exhaustive;
    private Criterion m_criterion = Criterion.AIC;
    private double m_urBound = 0.999;
    private boolean m_fixUR;

    public GaSpecification() {
        this.setDefault();
    }

    public final void setDefault() {
        this.m_f0 = false;
        this.m_fmin = 1;
        this.m_fmax = 2;
        this.m_bfgs = false;
        this.m_criterion = Criterion.AIC;
        this.m_urBound = 0.999;
        this.m_fixUR = true;
        this.m_emode = EstimationMode.Selective;
    }

    public boolean isFixingUnitRoots() {
        return this.m_fixUR;
    }

    public void fixUnitRoots(boolean value) {
        this.m_fixUR = value;
    }

    public boolean isFreeZeroFrequencyParameter() {
        return this.m_f0;
    }

    public void setFreeZeroFrequencyParameter(boolean value) {
        this.m_f0 = value;
    }

    public int getMinFrequencyGroup() {
        return this.m_fmin;
    }

    public void setMinFrequencyGroup(int value) {
        this.m_fmin = value;
    }

    public int getMaxFrequencyGroup() {
        return this.m_fmax;
    }

    public void setMaxFrequencyGroup(int value) {
        this.m_fmax = value;
    }

    public boolean isUsingBFGS() {
        return this.m_bfgs;
    }

    public void useBFGS(boolean value) {
        this.m_bfgs = value;
    }

    public Criterion getCriterion() {
        return this.m_criterion;
    }

    public void setCriterion(Criterion value) {
        this.m_criterion = value;
    }

    public double getURBound() {
        return this.m_urBound;
    }

    public void setURBound(double value) {
        this.m_urBound = value;
    }

    public EstimationMode getEstimationMode() {
        return this.m_emode;
    }

    public void setEstimationMode(EstimationMode emode) {
        this.m_emode = emode;
    }

    public String[] generateModelTypes(int freq) {
        TableOfInt table = this.generateParameters(freq);
        String[] rslt = new String[table.getRowsCount() + 1];
        rslt[0] = "Airline (2)";
        int nparams = this.m_f0 ? 4 : 3;
        for (int i = 0; i < table.getRowsCount(); ++i) {
            SubArrayOfInt c = table.row(i);
            int gcount = 0;
            for (int j = 0; j < table.getColumnsCount(); ++j) {
                if (c.get(j) != nparams - 1) continue;
                ++gcount;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(freq / 2 - gcount);
            builder.append('-');
            builder.append(gcount);
            builder.append(" (").append(nparams).append("){");
            int j = 0;
            do {
                if (c.get(j) == nparams - 1) {
                    builder.append(j + 1);
                    if (--gcount <= 0) break;
                    builder.append('-');
                }
                ++j;
            } while (gcount > 0);
            builder.append('}');
            rslt[i + 1] = builder.toString();
        }
        return rslt;
    }

    public TableOfInt generateParameters(int freq) {
        int nrows = 0;
        int freq2 = freq / 2;
        int freq4 = freq2 / 2;
        int imin = Math.min(freq4, this.getMinFrequencyGroup());
        int imax = Math.min(freq4, this.getMaxFrequencyGroup());
        if (imin > 0) {
            for (int i = imin; i <= imax; ++i) {
                if (2 * i == freq2 && this.isFreeZeroFrequencyParameter()) {
                    nrows += this.C(freq2, i) / 2;
                    continue;
                }
                nrows += this.C(freq2, i);
            }
        }
        int ncols = freq2;
        TableOfInt rslt = new TableOfInt(nrows, ncols);
        int idx = 0;
        int k = 0;
        if (this.isFreeZeroFrequencyParameter()) {
            rslt.extract(0, nrows, 0, ncols).set(2);
            k = 3;
        } else {
            rslt.extract(0, nrows, 0, ncols).set(1);
            k = 2;
        }
        if (imin > 0) {
            for (int i = imin; i <= imax; ++i) {
                SubTableOfInt sm;
                if (2 * i == freq2 && this.isFreeZeroFrequencyParameter()) {
                    sm = rslt.extract(idx, rslt.getRowsCount(), 1, rslt.getColumnsCount());
                    int nidx = this.fill(sm, k, i);
                    idx += nidx;
                    continue;
                }
                sm = rslt.extract(idx, rslt.getRowsCount(), 0, rslt.getColumnsCount());
                idx += this.fill(sm, k, i);
            }
        }
        return rslt;
    }

    private int C(int n, int p) {
        int j;
        int c = n;
        for (j = n - 1; j > n - p; --j) {
            c *= j;
        }
        for (j = p; j > 1; --j) {
            c /= j;
        }
        return c;
    }

    private int fill(SubTableOfInt rslt, int k, int i) {
        int ncols = rslt.getColumnsCount();
        if (i == 1) {
            for (int b = 0; b < ncols; ++b) {
                rslt.set(b, b, k);
            }
            return ncols;
        }
        int r = 0;
        for (int b = 0; b <= ncols - i; ++b) {
            int dr = this.fill(rslt.extract(r, rslt.getRowsCount(), b + 1, ncols), k, i - 1);
            for (int j = 0; j < dr; ++j) {
                rslt.set(r++, b, k);
            }
        }
        return r;
    }

    public GaSpecification clone() {
        try {
            return (GaSpecification)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public static enum Criterion {
        AIC,
        BIC,
        GMAIC;

    }

    public static enum EstimationMode {
        Exhaustive,
        Iterative,
        Selective;

    }
}

