/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.utilities.Arrays2;
import ec.tstoolkit.utilities.IntList;
import java.util.Arrays;

@Deprecated
public class Values
implements IReadDataBlock,
Cloneable {
    private double[] m_vals;
    private int m_nm;

    public static Values add(double d, Values vals) {
        return Values.add(vals, d);
    }

    public static Values add(Values vals, double d) {
        Values nvals = new Values(vals.getLength());
        for (int i = 0; i < vals.getLength(); ++i) {
            if (!Double.isFinite(vals.get(i))) continue;
            nvals.set(i, vals.get(i) + d);
        }
        return nvals;
    }

    public static Values divide(double d, Values vals) {
        Values nvals = new Values(vals.getLength());
        for (int i = 0; i < vals.getLength(); ++i) {
            if (!Double.isFinite(vals.get(i)) || vals.get(i) == 0.0) continue;
            nvals.set(i, d / vals.get(i));
        }
        return nvals;
    }

    public static Values divide(Values vals, double d) {
        Values nvals = new Values(vals.getLength());
        if (d != 0.0) {
            for (int i = 0; i < vals.getLength(); ++i) {
                if (!Double.isFinite(vals.get(i))) continue;
                nvals.set(i, vals.get(i) / d);
            }
        }
        return nvals;
    }

    public static Values multiply(double d, Values vals) {
        return Values.multiply(vals, d);
    }

    public static Values multiply(Values vals, double d) {
        Values nvals = new Values(vals.getLength());
        for (int i = 0; i < vals.getLength(); ++i) {
            if (!Double.isFinite(vals.get(i))) continue;
            nvals.set(i, vals.get(i) * d);
        }
        return nvals;
    }

    public static Values subtract(double d, Values vals) {
        Values nvals = new Values(vals.getLength());
        for (int i = 0; i < vals.getLength(); ++i) {
            if (!Double.isFinite(vals.get(i))) continue;
            nvals.set(i, d - vals.get(i));
        }
        return nvals;
    }

    public static Values subtract(Values vals, double d) {
        Values nvals = new Values(vals.getLength());
        for (int i = 0; i < vals.getLength(); ++i) {
            if (!Double.isFinite(vals.get(i))) continue;
            nvals.set(i, vals.get(i) - d);
        }
        return nvals;
    }

    public Values() {
        this.m_vals = Arrays2.EMPTY_DOUBLE_ARRAY;
    }

    public Values(double[] data) {
        this.m_vals = (double[])data.clone();
        this.m_nm = -1;
    }

    public Values(double[] data, boolean copydata) {
        this.m_vals = copydata ? (double[])data.clone() : data;
        this.m_nm = -1;
    }

    public Values(int n) {
        this.m_vals = new double[n];
        for (int i = 0; i < this.m_vals.length; ++i) {
            this.m_vals[i] = Double.NaN;
        }
        this.m_nm = n;
    }

    public Values(int n, double val) {
        this.m_vals = new double[n];
        Arrays.fill(this.m_vals, val);
        this.m_nm = Double.isNaN(val) ? n : 0;
    }

    public Values(IReadDataBlock data) {
        this.m_vals = new double[data.getLength()];
        data.copyTo(this.m_vals, 0);
    }

    public void abs() {
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            this.m_vals[i] = Math.abs(this.m_vals[i]);
        }
    }

    public void add(double d) {
        if (d == 0.0) {
            return;
        }
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            int n = i;
            this.m_vals[n] = this.m_vals[n] + d;
        }
    }

    public void add(int pos, double d) {
        if (Double.isFinite(this.m_vals[pos])) {
            int n = pos;
            this.m_vals[n] = this.m_vals[n] + d;
        }
    }

    public void chs() {
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            this.m_vals[i] = -this.m_vals[i];
        }
    }

    public Values clone() {
        try {
            Values vals = (Values)super.clone();
            vals.m_vals = (double[])this.m_vals.clone();
            return vals;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public void copy(Values v) {
        int n = this.m_vals.length;
        if (n > v.m_vals.length) {
            n = v.m_vals.length;
        }
        for (int i = 0; i < n; ++i) {
            this.m_vals[i] = v.m_vals[i];
        }
        this.m_nm = -1;
    }

    public void copyFrom(double[] vals, int start) {
        int n = this.m_vals.length;
        if (n > vals.length - start) {
            n = vals.length - start;
        }
        int i = 0;
        int j = start;
        while (i < n) {
            this.m_vals[i] = vals[j];
            ++i;
            ++j;
        }
        this.m_nm = -1;
    }

    @Override
    public void copyTo(double[] buffer, int start) {
        for (int i = 0; i < this.m_vals.length; ++i) {
            buffer[start + i] = this.m_vals[i];
        }
    }

    public void div(double d) {
        if (d == 0.0) {
            this.m_nm = this.m_vals.length;
        } else if (d == 1.0) {
            return;
        }
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            int n = i;
            this.m_vals[n] = this.m_vals[n] / d;
        }
    }

    public Values drop(int nfirst, int nlast) {
        return this.extend(-nfirst, -nlast);
    }

    public void exp() {
        this.m_nm = -1;
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            this.m_vals[i] = Math.exp(this.m_vals[i]);
        }
    }

    public Values extend(int nb, int ne) {
        if (nb == 0 && ne == 0) {
            return this.clone();
        }
        int sz = this.m_vals.length + nb + ne;
        if (sz <= 0) {
            return new Values(0);
        }
        Values rslt = new Values(sz);
        int i0 = 0;
        int i1 = this.m_vals.length;
        int j0 = -nb;
        int j1 = i1 + ne;
        int beg = Math.max(i0, j0);
        int end = Math.min(i1, j1);
        int ncopy = end - beg;
        int cur = nb > 0 ? nb : 0;
        for (int i = 0; i < ncopy; ++i) {
            rslt.set(cur++, this.m_vals[beg + i]);
        }
        rslt.m_nm = this.m_nm == 0 ? 0 : -1;
        return rslt;
    }

    @Override
    public double get(int idx) {
        return this.m_vals[idx];
    }

    @Override
    public int getLength() {
        return this.m_vals.length;
    }

    public int getMissingValuesCount() {
        if (this.m_nm < 0) {
            this.m_nm = 0;
            for (double element : this.m_vals) {
                if (Double.isFinite(element)) continue;
                ++this.m_nm;
            }
        }
        return this.m_nm;
    }

    public int getObsCount() {
        return this.m_vals.length - this.getMissingValuesCount();
    }

    @Override
    public int getRepeatCount() {
        int i;
        for (i = 0; i < this.m_vals.length && !Double.isFinite(this.m_vals[i]); ++i) {
        }
        if (i == this.m_vals.length) {
            return 0;
        }
        int c = 0;
        double prev = this.m_vals[i++];
        while (i < this.m_vals.length) {
            double cur = this.m_vals[i];
            if (Double.isFinite(cur)) {
                if (cur == prev) {
                    ++c;
                } else {
                    prev = cur;
                }
            }
            ++i;
        }
        return c;
    }

    public boolean hasMissingValues() {
        return this.getMissingValuesCount() > 0;
    }

    public double[] internalStorage() {
        this.m_nm = -1;
        return this.m_vals;
    }

    public void inv() {
        this.m_nm = -1;
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            this.m_vals[i] = this.m_vals[i] != 0.0 ? 1.0 / this.m_vals[i] : Double.NaN;
        }
    }

    public boolean isEmpty() {
        return this.m_vals.length == 0;
    }

    @Override
    public boolean isMissing(int i) {
        return !Double.isFinite(this.m_vals[i]);
    }

    public void log() {
        this.m_nm = -1;
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            this.m_vals[i] = this.m_vals[i] > 0.0 ? Math.log(this.m_vals[i]) : Double.NaN;
        }
    }

    public void log(double b) {
        if (b <= 0.0) {
            return;
        }
        this.m_nm = -1;
        double c = Math.log(b);
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            this.m_vals[i] = this.m_vals[i] > 0.0 ? Math.log(this.m_vals[i]) / c : Double.NaN;
        }
    }

    public int[] maxIndexes() {
        int i;
        for (i = 0; i < this.m_vals.length && !Double.isFinite(this.m_vals[i]); ++i) {
        }
        if (i == this.m_vals.length) {
            return null;
        }
        IntList indexes = new IntList(this.m_vals.length - i);
        double curmax = this.m_vals[i++];
        indexes.add(i);
        while (i < this.m_vals.length) {
            if (Double.isFinite(this.m_vals[i])) {
                if (this.m_vals[i] > curmax) {
                    curmax = this.m_vals[i];
                    indexes.clear();
                    indexes.add(i);
                } else if (this.m_vals[i] == curmax) {
                    indexes.add(i);
                }
            }
            ++i;
        }
        return indexes.toArray();
    }

    public int[] minIndexes() {
        int i;
        for (i = 0; i < this.m_vals.length && !Double.isFinite(this.m_vals[i]); ++i) {
        }
        if (i == this.m_vals.length) {
            return null;
        }
        IntList indexes = new IntList(this.m_vals.length - i);
        double curmin = this.m_vals[i++];
        indexes.add(i);
        while (i < this.m_vals.length) {
            if (Double.isFinite(this.m_vals[i])) {
                if (this.m_vals[i] < curmin) {
                    curmin = this.m_vals[i];
                    indexes.clear();
                    indexes.add(i);
                } else if (this.m_vals[i] == curmin) {
                    indexes.add(i);
                }
            }
            ++i;
        }
        return indexes.toArray();
    }

    public void mul(double d) {
        if (d == 1.0) {
            return;
        }
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            int n = i;
            this.m_vals[n] = this.m_vals[n] * d;
        }
    }

    public void mul(int pos, double d) {
        if (Double.isFinite(this.m_vals[pos])) {
            int n = pos;
            this.m_vals[n] = this.m_vals[n] * d;
        }
    }

    public void pow(double e) {
        this.m_nm = -1;
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            this.m_vals[i] = Math.pow(this.m_vals[i], e);
        }
    }

    public void round(int ndec) {
        int i;
        if (ndec < 0) {
            throw new IllegalArgumentException("Negative rounding parameter");
        }
        double f = 1.0;
        for (i = 0; i < ndec; ++i) {
            f *= 10.0;
        }
        for (i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            double v = this.m_vals[i];
            this.m_vals[i] = ndec > 0 ? (double)Math.round(v * f) / f : (double)Math.round(v);
        }
    }

    @Override
    public IReadDataBlock rextract(int start, int length) {
        return new ReadDataBlock(this.m_vals, start, length);
    }

    public void scale(double a, double b) {
        if (a != 1.0 && b != 0.0) {
            for (int i = 0; i < this.m_vals.length; ++i) {
                if (!Double.isFinite(this.m_vals[i])) continue;
                this.m_vals[i] = a * this.m_vals[i] + b;
            }
        } else if (b == 0.0) {
            for (int i = 0; i < this.m_vals.length; ++i) {
                if (!Double.isFinite(this.m_vals[i])) continue;
                int n = i;
                this.m_vals[n] = this.m_vals[n] * a;
            }
        } else {
            for (int i = 0; i < this.m_vals.length; ++i) {
                if (!Double.isFinite(this.m_vals[i])) continue;
                int n = i;
                this.m_vals[n] = this.m_vals[n] + b;
            }
        }
    }

    public void set(double d) {
        this.m_nm = 0;
        for (int i = 0; i < this.m_vals.length; ++i) {
            this.m_vals[i] = d;
        }
    }

    public void set(int idx, double value) {
        this.m_vals[idx] = value;
        this.m_nm = -1;
    }

    public void setMissing(int i) {
        this.m_vals[i] = Double.NaN;
        this.m_nm = -1;
    }

    public void setMissingValues(double nv) {
        if (this.hasMissingValues()) {
            for (int i = 0; i < this.m_vals.length; ++i) {
                if (Double.isFinite(this.m_vals[i])) continue;
                this.m_vals[i] = nv;
            }
            if (Double.isFinite(nv)) {
                this.m_nm = 0;
            }
        }
    }

    public void sub(double d) {
        if (d == 0.0) {
            return;
        }
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            int n = i;
            this.m_vals[n] = this.m_vals[n] - d;
        }
    }

    public void sqrt() {
        this.m_nm = -1;
        for (int i = 0; i < this.m_vals.length; ++i) {
            if (!Double.isFinite(this.m_vals[i])) continue;
            this.m_vals[i] = this.m_vals[i] >= 0.0 ? Math.sqrt(this.m_vals[i]) : Double.NaN;
        }
    }

    public String toString() {
        return ReadDataBlock.toString(this);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Values && this.equals((Values)obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Arrays.hashCode(this.m_vals);
        return hash;
    }

    public boolean equals(Values other) {
        return Arrays.equals(this.m_vals, other.m_vals);
    }
}

