/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.implementation.TramoProcessingFactory;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.RegressionTestType;
import ec.tstoolkit.modelling.arima.IOutliersDetectionModule;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IPreprocessor;
import ec.tstoolkit.modelling.arima.IRegArimaSpecification;
import ec.tstoolkit.modelling.arima.UnitSeriesScaling;
import ec.tstoolkit.modelling.arima.tramo.ArimaSpec;
import ec.tstoolkit.modelling.arima.tramo.ArmaModule;
import ec.tstoolkit.modelling.arima.tramo.AutoModelSpec;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.DifferencingModule;
import ec.tstoolkit.modelling.arima.tramo.EasterSpec;
import ec.tstoolkit.modelling.arima.tramo.EstimateSpec;
import ec.tstoolkit.modelling.arima.tramo.FinalEstimator;
import ec.tstoolkit.modelling.arima.tramo.LogLevelTest;
import ec.tstoolkit.modelling.arima.tramo.ModelBenchmarking;
import ec.tstoolkit.modelling.arima.tramo.OutlierSpec;
import ec.tstoolkit.modelling.arima.tramo.OutliersDetector;
import ec.tstoolkit.modelling.arima.tramo.RegressionSpec;
import ec.tstoolkit.modelling.arima.tramo.RegressionTestTD;
import ec.tstoolkit.modelling.arima.tramo.RegressionTestTD2;
import ec.tstoolkit.modelling.arima.tramo.RegressionVariablesTest;
import ec.tstoolkit.modelling.arima.tramo.RegressionVariablesTest2;
import ec.tstoolkit.modelling.arima.tramo.RegularUnderDifferencingTest;
import ec.tstoolkit.modelling.arima.tramo.RegularUnderDifferencingTest2;
import ec.tstoolkit.modelling.arima.tramo.SeasonalUnderDifferencingTest;
import ec.tstoolkit.modelling.arima.tramo.SeasonalUnderDifferencingTest2;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityDetector;
import ec.tstoolkit.modelling.arima.tramo.TDController;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.tramo.TramoModelBuilder;
import ec.tstoolkit.modelling.arima.tramo.TramoProcessor;
import ec.tstoolkit.modelling.arima.tramo.TransformSpec;
import ec.tstoolkit.timeseries.calendars.DefaultGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.IGregorianCalendarProvider;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.AdditiveOutlierFactory;
import ec.tstoolkit.timeseries.regression.LevelShiftFactory;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.OutliersFactory;
import ec.tstoolkit.timeseries.regression.SeasonalOutlierFactory;
import ec.tstoolkit.timeseries.regression.TransitoryChangeFactory;
import ec.tstoolkit.timeseries.simplets.AverageInterpolator;
import ec.tstoolkit.utilities.Arrays2;
import java.util.Map;
import java.util.Objects;

public class TramoSpecification
implements Cloneable,
IRegArimaSpecification {
    private static final double CVAL = 1.96;
    public static final TramoSpecification TR0;
    public static final TramoSpecification TR1;
    public static final TramoSpecification TR2;
    public static final TramoSpecification TR3;
    public static final TramoSpecification TR4;
    public static final TramoSpecification TR5;
    public static final TramoSpecification TRfull;
    private static final String SMETHOD = "TR";
    public static final String TRANSFORM = "transform";
    public static final String AUTOMDL = "automdl";
    public static final String ARIMA = "arima";
    public static final String REGRESSION = "regression";
    public static final String OUTLIER = "outlier";
    public static final String ESTIMATE = "esimate";
    static final LevelShiftFactory LFAC;
    static final TransitoryChangeFactory TFAC;
    static final AdditiveOutlierFactory AFAC;
    static final SeasonalOutlierFactory SFAC;
    private ArimaSpec arima_;
    private TransformSpec transform_ = new TransformSpec();
    private AutoModelSpec automdl_;
    private EstimateSpec estimate_ = new EstimateSpec();
    private OutlierSpec outlier_;
    private RegressionSpec regression_;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        EstimateSpec.fillDictionary(InformationSet.item(prefix, ESTIMATE), dic);
        TransformSpec.fillDictionary(InformationSet.item(prefix, TRANSFORM), dic);
        AutoModelSpec.fillDictionary(InformationSet.item(prefix, AUTOMDL), dic);
        ArimaSpec.fillDictionary(InformationSet.item(prefix, ARIMA), dic);
        OutlierSpec.fillDictionary(InformationSet.item(prefix, OUTLIER), dic);
        RegressionSpec.fillDictionary(InformationSet.item(prefix, REGRESSION), dic);
    }

    public static final TramoSpecification[] allSpecifications() {
        return new TramoSpecification[]{TR0, TR1, TR2, TR3, TR4, TR5, TRfull};
    }

    public TramoSpecification() {
        this.automdl_ = new AutoModelSpec();
        this.outlier_ = new OutlierSpec();
        this.arima_ = new ArimaSpec();
        this.arima_.setMean(true);
        this.regression_ = new RegressionSpec();
    }

    @Override
    public TramoSpecification clone() {
        try {
            TramoSpecification spec = (TramoSpecification)super.clone();
            spec.transform_ = this.transform_.clone();
            spec.arima_ = this.arima_.clone();
            spec.automdl_ = this.automdl_.clone();
            spec.regression_ = this.regression_.clone();
            spec.outlier_ = this.outlier_.clone();
            spec.estimate_ = this.estimate_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public TransformSpec getTransform() {
        return this.transform_;
    }

    public void setTransform(TransformSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(TRANSFORM);
        }
        this.transform_ = value;
    }

    public AutoModelSpec getAutoModel() {
        return this.automdl_;
    }

    public void setAutoModel(AutoModelSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(AUTOMDL);
        }
        this.automdl_ = value;
        this.automdl_.setEnabled(true);
    }

    public boolean isUsingAutoModel() {
        return this.automdl_.isEnabled();
    }

    public void setUsingAutoModel(boolean enableAutoModel) {
        this.automdl_.setEnabled(enableAutoModel);
    }

    public ArimaSpec getArima() {
        return this.arima_;
    }

    public void setArima(ArimaSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(ARIMA);
        }
        this.arima_ = value;
        this.setUsingAutoModel(false);
    }

    public EstimateSpec getEstimate() {
        return this.estimate_;
    }

    public void setEstimate(EstimateSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(ESTIMATE);
        }
        this.estimate_ = value;
    }

    public OutlierSpec getOutliers() {
        return this.outlier_;
    }

    public void setOutliers(OutlierSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(OUTLIER);
        }
        this.outlier_ = value;
    }

    public RegressionSpec getRegression() {
        return this.regression_;
    }

    public void setRegression(RegressionSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(REGRESSION);
        }
        this.regression_ = value;
    }

    private IPreprocessingModule makeLogLevel(TransformSpec transform_) {
        if (transform_.getFunction() != DefaultTransformationType.Auto) {
            return null;
        }
        LogLevelTest ll = new LogLevelTest();
        ll.setLogPreference(Math.log(transform_.getFct()));
        return ll;
    }

    private IOutliersDetectionModule makeOutliers(OutlierSpec o, AutoModelSpec am) {
        Object[] types = o.getTypes();
        if (Arrays2.isNullOrEmpty(types)) {
            return null;
        }
        OutliersDetector detector = new OutliersDetector();
        block6: for (int i = 0; i < types.length; ++i) {
            switch (1.$SwitchMap$ec$tstoolkit$timeseries$regression$OutlierType[((Enum)types[i]).ordinal()]) {
                case 1: {
                    detector.addOutlierFactory(AFAC);
                    continue block6;
                }
                case 2: {
                    detector.addOutlierFactory(LFAC);
                    continue block6;
                }
                case 3: {
                    detector.addOutlierFactory(SFAC);
                    continue block6;
                }
                case 4: {
                    if (this.outlier_.getDeltaTC() == 0.7) {
                        detector.addOutlierFactory(TFAC);
                        continue block6;
                    }
                    TransitoryChangeFactory t = new TransitoryChangeFactory();
                    t.setCoefficient(this.outlier_.getDeltaTC());
                    detector.addOutlierFactory(t);
                }
            }
        }
        detector.setCriticalValue(o.getCriticalValue());
        detector.useEML(o.isEML());
        detector.setSpan(o.getSpan());
        if (am != null) {
            detector.setPc(am.getPc());
        }
        return detector;
    }

    private FinalEstimator makeFinalEstimator(EstimateSpec estimate, double tsig) {
        FinalEstimator estimator = new FinalEstimator();
        estimator.setEpsilon(estimate.getTol());
        estimator.setUr(estimate.getUbp());
        estimator.setTsig(tsig);
        return estimator;
    }

    IGregorianCalendarProvider tdProvider(ProcessingContext context) {
        TradingDaysSpec tdspec = this.regression_.getCalendar().getTradingDays();
        if (tdspec.isStockTradingDays() || tdspec.getUserVariables() != null) {
            return null;
        }
        if (tdspec.getHolidays() != null && context != null) {
            return (IGregorianCalendarProvider)context.getGregorianCalendars().get(tdspec.getHolidays());
        }
        return DefaultGregorianCalendarProvider.instance;
    }

    private void makeAutoModelling(TramoProcessor tramo, AutoModelSpec automdl, TradingDaysSpec td, ProcessingContext context) {
        if (automdl.isEnabled()) {
            DifferencingModule diff = new DifferencingModule();
            diff.setCancel(automdl.getCancel());
            diff.setUB1(automdl.getUb1());
            diff.setUB2(automdl.getUb2());
            tramo.controllers.add(new RegularUnderDifferencingTest());
            tramo.controllers.add(new SeasonalUnderDifferencingTest());
            if (automdl.isAcceptDefault()) {
                tramo.setFal(true);
            }
            if (automdl.isAmiCompare()) {
                tramo.controllers.add(new ModelBenchmarking());
            }
            if (td.isAutomatic()) {
                tramo.controllers.add(new TDController(this.tdProvider(context), td.getProbabibilityForFTest()));
            }
            tramo.controllers.add(new SeasonalUnderDifferencingTest2());
            tramo.controllers.add(new RegularUnderDifferencingTest2());
            tramo.differencing = diff;
            tramo.autoModelling = new ArmaModule();
        } else if (td.isAutomatic()) {
            tramo.controllers.add(new TDController(this.tdProvider(context), td.getProbabibilityForFTest()));
        }
    }

    private SeasonalityDetector makeSeas() {
        return new SeasonalityDetector();
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet reginfo;
        InformationSet estimateinfo;
        InformationSet outlierinfo;
        InformationSet amiinfo;
        InformationSet arimainfo;
        InformationSet specInfo = new InformationSet();
        specInfo.add("algorithm", TramoProcessingFactory.DESCRIPTOR);
        InformationSet tinfo = this.transform_.write(verbose);
        if (tinfo != null) {
            specInfo.add(TRANSFORM, tinfo);
        }
        if ((arimainfo = this.arima_.write(verbose)) != null) {
            specInfo.add(ARIMA, arimainfo);
        }
        if ((amiinfo = this.automdl_.write(verbose)) != null) {
            specInfo.add(AUTOMDL, amiinfo);
        }
        if ((outlierinfo = this.outlier_.write(verbose)) != null) {
            specInfo.add(OUTLIER, outlierinfo);
        }
        if ((estimateinfo = this.estimate_.write(verbose)) != null) {
            specInfo.add(ESTIMATE, estimateinfo);
        }
        if ((reginfo = this.regression_.write(verbose)) != null) {
            specInfo.add(REGRESSION, reginfo);
        }
        return specInfo;
    }

    @Override
    public boolean read(InformationSet info) {
        boolean tok;
        boolean tok2;
        boolean tok3;
        boolean tok4;
        boolean tok5;
        boolean tok6;
        InformationSet tinfo = info.getSubSet(TRANSFORM);
        if (tinfo != null && !(tok6 = this.transform_.read(tinfo))) {
            return false;
        }
        InformationSet oinfo = info.getSubSet(OUTLIER);
        if (oinfo != null && !(tok5 = this.outlier_.read(oinfo))) {
            return false;
        }
        InformationSet ainfo = info.getSubSet(ARIMA);
        if (ainfo != null && !(tok4 = this.arima_.read(ainfo))) {
            return false;
        }
        InformationSet amiinfo = info.getSubSet(AUTOMDL);
        if (amiinfo != null && !(tok3 = this.automdl_.read(amiinfo))) {
            return false;
        }
        InformationSet einfo = info.getSubSet(ESTIMATE);
        if (einfo != null && !(tok2 = this.estimate_.read(einfo))) {
            return false;
        }
        InformationSet rinfo = info.getSubSet(REGRESSION);
        return rinfo == null || (tok = this.regression_.read(rinfo));
    }

    public static IPreprocessor defaultPreprocessor(Default option) {
        switch (option) {
            case TR0: {
                return TR0.build();
            }
            case TR1: {
                return TR1.build();
            }
            case TR2: {
                return TR2.build();
            }
            case TR3: {
                return TR3.build();
            }
            case TR4: {
                return TR4.build();
            }
            case TR5: {
                return TR5.build();
            }
            case TRfull: {
                return TRfull.build();
            }
        }
        return null;
    }

    private void initMainRoutine(TramoProcessor tramo) {
        if (this.automdl_ != null) {
            tramo.setPcr(this.automdl_.getPcr());
            tramo.setTsig_(this.automdl_.getTsig());
            tramo.setDfm(this.automdl_.isAcceptDefault());
        }
    }

    public IPreprocessor build() {
        return this.build(null);
    }

    public IPreprocessor build(ProcessingContext context) {
        TramoProcessor tramo = new TramoProcessor();
        tramo.estimationSpan = this.estimate_.getSpan();
        tramo.builder = new TramoModelBuilder(this, context);
        tramo.scaling = new UnitSeriesScaling();
        tramo.missing = new AverageInterpolator();
        tramo.seas = this.makeSeas();
        tramo.loglevelTest = this.makeLogLevel(this.transform_);
        TradingDaysSpec td = this.regression_.getCalendar().getTradingDays();
        boolean join = td.isAutomatic() || td.getRegressionTestType() == RegressionTestType.Joint_F;
        switch (td.getAutomaticMethod()) {
            case FTest: {
                tramo.regressionTest = new RegressionTestTD2(this.tdProvider(context), td.getProbabibilityForFTest());
                break;
            }
            case WaldTest: {
                tramo.regressionTest = new RegressionTestTD(this.tdProvider(context), td.getProbabibilityForFTest());
                break;
            }
            default: {
                tramo.regressionTest = new RegressionVariablesTest(join);
            }
        }
        tramo.regressionTest2 = new RegressionVariablesTest2(1.96, 1.96);
        tramo.regressionTest3 = new RegressionVariablesTest2(1.96, this.automdl_.getTsig());
        tramo.outliers = this.makeOutliers(this.outlier_, this.automdl_);
        this.makeAutoModelling(tramo, this.automdl_, td, context);
        tramo.finalizer = this.makeFinalEstimator(this.estimate_, this.automdl_.getTsig());
        this.initMainRoutine(tramo);
        return tramo;
    }

    public OutliersFactory getOutliersFactory() {
        OutliersFactory fac = new OutliersFactory(false);
        fac.register(AFAC);
        fac.register(LFAC);
        fac.register(SFAC);
        if (this.outlier_.getDeltaTC() == 0.7) {
            fac.register(TFAC);
        } else {
            TransitoryChangeFactory t = new TransitoryChangeFactory();
            t.setCoefficient(this.outlier_.getDeltaTC());
            fac.register(t);
        }
        return fac;
    }

    public static boolean isSystem(TramoSpecification spec) {
        return spec == TR0 || spec == TR1 || spec == TR2 || spec == TR3 || spec == TR4 || spec == TR5 || spec == TRfull;
    }

    public static TramoSpecification matchSystem(TramoSpecification spec) {
        if (spec == TR0 || spec == TR1 || spec == TR2 || spec == TR3 || spec == TR4 || spec == TR5 || spec == TRfull) {
            return spec;
        }
        if (spec.equals(TR0)) {
            return TR0;
        }
        if (spec.equals(TR1)) {
            return TR1;
        }
        if (spec.equals(TR2)) {
            return TR2;
        }
        if (spec.equals(TR3)) {
            return TR3;
        }
        if (spec.equals(TR4)) {
            return TR4;
        }
        if (spec.equals(TR5)) {
            return TR5;
        }
        if (spec.equals(TRfull)) {
            return TRfull;
        }
        return null;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TramoSpecification && this.equals((TramoSpecification)obj);
    }

    private boolean equals(TramoSpecification spec) {
        if (this.isUsingAutoModel() != spec.isUsingAutoModel()) {
            return false;
        }
        if (!this.isUsingAutoModel() && !Objects.equals(spec.arima_, this.arima_)) {
            return false;
        }
        if (this.isUsingAutoModel() && !Objects.equals(spec.automdl_, this.automdl_)) {
            return false;
        }
        return Objects.equals(spec.transform_, this.transform_) && Objects.equals(spec.regression_, this.regression_) && Objects.equals(spec.outlier_, this.outlier_) && Objects.equals(spec.estimate_, this.estimate_);
    }

    public int hashCode() {
        int hash = 3;
        hash = this.isUsingAutoModel() ? 11 * hash + this.automdl_.hashCode() : 11 * hash + this.arima_.hashCode();
        hash = 11 * hash + this.transform_.hashCode();
        hash = 11 * hash + this.estimate_.hashCode();
        hash = 11 * hash + this.outlier_.hashCode();
        hash = 11 * hash + this.regression_.hashCode();
        return hash;
    }

    public String toString() {
        if (this == TR0) {
            return "TR0";
        }
        if (this == TR1) {
            return "TR1";
        }
        if (this == TR2) {
            return "TR2";
        }
        if (this == TR3) {
            return "TR3";
        }
        if (this == TR4) {
            return "TR4";
        }
        if (this == TR5) {
            return "TR5";
        }
        if (this.equals(TR0)) {
            return "TR0";
        }
        if (this.equals(TR1)) {
            return "TR1";
        }
        if (this.equals(TR2)) {
            return "TR2";
        }
        if (this.equals(TR3)) {
            return "TR3";
        }
        if (this.equals(TR4)) {
            return "TR4";
        }
        if (this.equals(TR5)) {
            return "TR5";
        }
        if (this.equals(TRfull)) {
            return "TRfull";
        }
        return SMETHOD;
    }

    public String toLongString() {
        String s = this.toString();
        if (SMETHOD.equals(s)) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("TR[").append(s).append(']');
        return builder.toString();
    }

    public static TramoSpecification fromString(String name) {
        switch (name) {
            case "TR0": {
                return TR0;
            }
            case "TR1": {
                return TR1;
            }
            case "TR2": {
                return TR2;
            }
            case "TR3": {
                return TR3;
            }
            case "TR4": {
                return TR4;
            }
            case "TR5": {
                return TR5;
            }
            case "TRfull": {
                return TRfull;
            }
        }
        return new TramoSpecification();
    }

    static {
        LFAC = new LevelShiftFactory();
        TFAC = new TransitoryChangeFactory();
        AFAC = new AdditiveOutlierFactory();
        SFAC = new SeasonalOutlierFactory();
        TR0 = new TramoSpecification();
        TR1 = new TramoSpecification();
        TR2 = new TramoSpecification();
        TR3 = new TramoSpecification();
        TR4 = new TramoSpecification();
        TR5 = new TramoSpecification();
        TRfull = new TramoSpecification();
        TransformSpec tr = new TransformSpec();
        tr.setFunction(DefaultTransformationType.Auto);
        EasterSpec e = new EasterSpec();
        e.setOption(EasterSpec.Type.Standard);
        e.setTest(true);
        TradingDaysSpec wd = new TradingDaysSpec();
        wd.setTradingDaysType(TradingDaysType.WorkingDays);
        wd.setLeapYear(true);
        wd.setRegressionTestType(RegressionTestType.Separate_T);
        TradingDaysSpec td = new TradingDaysSpec();
        td.setTradingDaysType(TradingDaysType.TradingDays);
        td.setLeapYear(true);
        td.setRegressionTestType(RegressionTestType.Separate_T);
        TradingDaysSpec dc = td.clone();
        dc.setAutomatic(true);
        EasterSpec ec = e.clone();
        ec.setOption(EasterSpec.Type.IncludeEaster);
        RegressionSpec rwd = new RegressionSpec();
        CalendarSpec cwd = new CalendarSpec();
        cwd.setEaster(e);
        cwd.setTradingDays(wd);
        rwd.setCalendar(cwd);
        RegressionSpec rtd = new RegressionSpec();
        CalendarSpec ctd = new CalendarSpec();
        ctd.setEaster(e);
        ctd.setTradingDays(td);
        rtd.setCalendar(ctd);
        RegressionSpec rc = new RegressionSpec();
        CalendarSpec cc = new CalendarSpec();
        cc.setEaster(ec);
        cc.setTradingDays(dc);
        rc.setCalendar(cc);
        OutlierSpec o = new OutlierSpec();
        o.add(OutlierType.AO);
        o.add(OutlierType.TC);
        o.add(OutlierType.LS);
        TR1.setTransform(tr);
        TR1.setOutliers(o);
        TR2.setTransform(tr);
        TR2.setOutliers(o);
        TR2.setRegression(rwd);
        TR3.setTransform(tr);
        TR3.setOutliers(o);
        TR3.setUsingAutoModel(true);
        TR4.setTransform(tr);
        TR4.setOutliers(o);
        TR4.setRegression(rwd);
        TR4.setUsingAutoModel(true);
        TR5.setTransform(tr);
        TR5.setOutliers(o);
        TR5.setRegression(rtd);
        TR5.setUsingAutoModel(true);
        TRfull.setTransform(tr);
        TRfull.setOutliers(o);
        TRfull.setRegression(rc);
        TRfull.setUsingAutoModel(true);
    }

    public static enum Default {
        TR0,
        TR1,
        TR2,
        TR3,
        TR4,
        TR5,
        TRfull;


        public static Default valueOfIgnoreCase(String name) {
            if (name.equalsIgnoreCase("TRfull")) {
                return TRfull;
            }
            String N = name.toUpperCase();
            return Default.valueOf(N);
        }
    }
}

