/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v30;

import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class SeriesCountParser
implements Parser<Integer> {
    private static final String sourceClass = SeriesCountParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String ANNOTATION = "Annotation";
    static final String ID = "id";
    static final String ANNOTATION_TITLE = "AnnotationTitle";
    static final String SERIES_COUNT = "series_count";

    @Override
    public Integer parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        boolean bl = false;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (!xMLEvent.isStartElement()) continue;
            StartElement startElement = xMLEvent.asStartElement();
            if (ANNOTATION.equals(startElement.getName().getLocalPart())) {
                Iterator<Attribute> iterator = startElement.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (!ID.equals(attribute.getName().getLocalPart()) || !attribute.getValue().equals(SERIES_COUNT)) continue;
                    bl = true;
                }
                continue;
            }
            if (!ANNOTATION_TITLE.equals(startElement.getName().getLocalPart()) || !bl) continue;
            return Integer.parseInt(xMLEventReader.getElementText());
        }
        return null;
    }
}

