/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SdmxProxySelector
extends ProxySelector {
    private final String NO_PROXY = "NOPROXY";
    private Proxy defaultProxy = Proxy.NO_PROXY;
    private Map<String, Proxy> proxyTable = null;

    public SdmxProxySelector(String string, int n) {
        if (string != null && !string.isEmpty() && !string.equalsIgnoreCase("NOPROXY")) {
            this.defaultProxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n));
        }
        this.proxyTable = new HashMap<String, Proxy>();
    }

    public void addToDefaultProxy(String string) {
        Proxy proxy = this.proxyTable.get(string);
        if (proxy == null) {
            this.proxyTable.put(string, this.defaultProxy);
        }
    }

    public void addProxy(String string, String string2, String ... stringArray) {
        Proxy proxy = null;
        if (string != null && string2 != null && !string.isEmpty() && !string2.isEmpty()) {
            proxy = !string.equalsIgnoreCase("NOPROXY") ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string.trim(), Integer.parseInt(string2.trim()))) : Proxy.NO_PROXY;
            for (String string3 : stringArray) {
                if (string3 == null || string3.isEmpty()) continue;
                this.proxyTable.put(string3, proxy);
            }
        } else {
            throw new IllegalArgumentException("Proxy settings must be valid. host: '" + string + "', port: '" + string2 + "'");
        }
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
    }

    @Override
    public List<Proxy> select(URI uRI) {
        ArrayList<Proxy> arrayList = new ArrayList<Proxy>();
        String string = uRI.getHost();
        if (string != null) {
            Proxy proxy = this.proxyTable.get(string);
            arrayList.add(proxy != null ? proxy : Proxy.NO_PROXY);
        } else {
            arrayList.add(Proxy.NO_PROXY);
        }
        return arrayList;
    }

    public Proxy addUrlHostToProxy(URL uRL, Proxy proxy) {
        return this.proxyTable.put(uRL.getHost(), proxy);
    }
}

