/*
 * Decompiled with CFR 0.152.
 */
package weka.estimators;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.estimators.Estimator;

public class EstimatorUtils {
    public static double findMinDistance(Instances instances, int n) {
        double d = Double.MAX_VALUE;
        int n2 = instances.numInstances();
        if (n2 < 2) {
            return d;
        }
        int n3 = -1;
        Instance instance = null;
        do {
            if (++n3 >= n2) continue;
            instance = instances.instance(n3);
        } while (n3 < n2 && instance.isMissing(n));
        double d2 = instances.instance(n3).value(n);
        for (int i = n3; i < n2 && !instances.instance(i).isMissing(n); ++i) {
            double d3;
            double d4 = d2;
            d2 = instances.instance(i).value(n);
            if (d2 == d4 || !((d3 = d2 - d4) < d) || !(d3 > 0.0)) continue;
            d = d3;
        }
        return d;
    }

    public static int getMinMax(Instances instances, int n, double[] dArray) throws Exception {
        double d = Double.NaN;
        double d2 = Double.NaN;
        Instance instance = null;
        int n2 = 0;
        if (dArray == null || dArray.length < 2) {
            throw new Exception("Error in Program, privat method getMinMax");
        }
        Enumeration enumeration = instances.enumerateInstances();
        if (enumeration.hasMoreElements()) {
            while ((instance = (Instance)enumeration.nextElement()).isMissing(n) && enumeration.hasMoreElements()) {
            }
            if (!instance.isMissing(n)) {
                ++n2;
                d = instance.value(n);
                d2 = instance.value(n);
            }
            while (enumeration.hasMoreElements()) {
                instance = (Instance)enumeration.nextElement();
                if (instance.isMissing(n)) continue;
                ++n2;
                if (instance.value(n) < d) {
                    d = instance.value(n);
                    continue;
                }
                if (!(instance.value(n) > d2)) continue;
                d2 = instance.value(n);
            }
        }
        dArray[0] = d;
        dArray[1] = d2;
        return n2;
    }

    public static Vector getInstancesFromClass(Instances instances, int n, int n2, double d, Instances instances2) {
        Vector<Serializable> vector = new Vector<Serializable>(0);
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (instances.instance(i).isMissing(n)) continue;
            ++n3;
            if (instances.instance(i).value(n2) != d) continue;
            instances2.add(instances.instance(i));
            ++n4;
        }
        Double d2 = new Double((double)n4 / (double)n3);
        vector.add(instances2);
        vector.add(d2);
        return vector;
    }

    public static Instances getInstancesFromClass(Instances instances, int n, double d) {
        Instances instances2 = new Instances(instances, 0);
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (instances.instance(i).value(n) != d) continue;
            instances2.add(instances.instance(i));
        }
        return instances2;
    }

    public static void writeCurve(String string, Estimator estimator, double d, double d2, int n) throws Exception {
        PrintWriter printWriter = null;
        StringBuffer stringBuffer = new StringBuffer("");
        if (string.length() == 0) {
            return;
        }
        String string2 = string + ".curv";
        printWriter = new PrintWriter(new FileOutputStream(string2));
        double d3 = (d2 - d) / ((double)n - 1.0);
        try {
            stringBuffer.append("" + d + " " + estimator.getProbability(d) + " \n");
            for (double d4 = d + d3; d4 < d2; d4 += d3) {
                stringBuffer.append("" + d4 + " " + estimator.getProbability(d4) + " \n");
            }
            stringBuffer.append("" + d2 + " " + estimator.getProbability(d2) + " \n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
        printWriter.println(stringBuffer.toString());
        if (printWriter != null) {
            printWriter.close();
        }
    }

    public static void writeCurve(String string, Estimator estimator, Estimator estimator2, double d, double d2, double d3, int n) throws Exception {
        PrintWriter printWriter = null;
        StringBuffer stringBuffer = new StringBuffer("");
        if (string.length() == 0) {
            return;
        }
        String string2 = string + ".curv";
        printWriter = new PrintWriter(new FileOutputStream(string2));
        double d4 = (d3 - d2) / ((double)n - 1.0);
        try {
            stringBuffer.append("" + d2 + " " + estimator.getProbability(d2) * estimator2.getProbability(d) + " \n");
            for (double d5 = d2 + d4; d5 < d3; d5 += d4) {
                stringBuffer.append("" + d5 + " " + estimator.getProbability(d5) * estimator2.getProbability(d) + " \n");
            }
            stringBuffer.append("" + d3 + " " + estimator.getProbability(d3) * estimator2.getProbability(d) + " \n");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception.getMessage());
        }
        printWriter.println(stringBuffer.toString());
        if (printWriter != null) {
            printWriter.close();
        }
    }

    public static Instances getInstancesFromValue(Instances instances, int n, double d) {
        Instances instances2 = new Instances(instances, 0);
        for (int i = 0; i < instances.numInstances(); ++i) {
            if (instances.instance(i).value(n) != d) continue;
            instances2.add(instances.instance(i));
        }
        return instances2;
    }

    public static String cutpointsToString(double[] dArray, boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        if (dArray == null) {
            stringBuffer.append("\n# no cutpoints found - attribute \n");
        } else {
            stringBuffer.append("\n#* " + dArray.length + " cutpoint(s) -\n");
            for (int i = 0; i < dArray.length; ++i) {
                stringBuffer.append("# " + dArray[i] + " ");
                stringBuffer.append("" + blArray[i] + "\n");
            }
            stringBuffer.append("# end\n");
        }
        return stringBuffer.toString();
    }
}

