/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.syntaxtree;

import java.util.ArrayList;
import javolution.xml.XmlElement;
import javolution.xml.XmlFormat;
import net.sf.jclec.syntaxtree.SyntaxTreeNode;
import org.apache.commons.lang.builder.EqualsBuilder;

public class NonTerminalNode
extends SyntaxTreeNode {
    protected static final XmlFormat<NonTerminalNode> NT_NODE_XML = new XmlFormat<NonTerminalNode>(NonTerminalNode.class){

        @Override
        public void format(NonTerminalNode nonTerminalSymbol, XmlElement xml) {
            NODE_XML.format(nonTerminalSymbol, xml);
            xml.add(nonTerminalSymbol.production, "production", PROD_XML);
        }

        @Override
        public NonTerminalNode parse(XmlElement xml) {
            NonTerminalNode nonTerminalSymbol = (NonTerminalNode)NODE_XML.parse(xml);
            nonTerminalSymbol.production = (String[])xml.get("production", PROD_XML);
            return nonTerminalSymbol;
        }

        @Override
        public String defaultName() {
            return "non-terminal-symbol";
        }
    };
    protected static final XmlFormat<String[]> PROD_XML = new XmlFormat<String[]>(String[].class){

        @Override
        public void format(String[] source, XmlElement xml) {
            String[] stringArray = source;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String psymbol = stringArray[n];
                xml.add(psymbol, "element", STRING_XML);
                ++n;
            }
        }

        @Override
        public String[] parse(XmlElement xml) {
            ArrayList<String> list = new ArrayList<String>();
            while (xml.hasNext()) {
                list.add((String)xml.get("element", STRING_XML));
            }
            return list.toArray(new String[0]);
        }
    };
    private static final long serialVersionUID = 6125883112520878113L;
    public String[] production;

    public NonTerminalNode() {
    }

    public NonTerminalNode(String symbolName, String[] production) {
        super(symbolName);
        this.setProduction(production);
    }

    public String[] getProduction() {
        return this.production;
    }

    public void setProduction(String[] production) {
        this.production = production;
    }

    public final int arity() {
        return this.production.length;
    }

    public SyntaxTreeNode instance() {
        return this;
    }

    public SyntaxTreeNode copy() {
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof NonTerminalNode) {
            NonTerminalNode cother = (NonTerminalNode)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.symbol, cother.symbol);
            eb.append(this.production, cother.production);
            return eb.isEquals();
        }
        return false;
    }
}

