/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Neural_Networks.NNEP_Common.initiators;

import keel.Algorithms.Neural_Networks.NNEP_Common.algorithm.NeuralNetAlgorithm;
import keel.Algorithms.Neural_Networks.NNEP_Common.initiators.PureLayerInitiator;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.ILayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.INeuron;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.Link;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedLayer;
import keel.Algorithms.Neural_Networks.NNEP_Common.neuralnet.LinkedNeuron;

public class RandomInitiator
extends PureLayerInitiator {
    protected double significativeWeight = 1.0E-7;

    public double getSignificativeWeight() {
        return this.significativeWeight;
    }

    public void setSignificativeWeight(double significativeWeight) {
        this.significativeWeight = significativeWeight;
    }

    @Override
    public void prepareInitiation() {
        if (this.context instanceof NeuralNetAlgorithm) {
            this.significativeWeight = ((NeuralNetAlgorithm)this.context).getFitDif();
        }
    }

    @Override
    public Link[] createLinks(LinkedLayer linkedLayer, ILayer<? extends INeuron> previousLayer, LinkedNeuron newNeuron) {
        Link[] links;
        if (linkedLayer.isBiased()) {
            links = new Link[previousLayer.getMaxnofneurons() + 1];
            links[previousLayer.getMaxnofneurons()] = new Link();
            links[previousLayer.getMaxnofneurons()].setBroken(false);
            newNeuron.setBiased(true);
        } else {
            links = new Link[previousLayer.getMaxnofneurons()];
        }
        for (int j = 0; j < previousLayer.getMaxnofneurons(); ++j) {
            links[j] = new Link();
            links[j].setBroken(true);
            links[j].setWeight(0.0);
        }
        int noflinks = this.randGen.choose(1, previousLayer.getNofneurons() + 1);
        for (int j = 0; j < noflinks; ++j) {
            int selectedNeuron = this.randGen.choose(0, previousLayer.getNofneurons());
            links[selectedNeuron].setOrigin(previousLayer.getNeuron(selectedNeuron));
            links[selectedNeuron].setTarget(newNeuron);
            links[selectedNeuron].setBroken(false);
        }
        return links;
    }

    @Override
    public void initiateWeights(LinkedLayer linkedLayer) {
        for (int i = 0; i < linkedLayer.getNofneurons(); ++i) {
            for (int j = 0; j < linkedLayer.getNeuron(i).getLinks().length; ++j) {
                LinkedNeuron neuron = linkedLayer.getNeuron(i);
                if (neuron.getLink(j).isBroken()) continue;
                neuron.getLink(j).setWeight(neuron.randomWeight(this.randGen, this.significativeWeight));
            }
        }
    }
}

