/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Decision_Trees.PUBLIC;

import java.util.ArrayList;
import java.util.StringTokenizer;
import keel.Algorithms.Decision_Trees.PUBLIC.myAttribute;
import keel.Algorithms.Preprocess.Basic.CheckException;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import keel.Dataset.Instance;
import keel.Dataset.InstanceSet;

public class myDataset {
    private String name;
    private int numAtr;
    private int numIns;
    private ArrayList<myAttribute> attributes;
    private myAttribute outputAttribute;
    private int numClasses;
    private int[] nInstances;
    private double[][] data;
    private int[] output;
    private int kind;

    public myDataset(String nameFile, int newkind) throws CheckException {
        int i;
        ArrayList<String> nomValues;
        double max;
        double min;
        String nameat;
        Attribute at;
        this.kind = newkind;
        InstanceSet IS = new InstanceSet();
        try {
            if (newkind == 3) {
                IS.readSet(nameFile, false);
            } else {
                IS.readSet(nameFile, true);
            }
        }
        catch (Exception e) {
            System.err.println(e);
            System.exit(1);
        }
        if (Attributes.getOutputNumAttributes() < 1) {
            throw new CheckException("This dataset doesn't have any outputs, so it doesn't belong to a classification problem");
        }
        if (Attributes.getOutputNumAttributes() > 1) {
            throw new CheckException("This dataset has more than one output");
        }
        if (Attributes.getOutputAttribute(0).getType() == 2) {
            throw new CheckException("This dataset has an output attribute with float values, so it doesn't belong to a classification problem");
        }
        this.name = new String(Attributes.getRelationName());
        this.numAtr = Attributes.getInputNumAttributes();
        this.numIns = IS.getNumInstances();
        this.attributes = new ArrayList(this.numAtr);
        for (int j = 0; j < this.numAtr; ++j) {
            at = Attributes.getInputAttribute(j);
            nameat = new String(at.getName());
            if (at.getType() == 1 || at.getType() == 2) {
                min = at.getMinAttribute();
                max = at.getMaxAttribute();
                this.attributes.add(new myAttribute(nameat, at.getType(), min, max, true));
                continue;
            }
            int numNominal = at.getNumNominalValues();
            nomValues = new ArrayList<String>(numNominal);
            for (int k = 0; k < numNominal; ++k) {
                nomValues.add(at.getNominalValue(k));
            }
            myAttribute aux = new myAttribute(nameat, 3, true);
            aux.setValues(nomValues);
            this.attributes.add(aux);
        }
        StringTokenizer tokens = new StringTokenizer(IS.getHeader(), " \n\r");
        tokens.nextToken();
        tokens.nextToken();
        this.data = new double[IS.getNumInstances()][this.numAtr];
        this.output = new int[IS.getNumInstances()];
        for (int i2 = 0; i2 < IS.getNumInstances(); ++i2) {
            Instance temp = IS.getInstance(i2);
            this.data[i2] = temp.getAllInputValues();
            this.output[i2] = (int)temp.getOutputRealValues(0);
            boolean[] nulls = temp.getInputMissingValues();
            for (int j = 0; j < nulls.length; ++j) {
                if (!nulls[j]) continue;
                this.data[i2][j] = 0.0;
            }
        }
        at = Attributes.getOutputAttribute(0);
        nameat = new String(at.getName());
        if (at.getType() == 1 || at.getType() == 2) {
            min = at.getMinAttribute();
            max = at.getMaxAttribute();
            this.outputAttribute = new myAttribute(nameat, at.getType(), min, max, false);
        } else {
            int numNominal = at.getNumNominalValues();
            nomValues = new ArrayList(numNominal);
            for (int k = 0; k < numNominal; ++k) {
                nomValues.add(at.getNominalValue(k));
            }
            myAttribute aux = new myAttribute(nameat, 3, false);
            aux.setValues(nomValues);
            this.outputAttribute = aux;
        }
        this.numClasses = Attributes.getOutputAttribute(0).getNumNominalValues();
        this.nInstances = new int[this.numClasses];
        for (i = 0; i < this.numClasses; ++i) {
            this.nInstances[i] = 0;
        }
        for (i = 0; i < this.output.length; ++i) {
            int n = this.output[i];
            this.nInstances[n] = this.nInstances[n] + 1;
        }
        IS.setAttributesAsNonStatic();
        if (this.kind == 3) {
            Attributes.clearAll();
        }
    }

    public myDataset(myDataset dataset) {
        int i;
        this.kind = dataset.kind;
        this.name = dataset.name;
        this.numAtr = dataset.numAtr;
        this.numIns = dataset.numIns;
        this.numClasses = dataset.numClasses;
        this.outputAttribute = new myAttribute(dataset.outputAttribute);
        this.attributes = new ArrayList();
        for (i = 0; i < dataset.attributes.size(); ++i) {
            myAttribute aux = new myAttribute(dataset.attributes.get(i));
            this.attributes.add(aux);
        }
        this.nInstances = new int[this.numClasses];
        System.arraycopy(dataset.nInstances, 0, this.nInstances, 0, dataset.nInstances.length);
        this.output = new int[this.numIns];
        System.arraycopy(dataset.output, 0, this.output, 0, dataset.output.length);
        this.data = new double[this.numIns][this.numAtr];
        for (i = 0; i < this.numIns; ++i) {
            for (int j = 0; j < this.numAtr; ++j) {
                this.data[i][j] = dataset.data[i][j];
            }
        }
    }

    public boolean equals(Object obj) {
        int i;
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        myDataset test = (myDataset)obj;
        for (i = 0; i < this.numClasses; ++i) {
            if (this.nInstances[i] == test.nInstances[i]) continue;
            return false;
        }
        for (i = 0; i < this.numIns; ++i) {
            if (this.output[i] == test.output[i]) continue;
            return false;
        }
        for (i = 0; i < this.numIns; ++i) {
            for (int j = 0; j < this.numAtr; ++j) {
                if (this.data[i][j] == test.data[i][j]) continue;
                return false;
            }
        }
        return this.numAtr == test.numAtr && this.numIns == test.numIns && this.numClasses == test.numClasses && this.kind == test.kind && (this.name == test.name || this.name != null && this.name.equals(test.name)) && (this.attributes == test.attributes || this.attributes != null && this.attributes.equals(test.attributes)) && (this.outputAttribute == test.outputAttribute || this.outputAttribute != null && this.outputAttribute.equals(test.outputAttribute));
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.name ? 0 : this.name.hashCode());
        hash = 31 * hash + this.numAtr;
        hash = 31 * hash + this.numIns;
        hash = 31 * hash + (null == this.outputAttribute ? 0 : this.outputAttribute.hashCode());
        hash = 31 * hash + this.numClasses;
        hash = 31 * hash + this.kind;
        return hash;
    }

    public String toString() {
        int i;
        String aux = new String(this.name);
        aux = aux + "\n";
        for (i = 0; i < this.attributes.size(); ++i) {
            aux = aux + this.attributes.get(i) + "\n";
        }
        aux = aux + this.outputAttribute + "\n";
        for (i = 0; i < this.numIns; ++i) {
            for (int j = 0; j < this.numAtr; ++j) {
                aux = aux + this.data[i][j] + " ";
            }
            aux = aux + this.output[i] + "\n";
        }
        switch (this.kind) {
            case 1: {
                aux = aux + "Training dataset\n";
                break;
            }
            case 2: {
                aux = aux + "Reference dataset\n";
                break;
            }
            case 3: {
                aux = aux + "Test dataset\n";
                break;
            }
            default: {
                System.err.println("Error: This dataset isn't correctly specified\n");
                System.exit(1);
            }
        }
        return aux;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumAtr() {
        return this.numAtr;
    }

    public void setNumAtr(int numAtr) {
        this.numAtr = numAtr;
    }

    public int getNumIns() {
        return this.numIns;
    }

    public void setNumIns(int numIns) {
        this.numIns = numIns;
    }

    public ArrayList<myAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ArrayList<myAttribute> attributes) {
        this.attributes = attributes;
    }

    public myAttribute getAttributeI(int i) {
        myAttribute aux = this.attributes.get(i);
        return aux;
    }

    public void setAttributeI(int i, myAttribute att) {
        this.attributes.set(i, att);
    }

    public myAttribute getOutputAttribute() {
        return this.outputAttribute;
    }

    public void setOutputAttribute(myAttribute outputAttribute) {
        this.outputAttribute = outputAttribute;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public void setNumClasses(int numClasses) {
        this.numClasses = numClasses;
    }

    public int getNInstancesI(int i) {
        return this.nInstances[i];
    }

    public void setNInstancesI(int i, int instances) {
        this.nInstances[i] = instances;
    }

    public double getDataI(int i, int j) {
        return this.data[i][j];
    }

    public double[] getDataItem(int i) {
        return this.data[i];
    }

    public void setDataI(int i, int j, double data) {
        this.data[i][j] = data;
    }

    public int getOutputI(int i) {
        return this.output[i];
    }

    public void setOutputI(int i, int output) {
        this.output[i] = output;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }
}

