## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 6,
  warning = FALSE,
  message = FALSE
)

## ----setup--------------------------------------------------------------------
library(bidask)

## -----------------------------------------------------------------------------
library(dplyr)
library(crypto2)
df <- crypto_list(only_active=TRUE) %>%
  filter(symbol %in% c("BTC", "ETH")) %>%
  crypto_history(start_date = "20200101", end_date = "20221231")

## -----------------------------------------------------------------------------
head(df)

## -----------------------------------------------------------------------------
df %>%
  mutate(yyyy = format(timestamp, "%Y")) %>%
  group_by(symbol, yyyy) %>%
  arrange(timestamp) %>%
  summarise(EDGE = edge(open, high, low, close))

## -----------------------------------------------------------------------------
library(quantmod)
x <- getSymbols("MSFT", auto.assign = FALSE, start = "2019-01-01", end = "2022-12-31")
head(x)

## -----------------------------------------------------------------------------
class(x)

## -----------------------------------------------------------------------------
spread(x)

## -----------------------------------------------------------------------------
edge(open = x[,1], high = x[,2], low = x[,3], close = x[,4])

## -----------------------------------------------------------------------------
sp <- spread(x, width = endpoints(x, on = "months"))
plot(sp)

## -----------------------------------------------------------------------------
sp <- spread(x, width = 21)
plot(sp)

## -----------------------------------------------------------------------------
setDefaults(getSymbols.av, api.key = "<API-KEY>")

## ---- include=FALSE-----------------------------------------------------------
x <- read.csv(system.file("extdata", "msft.csv", package = "bidask"))
x <- xts(x[,-1], order.by = as.POSIXct(x[,1]))

## -----------------------------------------------------------------------------
head(x)

## -----------------------------------------------------------------------------
sp <- spread(x, width = endpoints(x, on = "day"))
plot(sp)

