/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.geost.internalConstraints;

import choco.cp.solver.constraints.global.geost.geometricPrim.Obj;
import choco.cp.solver.constraints.global.geost.geometricPrim.Point;
import choco.cp.solver.constraints.global.geost.geometricPrim.Region;
import choco.cp.solver.constraints.global.geost.internalConstraints.InternalConstraint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class ForbiddenRegion
extends InternalConstraint {
    public ForbiddenRegion() {
        super(4);
    }

    public List isFeasible(boolean min, int dim, int k, Obj o, Point p, Point jump) {
        int j_prime;
        int j;
        Region f = new Region(k, o.getObjectId());
        ArrayList<Serializable> result = new ArrayList<Serializable>();
        if (!this.insideForbidden(p)) {
            result.add(0, Boolean.valueOf(true));
            result.add(1, p);
            return result;
        }
        for (int i = 0; i < k; ++i) {
            int v = p.getCoord(i);
            f.setMinimumBoundary(i, v);
            f.setMaximumBoundary(i, v);
        }
        if (min) {
            for (j = k - 1; j >= 0; --j) {
                j_prime = (j + dim) % k;
                f.setMaximumBoundary(j_prime, Math.min(jump.getCoord(j_prime) - 1, this.maximizeSizeOfFBox(true, j_prime, k, f)));
            }
        } else {
            for (j = k - 1; j >= 0; --j) {
                j_prime = (j + dim) % k;
                f.setMinimumBoundary(j_prime, Math.max(jump.getCoord(j_prime) + 1, this.maximizeSizeOfFBox(false, j_prime, k, f)));
            }
        }
        result.add(0, Boolean.valueOf(false));
        result.add(1, f);
        return result;
    }

    public abstract boolean insideForbidden(Point var1);

    public abstract int maximizeSizeOfFBox(boolean var1, int var2, int var3, Region var4);
}

