/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.ISolutionPool;
import java.util.logging.Level;

abstract class AbstractSolutionPool
implements ISolutionPool {
    public final AbstractGlobalSearchStrategy strategy;
    protected int capacity;

    protected AbstractSolutionPool(AbstractGlobalSearchStrategy strategy, int capacity) {
        this.strategy = strategy;
        this.capacity = capacity;
    }

    @Override
    public final AbstractGlobalSearchStrategy getSearchStrategy() {
        return this.strategy;
    }

    @Override
    public final int getCapacity() {
        return this.capacity;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public void resizeCapacity(int capacity) {
        ChocoLogging.getEngineLogger().log(Level.WARNING, "- Solution pool: not resizable (capacity:{0}", this.getCapacity());
    }

    @Override
    public int size() {
        return Math.min(this.capacity, this.strategy.getSolutionCount());
    }
}

