\name{NEWS}
\title{News for Package 'papeR'}

\section{Changes in papeR version 1.0-5 (2021-03-19)}{
  \subsection{Bug-fixes}{
     \itemize{
      \item Fixed error introduced by changes in \pkg{survival}: 
      \code{data(ovarian, package = "survival")} was replaced with \code{data(cancer, package = "survival")}.
    }
  }
}
\section{Changes in papeR version 1.0-4 (2019-01-03)}{
  \subsection{Bug-fixes}{
     \itemize{
      \item Fixed vignette (load \pkg{knitr} correctly).
      \item Added \pkg{rmarkdown} to \code{Suggests:}.
      \item Fixed handling of trailing zeros in \code{prettify}
        (fixes \href{https://github.com/hofnerb/papeR/issues/40}{#40}).
    }
  }
}
\section{Changes in papeR version 1.0-3 (2018-09-11)}{
  \subsection{Bug-fixes}{
     \itemize{
      \item Stop checking for specific error message
        (fixes \href{https://github.com/hofnerb/papeR/issues/39}{#39}).
      \item Make Rmarkdown happy
        (fixes \href{https://github.com/hofnerb/papeR/issues/35}{#35}).
    }
  }
}
\section{Changes in papeR version 1.0-2 (2017-02-16)}{
  \subsection{Miscellaneous}{
    \itemize{
      \item Updated maintainer's email address.
    }
  }
  \subsection{Bug-fixes}{
     \itemize{
      \item Fix scoping in \code{summarize} function
        (fixes \href{https://github.com/hofnerb/papeR/issues/33}{#33}).
      \item Removed \code{confint.lme} to make CRAN happy
        (fixes \href{https://github.com/hofnerb/papeR/issues/34}{#34}).
      \item Fixed bug in \code{label} assignment with numerical \code{which}.
    }
  }
}
\section{Changes in papeR version 1.0-1 (2016-04-08)}{
  \subsection{User-visible changes}{
    \itemize{
      \item \code{print.xtable.summary} now also centers tables per
      default if \code{floating = FALSE}.
      \item Added support for Cox frailty models in \code{prettify}
      \item Fixed problem with \code{include.rownames} by ignoring the option 
        (fixes \href{https://github.com/hofnerb/papeR/issues/30}{#30}).
      \item Use \code{$-$} per default for negative numeric values 
        (fixes \href{https://github.com/hofnerb/papeR/issues/32}{#32}).
    }
  }
  \subsection{Bug-fixes}{
     \itemize{
      \item Make tests compatible with new testthat version (> 0.11.0).
      \item Fixed messages of old summary functions.
    }
  }
}
\section{Changes in papeR version 1.0-0 (2015-12-01)}{
  \subsection{User-visible changes}{
    \itemize{
      \item \code{summarize} produces summary tables that can be further
      processed with \code{xtable} or \code{kable} to produce LaTeX or
      Markdown tables, respectively (closes
      \href{https://github.com/hofnerb/papeR/issues/2}{#2} and
      \href{https://github.com/hofnerb/papeR/issues/3}{#3}).
      \item \code{latex.table.cont} and \code{latex.table.fac} are now
      deprecated. Use \code{summarize} instead.
      \item \code{labels()} are now stored as attribute of the variable
      instead of as attribute of the data set (closes
      \href{https://github.com/hofnerb/papeR/issues/1}{#1}).
    }
  }
  \subsection{Miscellaneous}{
    \itemize{
      \item Completely refactored code base.
      \item Added two vignettes (closes
      \href{https://github.com/hofnerb/papeR/issues/7}{#7}).
      \item The package is now extensively tested using \code{testthat}
      (closes \href{https://github.com/hofnerb/papeR/issues/12}{#12}).
    }
  }
  \subsection{Bug-fixes}{
    \itemize{
      \item  Adhere to CRAN policies regarding import of base packages
      (closes \href{https://github.com/hofnerb/papeR/issues/8}{#8}).
    }
  }
}


\section{Changes in papeR version 0.6-1 (2015-06-09)}{
  \subsection{Miscellaneous}{
    \itemize{
      \item Fixed \file{man/toLatex.Rd}:
      Changed \code{\\donttest} to \code{\\dontrun}
      \item \file{DESCRIPTION} now uses single quotes for package and
      software names.
    }
  }
  \subsection{Bug-fixes}{
    \itemize{
      \item Fixed \file{inst/CITATION}: Now it is possible to extract
      citation without the need to install the package.
    }
  }
}

\section{Changes in papeR version 0.6-0 (2015-06-05)}{
    \subsection{User-visible changes}{
      \itemize{
	\item \code{latex.table.fac}:
	\itemize{
	  \item Allow more than two groups.
	  \item Added p-values.
	  \item Added option to display fractions or percentages
	  (\code{percent = TRUE}). The latter is the default.
	  \item Changed default to \code{digits = 3}.
	  \item Generally improved display of grouped statistics.
	}
     }
  }
  \subsection{Miscellaneous}{
    \itemize{
      \item Added \file{inst/CITATION} file.
      \item Added \file{inst/COPYRIGHTS} file.
      \item Added \file{inst/CONTRIBUTIONS} file.
      \item Updated \file{DESCRIPTION} to reflect CRAN policies.
      \item Changed URL in \file{DESCRIPTION} to
      \url{https://github.com/hofnerb/papeR}.
    }
  }
  \subsection{Bug-fixes}{
    \itemize{
      \item Do not replace registered S3 methods from base/recommended
      packages (#5).
      \item Fixed handling of \code{levels()}.
      \item Fixed bug with factor levels.
      \item \code{latex.table.fac} and  \code{latex.table.cont}:
      fixed handling of missing values in \code{group}.
    }
  }
}
\section{Changes in papeR version 0.5-0 (2014-11-13)}{
    \subsection{User-visible changes}{
      \itemize{
      \item Exported \code{plot.labeled.data.frame} (and some other
      functions for labeled \code{data.frame}s)
      \item Greatly improved \code{plot} function for labeled
      \code{data.frame}s
    }
  }
  \subsection{Miscellaneous}{
    \itemize{
      \item Changed plain text \file{NEWS} to \file{inst/NEWS.Rd}
      \item The package now \emph{enhances} \pkg{nlme}, \pkg{lme4} and
      \pkg{survival}. Thus, we no longer import \pkg{lme4} and
      \pkg{survival}.
    }
  }
  \subsection{Bug-fixes}{
    \itemize{
      \item Fixed bug in \code{toLatex.sessionInfo(, citations = FALSE)}
      (spotted by Brian S. Diggs <brian.s.diggs __at__ gmail.com>)
      \item Changed \code{plot(data, ...)} to \code{plot(x, ...)} to
      make the generic function happy.
    }
  }
}
\section{Changes in papeR version 0.4-0 (2013-09-13)}{
  \itemize{
    \item included (experimental) version of
    \code{prettify.summary.merMod} to make \pkg{lme4} (>= 1.0.0) happy
    \item included better handling of environments in \code{prettify}
    functions and checks if the data has changed
    \item included possibility to specify confidence intervals directly
    via \code{confint}, e.g.

    \code{prettify(summary(mod), confint = confint(mod))}

    \item better handling of \code{NAMESPACES} and \code{Imports}
    \item added (first) software tests
  }
}
\section{Changes in papeR version 0.3-0 (2013-08-07)}{
  \itemize{
    \item first release to CRAN
    \item improvement/bugfix in \code{rbind.labeled.data.frame()}
    \item improvement of \code{toLatex.sessionInfo()}:
      file can be \code{NULL} now (no BibTeX file created on HDD)
    \item added plot function for \code{labeled.data.frame} objects that
      allows for univariate plots and grouped, bivariate plots
    \item numerous improvements in manuals
  }
}
\section{Changes in papeR version 0.2-0 (2013-07-01)}{
  \itemize{
    \item greatly improved \code{prettify} functions:
    \itemize{
      \item added prettify functions for \code{summary.coxph},
      \code{summary.lme}, \code{summary.mer} and \code{anova}
      \item  added confidence intervals to all model based
      \code{prettify} functions and made \code{confint = TRUE} the
      default; confidence intervalls are computed by refitting the
      model within \code{prettify} and using \code{confint()} on this
      model (experimental)
      \item  improved handling of p-values
    }
    \item added new class \code{"labeled.data.frame"} with special
    \code{subset}, \code{cbind} and \code{rbind} functions (to keep
    labels when changing data set)
    \item added "shortcut" to define labels using \code{labels =
      TRUE} in \code{latex.tables.XXX}:

    labels are extracted from \code{labeled.data.frame} directly

    \item new \code{toLatex} function for \code{sessionInfo()}
    [with nicer results than the default function from base \pkg{R}:
    e.g. citations are included]
  }
}
\section{Changes in papeR version 0.1-0 (2013-01-21)}{
  \itemize{
    \item initial version
    \item improvement of \code{prettify} function
    \item added \code{prettify} functions for more object classes
    \item added function \code{toLatex} to sanitize code for usage in LaTeX
    \item improved label handling when data set is alterd
      (e.g. variables dropped, added or renamed)
  }
}
