/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.http;

import com.qarks.util.http.HttpHeader;
import java.io.InputStream;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class HttpRequest {
    protected HttpHeader header;
    protected InputStream requestInputStream;
    protected int dataLengthRead = 0;
    protected String method;
    protected String resourceName;
    protected Hashtable parameters = new Hashtable();
    protected String hostAddress = "";
    protected String hostName = "";

    public HttpRequest(HttpHeader httpHeader, InputStream inputStream, String string, String string2) {
        this.header = httpHeader;
        this.requestInputStream = inputStream;
        if (string != null) {
            this.hostAddress = string;
        }
        if (string2 != null) {
            this.hostName = string2;
        }
        this.parseRequestHead();
    }

    public String getRemoteHostName() {
        return this.hostName;
    }

    public String getRemoteHostAddress() {
        return this.hostAddress;
    }

    private void parseRequestHead() {
        String string = this.header.getHead();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = string3.indexOf("?");
        if (n > -1 && string3.length() > n + 1) {
            String string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
            stringTokenizer = new StringTokenizer(string4, "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                n = string5.indexOf("=");
                if (n <= -1) continue;
                String string6 = string5.substring(0, n);
                String string7 = string5.substring(n + 1);
                hashtable.put(string6, string7);
            }
        }
        this.method = string2;
        this.resourceName = string3;
        this.parameters = hashtable;
    }

    public String getHead() {
        return this.header.getHead();
    }

    public HttpHeader getHeaders() {
        return this.header;
    }

    public String getMethod() {
        return this.method;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Hashtable getParameters() {
        return this.parameters;
    }

    public String getParameter(String string) {
        String string2 = (String)this.parameters.get(string);
        if (string2 != null) {
            string2 = URLDecoder.decode(string2);
        }
        return string2;
    }

    public InputStream getInputStream() {
        return this.requestInputStream;
    }
}

