/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.PrintWriter;
import java.io.Writer;

public class IndentPrintWriter
extends PrintWriter {
    private int indent = 0;
    private boolean indented = false;
    private String indentString = "  ";

    public IndentPrintWriter(Writer w, int level) {
        super(w);
        this.setIndent(level);
    }

    public IndentPrintWriter(Writer w) {
        this(w, 0);
    }

    @Override
    public void print(boolean s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(char s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(char[] s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(double s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(float s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(int s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(long s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(Object s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(String s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void println() {
        this.indented = false;
        super.println();
    }

    private void doIndent() {
        if (this.indented) {
            return;
        }
        this.indented = true;
        for (int i = 0; i < this.indent; ++i) {
            super.print(this.indentString);
        }
    }

    public void indent() {
        ++this.indent;
    }

    public void outdent() {
        --this.indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int level) {
        this.indent = level;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }
}

