/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.rexp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataField;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Discretize;
import org.dmg.pmml.DiscretizeBin;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.Interval;
import org.dmg.pmml.MapValues;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.rexp.ExpressionTranslator;
import org.jpmml.rexp.Formula;
import org.jpmml.rexp.FormulaContext;
import org.jpmml.rexp.FunctionExpression;
import org.jpmml.rexp.RExp;
import org.jpmml.rexp.RExpEncoder;
import org.jpmml.rexp.RExpUtil;
import org.jpmml.rexp.RFactorVector;
import org.jpmml.rexp.RIntegerVector;
import org.jpmml.rexp.RStringVector;

public class FormulaUtil {
    private FormulaUtil() {
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static Formula createFormula(RExp terms, FormulaContext context, RExpEncoder encoder) {
        formula = new Formula(encoder);
        factors = terms.getIntegerAttribute("factors");
        dataClasses = terms.getStringAttribute("dataClasses", false);
        variableRows = factors.dimnames(0);
        termColumns = factors.dimnames(1);
        expressionFields = new VariableMap();
        for (i = 0; i < variableRows.size(); ++i) {
            block21: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                name = variable = variableRows.getDequotedValue(i);
                                opType = OpType.CONTINUOUS;
                                if (dataClasses != null) {
                                    dataType = RExpUtil.getDataType((String)dataClasses.getElement(variable));
                                } else {
                                    data = context.getData(name);
                                    if (data != null) {
                                        dataType = data.getDataType();
                                    } else {
                                        throw new IllegalArgumentException();
                                    }
                                }
                                categories = context.getCategories(variable);
                                if (categories != null && !categories.isEmpty()) {
                                    opType = OpType.CATEGORICAL;
                                }
                                expression = null;
                                shortName = name;
                                if ((variable.indexOf(40) <= -1 || variable.indexOf(41) <= -1) && variable.indexOf(32) <= -1) break block21;
                                try {
                                    expression = ExpressionTranslator.translateExpression(variable);
                                }
                                catch (Exception e) {
                                    break block21;
                                }
                                if (expression instanceof FunctionExpression) {
                                    functionExpression = (FunctionExpression)expression;
                                } else {
                                    xArgument = new FunctionExpression.Argument("x", expression){

                                        @Override
                                        public String formatExpression() {
                                            return variable;
                                        }
                                    };
                                    functionExpression = new FunctionExpression("base", "I", Collections.singletonList(xArgument));
                                }
                                if (!functionExpression.hasId("base", "cut")) break block22;
                                expression = FormulaUtil.encodeCutExpression(functionExpression, categories, expressionFields, encoder);
                                ** GOTO lbl54
                            }
                            if (!functionExpression.hasId("base", "I")) break block23;
                            expression = FormulaUtil.encodeIdentityExpression(functionExpression, expressionFields, encoder);
                            ** GOTO lbl54
                        }
                        if (!functionExpression.hasId("base", "ifelse")) break block24;
                        expression = FormulaUtil.encodeIfElseExpression(functionExpression, expressionFields, encoder);
                        ** GOTO lbl54
                    }
                    if (!functionExpression.hasId("plyr", "mapvalues")) break block25;
                    expression = FormulaUtil.encodeMapValuesExpression(functionExpression, categories, expressionFields, encoder);
                    ** GOTO lbl54
                }
                if (!functionExpression.hasId("plyr", "revalue")) {
                    expression = null;
                } else {
                    expression = FormulaUtil.encodeReValueExpression(functionExpression, categories, expressionFields, encoder);
lbl54:
                    // 5 sources

                    xArgument = functionExpression.getArgument("x", 0);
                    value = xArgument.formatExpression().trim();
                    v0 = shortName = functionExpression.hasId("base", "I") != false ? value : functionExpression.getFunction() + "(" + value + ")";
                }
            }
            if (dataType == DataType.BOOLEAN) {
                opType = OpType.CATEGORICAL;
                categoryNames = Arrays.asList(new String[]{"FALSE", "TRUE"});
                categoryValues /* !! */  = Arrays.asList(new Boolean[]{Boolean.FALSE, Boolean.TRUE});
            } else {
                categoryNames = categories;
                categoryValues /* !! */  = categories;
            }
            if (expression != null) {
                derivedField = encoder.createDerivedField(name, opType, dataType, expression).addExtensions(new Extension[]{PMMLUtil.createExtension((String)"variable", (Object[])new Object[]{variable})});
                if (categoryNames != null && !categoryNames.isEmpty()) {
                    formula.addField((Field<?>)derivedField, categoryNames, categoryValues /* !! */ );
                } else {
                    formula.addField((Field<?>)derivedField);
                }
                if (name.equals(shortName)) continue;
                encoder.renameField(name, shortName);
                continue;
            }
            if (categoryNames != null && !categoryNames.isEmpty()) {
                dataField = encoder.createDataField(name, OpType.CATEGORICAL, dataType, categories);
                formula.addField((Field<?>)dataField, categoryNames, categoryValues /* !! */ );
                continue;
            }
            dataField = encoder.createDataField(name, OpType.CONTINUOUS, dataType);
            formula.addField((Field<?>)dataField);
        }
        entries = expressionFields.entrySet();
        for (Map.Entry entry : entries) {
            name = (String)entry.getKey();
            categories = (List)entry.getValue();
            dataField = encoder.getDataField(name);
            if (dataField != null) continue;
            opType = OpType.CONTINUOUS;
            dataType = DataType.DOUBLE;
            if (categories != null && !categories.isEmpty()) {
                opType = OpType.CATEGORICAL;
            }
            if ((data = context.getData(name)) != null) {
                dataType = data.getDataType();
            }
            dataField = encoder.createDataField(name, opType, dataType, categories);
        }
        return formula;
    }

    public static void setLabel(Formula formula, RExp terms, RExp levels, RExpEncoder encoder) {
        DataField dataField;
        RIntegerVector response = terms.getIntegerAttribute("response");
        int responseIndex = (Integer)response.asScalar();
        if (responseIndex != 0) {
            dataField = (DataField)formula.getField(responseIndex - 1);
            String name = dataField.requireName();
            if (encoder.getDataField(name) == null) {
                encoder.addDataField(dataField);
            }
            if (levels instanceof RStringVector) {
                RStringVector stringLevels = (RStringVector)levels;
                dataField = (DataField)encoder.toCategorical(name, stringLevels.getValues());
            } else if (levels instanceof RFactorVector) {
                RFactorVector factorLevels = (RFactorVector)levels;
                dataField = (DataField)encoder.toCategorical(name, factorLevels.getLevelValues());
            } else if (levels != null) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new IllegalArgumentException();
        }
        encoder.setLabel(dataField);
    }

    public static void addFeatures(Formula formula, RStringVector names, boolean allowInteractions, RExpEncoder encoder) {
        FormulaUtil.addFeatures(formula, names.getValues(), allowInteractions, encoder);
    }

    public static void addFeatures(Formula formula, List<String> names, boolean allowInteractions, RExpEncoder encoder) {
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            Feature feature = allowInteractions ? formula.resolveComplexFeature(name) : formula.resolveFeature(name);
            encoder.addFeature(feature);
        }
    }

    public static List<String> removeSpecialSymbol(List<String> names, String specialName) {
        int index = names.indexOf(specialName);
        if (index > -1) {
            names = new ArrayList<String>(names);
            names.remove(index);
        }
        return names;
    }

    public static List<String> removeSpecialSymbol(List<String> names, String specialName, int specialNameIndex) {
        String name = names.get(specialNameIndex);
        if (!name.equals(specialName)) {
            throw new IllegalArgumentException();
        }
        names = new ArrayList<String>(names);
        names.remove(specialNameIndex);
        return names;
    }

    private static Expression encodeCutExpression(FunctionExpression functionExpression, List<String> categories, VariableMap expressionFields, RExpEncoder encoder) {
        FunctionExpression.Argument xArgument = functionExpression.getArgument("x", 0);
        expressionFields.putAll(xArgument);
        String fieldName = FormulaUtil.prepareInputField(xArgument, OpType.CONTINUOUS, DataType.DOUBLE, encoder);
        return FormulaUtil.createDiscretize(fieldName, categories);
    }

    private static Expression encodeIdentityExpression(FunctionExpression functionExpression, VariableMap expressionFields, RExpEncoder encoder) {
        FunctionExpression.Argument xArgument = functionExpression.getArgument("x", 0);
        expressionFields.putAll(xArgument);
        return FormulaUtil.prepareExpression(xArgument, expressionFields, encoder);
    }

    private static Expression encodeIfElseExpression(FunctionExpression functionExpression, VariableMap expressionFields, RExpEncoder encoder) {
        FunctionExpression.Argument testArgument = functionExpression.getArgument("test", 0);
        expressionFields.putAll(testArgument);
        FunctionExpression.Argument yesArgument = functionExpression.getArgument("yes", 1);
        FunctionExpression.Argument noArgument = functionExpression.getArgument("no", 2);
        expressionFields.putAll(yesArgument);
        expressionFields.putAll(noArgument);
        Apply apply = PMMLUtil.createApply((String)"if", (Expression[])new Expression[]{FormulaUtil.prepareExpression(testArgument, expressionFields, encoder), FormulaUtil.prepareExpression(yesArgument, expressionFields, encoder), FormulaUtil.prepareExpression(noArgument, expressionFields, encoder)});
        return apply;
    }

    private static Expression encodeMapValuesExpression(FunctionExpression functionExpression, List<String> categories, VariableMap expressionFields, RExpEncoder encoder) {
        FunctionExpression.Argument xArgument = functionExpression.getArgument("x", 0);
        expressionFields.putAll(xArgument);
        String fieldName = FormulaUtil.prepareInputField(xArgument, OpType.CATEGORICAL, DataType.STRING, encoder);
        FunctionExpression.Argument fromArgument = functionExpression.getArgument("from", 1);
        FunctionExpression.Argument toArgument = functionExpression.getArgument("to", 2);
        Map<String, String> mapping = FormulaUtil.parseMapValues(fromArgument, toArgument);
        expressionFields.put(fieldName, new ArrayList<String>(mapping.keySet()));
        return FormulaUtil.createMapValues(fieldName, mapping, categories);
    }

    private static Expression encodeReValueExpression(FunctionExpression functionExpression, List<String> categories, VariableMap expressionFields, RExpEncoder encoder) {
        FunctionExpression.Argument xArgument = functionExpression.getArgument("x", 0);
        expressionFields.putAll(xArgument);
        String fieldName = FormulaUtil.prepareInputField(xArgument, OpType.CATEGORICAL, DataType.STRING, encoder);
        FunctionExpression.Argument replaceArgument = functionExpression.getArgument("replace", 1);
        Map<String, String> mapping = FormulaUtil.parseRevalue(replaceArgument);
        expressionFields.put(fieldName, new ArrayList<String>(mapping.keySet()));
        return FormulaUtil.createMapValues(fieldName, mapping, categories);
    }

    private static String prepareInputField(FunctionExpression.Argument argument, OpType opType, DataType dataType, RExpEncoder encoder) {
        Expression expression = argument.getExpression();
        if (expression instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)expression;
            return fieldRef.requireField();
        }
        if (expression instanceof Apply) {
            Apply apply = (Apply)expression;
            DerivedField derivedField = encoder.createDerivedField(argument.formatExpression().trim(), opType, dataType, (Expression)apply);
            return derivedField.requireName();
        }
        throw new IllegalArgumentException();
    }

    private static Expression prepareExpression(FunctionExpression.Argument argument, VariableMap expressionFields, RExpEncoder encoder) {
        Expression expression = argument.getExpression();
        if (expression instanceof FunctionExpression) {
            FunctionExpression functionExpression = (FunctionExpression)expression;
            if (functionExpression.hasId("base", "ifelse")) {
                return FormulaUtil.encodeIfElseExpression(functionExpression, expressionFields, encoder);
            }
            throw new IllegalArgumentException();
        }
        return expression;
    }

    private static Discretize createDiscretize(String name, List<String> categories) {
        Discretize discretize = new Discretize(name);
        for (String category : categories) {
            Interval interval = ExpressionTranslator.translateInterval(category);
            DiscretizeBin discretizeBin = new DiscretizeBin((Object)category, interval);
            discretize.addDiscretizeBins(new DiscretizeBin[]{discretizeBin});
        }
        return discretize;
    }

    private static MapValues createMapValues(String name, Map<String, String> mapping, List<String> categories) {
        LinkedHashSet<String> inputs = new LinkedHashSet<String>(mapping.keySet());
        LinkedHashSet<String> outputs = new LinkedHashSet<String>(mapping.values());
        for (String category : categories) {
            if (outputs.contains(category)) continue;
            mapping.put(category, category);
        }
        return PMMLUtil.createMapValues((String)name, mapping);
    }

    private static Map<String, String> parseMapValues(FunctionExpression.Argument fromArgument, FunctionExpression.Argument toArgument) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List<String> fromValues = FormulaUtil.parseVector(fromArgument);
        List<String> toValues = FormulaUtil.parseVector(toArgument);
        if (fromValues.size() != toValues.size()) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < fromValues.size(); ++i) {
            String from = fromValues.get(i);
            String to = toValues.get(i);
            if (from == null || to == null) {
                throw new IllegalArgumentException();
            }
            result.put(from, to);
        }
        return result;
    }

    private static Map<String, String> parseRevalue(FunctionExpression.Argument replaceArgument) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        FunctionExpression vectorExpression = FormulaUtil.toVectorExpression(replaceArgument);
        List<FunctionExpression.Argument> objectArguments = vectorExpression.getArguments();
        for (FunctionExpression.Argument objectArgument : objectArguments) {
            String from = objectArgument.getTag();
            if (from == null) {
                throw new IllegalArgumentException();
            }
            Constant constant = (Constant)objectArgument.getExpression();
            String to = (String)constant.getValue();
            if (to == null) {
                throw new IllegalArgumentException();
            }
            result.put(from, to);
        }
        return result;
    }

    private static List<String> parseVector(FunctionExpression.Argument argument) {
        ArrayList<String> result = new ArrayList<String>();
        FunctionExpression vectorExpression = FormulaUtil.toVectorExpression(argument);
        List<FunctionExpression.Argument> objectArguments = vectorExpression.getArguments();
        for (FunctionExpression.Argument objectArgument : objectArguments) {
            Constant constant = (Constant)objectArgument.getExpression();
            String string = ValueUtil.asString((Object)constant.getValue());
            result.add(string);
        }
        return result;
    }

    private static FunctionExpression toVectorExpression(FunctionExpression.Argument argument) {
        FunctionExpression functionExpression = (FunctionExpression)ExpressionTranslator.translateExpression(argument.formatExpression().trim());
        if (!functionExpression.hasId("base", "c")) {
            throw new IllegalArgumentException();
        }
        return functionExpression;
    }

    private static class VariableMap
    extends LinkedHashMap<String, List<String>> {
        private VariableMap() {
        }

        public void putAll(FunctionExpression.Argument argument) {
            Set<String> names = argument.getFieldNames();
            for (String name : names) {
                if (this.containsKey(name)) continue;
                this.put(name, null);
            }
        }
    }
}

