/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Iterables;
import com.google.common.math.DoubleMath;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Apply;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.jpmml.converter.Feature;
import org.jpmml.converter.FeatureResolver;

public class TypeUtil {
    private TypeUtil() {
    }

    public static DataType getDataType(Object value) {
        if (value instanceof String) {
            return DataType.STRING;
        }
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return DataType.INTEGER;
        }
        if (value instanceof Float) {
            return DataType.FLOAT;
        }
        if (value instanceof Double) {
            return DataType.DOUBLE;
        }
        if (value instanceof Boolean) {
            return DataType.BOOLEAN;
        }
        throw new IllegalArgumentException();
    }

    public static DataType getDataType(String value) {
        try {
            Integer.parseInt(value);
            return DataType.INTEGER;
        }
        catch (NumberFormatException integerNfe) {
            try {
                double doubleValue = Double.parseDouble(value);
                if (DoubleMath.isMathematicalInteger((double)doubleValue)) {
                    return DataType.INTEGER;
                }
                return DataType.DOUBLE;
            }
            catch (NumberFormatException doubleNfe) {
                return DataType.STRING;
            }
        }
    }

    public static DataType getDataType(Collection<?> values) {
        return TypeUtil.getDataType(values, null);
    }

    public static DataType getDataType(Collection<?> values, DataType defaultDataType) {
        if (values.isEmpty()) {
            if (defaultDataType != null) {
                return defaultDataType;
            }
            throw new IllegalArgumentException();
        }
        boolean allStrings = true;
        HashSet<DataType> dataTypes = new HashSet<DataType>();
        for (Object value : values) {
            DataType dataType;
            if (value instanceof String) {
                dataType = TypeUtil.getDataType((String)value);
            } else {
                allStrings = false;
                dataType = TypeUtil.getDataType(value);
            }
            dataTypes.add(dataType);
        }
        if (dataTypes.size() == 1) {
            return (DataType)Iterables.getOnlyElement(dataTypes);
        }
        if (allStrings) {
            return DataType.STRING;
        }
        throw new IllegalArgumentException("Expected all values to be of the same data type, got " + dataTypes.size() + " different data types (" + dataTypes + ")");
    }

    public static boolean isString(Expression expression, FeatureResolver featureResolver) {
        DataType dataType = TypeUtil.getDataType(expression, featureResolver);
        return dataType == DataType.STRING;
    }

    public static DataType getDataType(Expression expression, FeatureResolver featureResolver) {
        if (expression instanceof Constant) {
            Constant constant = (Constant)expression;
            return constant.getDataType();
        }
        if (expression instanceof FieldRef) {
            Feature feature;
            FieldRef fieldRef = (FieldRef)expression;
            Feature feature2 = feature = featureResolver != null ? featureResolver.resolveFeature(fieldRef.requireField()) : null;
            if (feature == null) {
                return null;
            }
            return feature.getDataType();
        }
        if (expression instanceof Apply) {
            String function;
            Apply apply = (Apply)expression;
            switch (function = apply.requireFunction()) {
                case "ceil": 
                case "floor": 
                case "round": {
                    return DataType.INTEGER;
                }
                case "isMissing": 
                case "isNotMissing": 
                case "isValid": 
                case "isNotValid": {
                    return DataType.BOOLEAN;
                }
                case "equal": 
                case "notEqual": 
                case "lessThan": 
                case "lessOrEqual": 
                case "greaterThan": 
                case "greaterOrEqual": {
                    return DataType.BOOLEAN;
                }
                case "and": 
                case "or": {
                    return DataType.BOOLEAN;
                }
                case "not": {
                    return DataType.BOOLEAN;
                }
                case "isIn": 
                case "isNotIn": {
                    return DataType.BOOLEAN;
                }
                case "if": {
                    List expressions = apply.getExpressions();
                    if (expressions.size() > 1) {
                        DataType trueDataType = TypeUtil.getDataType((Expression)expressions.get(1), featureResolver);
                        if (expressions.size() > 2) {
                            DataType falseDataType = TypeUtil.getDataType((Expression)expressions.get(2), featureResolver);
                            if (Objects.equals(trueDataType, falseDataType)) {
                                return trueDataType;
                            }
                            return null;
                        }
                        return trueDataType;
                    }
                    return null;
                }
                case "concat": 
                case "lowercase": 
                case "substring": 
                case "trimBlanks": 
                case "uppercase": {
                    return DataType.STRING;
                }
                case "stringLength": {
                    return DataType.INTEGER;
                }
                case "replace": {
                    return DataType.STRING;
                }
                case "matches": {
                    return DataType.BOOLEAN;
                }
                case "formatDatetime": 
                case "formatNumber": {
                    return DataType.STRING;
                }
                case "dateDaysSinceYear": 
                case "dateSecondsSinceMidnight": 
                case "dateSecondsSinceYear": {
                    return DataType.INTEGER;
                }
            }
            return null;
        }
        return null;
    }

    public static OpType getOpType(DataType dataType) {
        switch (dataType) {
            case STRING: {
                return OpType.CATEGORICAL;
            }
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: {
                return OpType.CONTINUOUS;
            }
            case BOOLEAN: {
                return OpType.CATEGORICAL;
            }
            case DATE: 
            case DATE_TIME: {
                return OpType.ORDINAL;
            }
        }
        throw new IllegalArgumentException();
    }
}

