/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.general_regression;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.dmg.pmml.MathContext;
import org.dmg.pmml.general_regression.CovariateList;
import org.dmg.pmml.general_regression.FactorList;
import org.dmg.pmml.general_regression.GeneralRegressionModel;
import org.dmg.pmml.general_regression.PCell;
import org.dmg.pmml.general_regression.PPCell;
import org.dmg.pmml.general_regression.PPMatrix;
import org.dmg.pmml.general_regression.ParamMatrix;
import org.dmg.pmml.general_regression.Parameter;
import org.dmg.pmml.general_regression.ParameterList;
import org.dmg.pmml.general_regression.Predictor;
import org.dmg.pmml.general_regression.PredictorList;
import org.jpmml.converter.BinaryFeature;
import org.jpmml.converter.BooleanFeature;
import org.jpmml.converter.ConstantFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InteractionFeature;
import org.jpmml.converter.PowerFeature;
import org.jpmml.converter.ProductFeature;
import org.jpmml.converter.ValueUtil;

public class GeneralRegressionModelUtil {
    private GeneralRegressionModelUtil() {
    }

    public static GeneralRegressionModel encodeRegressionTable(GeneralRegressionModel generalRegressionModel, List<? extends Feature> features, List<? extends Number> coefficients, Number intercept, Object targetCategory) {
        return GeneralRegressionModelUtil.encodeRegressionTable(null, generalRegressionModel, features, coefficients, intercept, targetCategory);
    }

    public static GeneralRegressionModel encodeRegressionTable(MathContext mathContext, GeneralRegressionModel generalRegressionModel, List<? extends Feature> features, List<? extends Number> coefficients, Number intercept, Object targetCategory) {
        ParamMatrix paramMatrix;
        PPMatrix ppMatrix;
        if (features.size() != coefficients.size()) {
            throw new IllegalArgumentException();
        }
        ParameterList parameterList = generalRegressionModel.getParameterList();
        if (parameterList == null) {
            parameterList = new ParameterList();
            generalRegressionModel.setParameterList(parameterList);
        }
        if ((ppMatrix = generalRegressionModel.getPPMatrix()) == null) {
            ppMatrix = new PPMatrix();
            generalRegressionModel.setPPMatrix(ppMatrix);
        }
        if ((paramMatrix = generalRegressionModel.getParamMatrix()) == null) {
            paramMatrix = new ParamMatrix();
            generalRegressionModel.setParamMatrix(paramMatrix);
        }
        int p = parameterList.getParameters().size();
        if (intercept != null && !ValueUtil.isZeroLike(intercept)) {
            Parameter parameter = new Parameter("p" + String.valueOf(p)).setLabel("(intercept)");
            parameterList.addParameters(new Parameter[]{parameter});
            ++p;
            PCell pCell = new PCell(parameter.requireName(), intercept).setTargetCategory(targetCategory);
            paramMatrix.addPCells(new PCell[]{pCell});
        }
        LinkedHashSet<String> covariateFieldNames = new LinkedHashSet<String>();
        LinkedHashSet<String> factorFieldNames = new LinkedHashSet<String>();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            Number coefficient = coefficients.get(i);
            if (coefficient == null || ValueUtil.isZeroLike(coefficient)) continue;
            if (feature instanceof ProductFeature) {
                ProductFeature productFeature = (ProductFeature)feature;
                feature = productFeature.getFeature();
                coefficient = ValueUtil.multiply(mathContext, coefficient, productFeature.getFactor());
            }
            Parameter parameter = new Parameter("p" + String.valueOf(p));
            parameterList.addParameters(new Parameter[]{parameter});
            ++p;
            Number multiplier = GeneralRegressionModelUtil.createPPCells(mathContext, feature, parameter, ppMatrix, covariateFieldNames, factorFieldNames);
            if (!ValueUtil.isOne(multiplier)) {
                coefficient = ValueUtil.multiply(mathContext, coefficient, multiplier);
            }
            PCell pCell = new PCell(parameter.requireName(), coefficient).setTargetCategory(targetCategory);
            paramMatrix.addPCells(new PCell[]{pCell});
        }
        if (!covariateFieldNames.isEmpty()) {
            CovariateList covariateList = generalRegressionModel.getCovariateList();
            if (covariateList == null) {
                covariateList = new CovariateList();
                generalRegressionModel.setCovariateList(covariateList);
            }
            GeneralRegressionModelUtil.createPredictors((PredictorList)covariateList, covariateFieldNames);
        }
        if (!factorFieldNames.isEmpty()) {
            FactorList factorList = generalRegressionModel.getFactorList();
            if (factorList == null) {
                factorList = new FactorList();
                generalRegressionModel.setFactorList(factorList);
            }
            GeneralRegressionModelUtil.createPredictors((PredictorList)factorList, factorFieldNames);
        }
        return generalRegressionModel;
    }

    private static Number createPPCells(MathContext mathContext, Feature feature, Parameter parameter, PPMatrix ppMatrix, Set<String> covariateFieldNames, Set<String> factorFieldNames) {
        if (feature instanceof BinaryFeature) {
            BinaryFeature binaryFeature = (BinaryFeature)feature;
            return GeneralRegressionModelUtil.createPPCell(binaryFeature.getValue(), binaryFeature.getName(), parameter, ppMatrix, factorFieldNames);
        }
        if (feature instanceof BooleanFeature) {
            BooleanFeature booleanFeature = (BooleanFeature)feature;
            return GeneralRegressionModelUtil.createPPCell(BooleanFeature.VALUE_TRUE, booleanFeature.getName(), parameter, ppMatrix, factorFieldNames);
        }
        if (feature instanceof ConstantFeature) {
            ConstantFeature constantFeature = (ConstantFeature)feature;
            return constantFeature.getValue();
        }
        if (feature instanceof InteractionFeature) {
            InteractionFeature interactionFeature = (InteractionFeature)feature;
            Number result = 1.0;
            List<? extends Feature> inputFeatures = interactionFeature.getInputFeatures();
            for (Feature feature2 : inputFeatures) {
                Number value = GeneralRegressionModelUtil.createPPCells(mathContext, feature2, parameter, ppMatrix, covariateFieldNames, factorFieldNames);
                result = ValueUtil.multiply(mathContext, result, value);
            }
            return result;
        }
        if (feature instanceof PowerFeature) {
            PowerFeature powerFeature = (PowerFeature)feature;
            return GeneralRegressionModelUtil.createPPCell(String.valueOf(powerFeature.getPower()), powerFeature.getName(), parameter, ppMatrix, covariateFieldNames);
        }
        ContinuousFeature continuousFeature = feature.toContinuousFeature();
        return GeneralRegressionModelUtil.createPPCell("1", continuousFeature.getName(), parameter, ppMatrix, covariateFieldNames);
    }

    private static Number createPPCell(Object value, String fieldName, Parameter parameter, PPMatrix ppMatrix, Set<String> fieldNames) {
        PPCell ppCell = new PPCell(value, fieldName, parameter.requireName());
        ppMatrix.addPPCells(new PPCell[]{ppCell});
        fieldNames.add(ppCell.requireField());
        return 1.0;
    }

    private static void createPredictors(PredictorList predictorList, Set<String> fieldNames) {
        fieldNames = new LinkedHashSet<String>(fieldNames);
        List predictors = predictorList.getPredictors();
        for (Predictor predictor : predictors) {
            fieldNames.remove(predictor.requireField());
        }
        if (fieldNames.isEmpty()) {
            return;
        }
        for (String fieldName : fieldNames) {
            Predictor predictor = new Predictor(fieldName);
            predictorList.addPredictors(new Predictor[]{predictor});
        }
    }
}

