/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import java.util.List;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.layout.AtomPlacer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public final class HydrogenPlacer {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(HydrogenPlacer.class);

    public void placeHydrogens2D(IAtomContainer container, double bondLength) {
        logger.debug((Object)"placing hydrogens on all atoms");
        for (IAtom atom : container.atoms()) {
            if (atom.getPoint2d() == null) continue;
            this.placeHydrogens2D(container, atom, bondLength);
        }
        logger.debug((Object)"hydrogen placement complete");
    }

    public void placeHydrogens2D(IAtomContainer container, IAtom atom) {
        double bondLength = GeometryUtil.getBondLengthAverage((IAtomContainer)container);
        this.placeHydrogens2D(container, atom, bondLength);
    }

    public void placeHydrogens2D(IAtomContainer container, IAtom atom, double bondLength) {
        if (container == null) {
            throw new IllegalArgumentException("cannot place hydrogens, no container provided");
        }
        if (atom.getPoint2d() == null) {
            throw new IllegalArgumentException("cannot place hydrogens on atom without coordinates");
        }
        logger.debug((Object)"placing hydrogens connected to atom ", new Object[]{atom.getSymbol(), ": ", atom.getPoint2d()});
        logger.debug((Object)"bond length", new Object[]{bondLength});
        AtomPlacer atomPlacer = new AtomPlacer();
        atomPlacer.setMolecule(container);
        List connected = container.getConnectedAtomsList(atom);
        IAtomContainer placed = (IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer unplaced = (IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (IAtom conAtom : connected) {
            if (conAtom.getPoint2d() == null) {
                if (conAtom.getAtomicNumber() == 1) {
                    unplaced.addAtom(conAtom);
                    continue;
                }
                throw new IllegalArgumentException("cannot place hydrogens, atom has connected non-hydrogens without coordinates");
            }
            placed.addAtom(conAtom);
        }
        logger.debug((Object)"Atom placement before procedure:");
        logger.debug((Object)"Centre atom ", new Object[]{atom.getSymbol(), ": ", atom.getPoint2d()});
        for (int i = 0; i < unplaced.getAtomCount(); ++i) {
            logger.debug((Object)("H-" + i), new Object[]{": ", unplaced.getAtom(i).getPoint2d()});
        }
        Point2d centerPlacedAtoms = GeometryUtil.get2DCenter((IAtomContainer)placed);
        atomPlacer.distributePartners(atom, placed, centerPlacedAtoms, unplaced, bondLength);
        logger.debug((Object)"Atom placement after procedure:");
        logger.debug((Object)"Centre atom ", new Object[]{atom.getSymbol(), ": ", atom.getPoint2d()});
        for (int i = 0; i < unplaced.getAtomCount(); ++i) {
            logger.debug((Object)("H-" + i), new Object[]{": ", unplaced.getAtom(i).getPoint2d()});
        }
    }
}

