/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import javax.vecmath.Point3d;

public class GridGenerator {
    double latticeConstant = 0.5;
    double extendGrid = 2.0;
    double[][][] grid = null;
    double[] gridArray = null;
    double maxx = 0.0;
    double maxy = 0.0;
    double maxz = 0.0;
    double minx = 0.0;
    double miny = 0.0;
    double minz = 0.0;
    int[] dim = new int[]{0, 0, 0};

    public GridGenerator() {
    }

    public GridGenerator(double min, double max) {
        this.setDimension(min, max);
        this.generateGrid();
    }

    public GridGenerator(double min, double max, double initialValue) {
        this.setDimension(min, max);
        this.generateGrid();
        this.initializeGrid(initialValue);
    }

    public GridGenerator(double[] minMax, double initialValue, boolean cubicGridFlag) {
        this.setDimension(minMax, cubicGridFlag);
        this.generateGrid();
        this.initializeGrid(initialValue);
    }

    public void setDimension(double min, double max) {
        this.minx = min;
        this.maxx = max;
        this.miny = min;
        this.maxy = max;
        this.minz = min;
        this.maxz = max;
    }

    public void setDimension(double[] minMax, boolean cubicGridFlag) {
        if (cubicGridFlag) {
            double min = minMax[0];
            double max = minMax[0];
            for (double v : minMax) {
                if (v < min) {
                    min = v;
                    continue;
                }
                if (!(v > max)) continue;
                max = v;
            }
            this.setDimension(min, max);
        } else {
            this.minx = minMax[0];
            this.maxx = minMax[1];
            this.miny = minMax[2];
            this.maxy = minMax[3];
            this.minz = minMax[4];
            this.maxz = minMax[5];
        }
    }

    public void setDimension(double minx, double maxx, double miny, double maxy, double minz, double maxz) {
        this.minx = minx;
        this.maxx = maxx;
        this.miny = miny;
        this.maxy = maxy;
        this.minz = minz;
        this.maxz = maxz;
    }

    public void generateGrid() {
        this.minx -= this.extendGrid;
        this.maxx += this.extendGrid;
        this.miny -= this.extendGrid;
        this.maxy += this.extendGrid;
        this.minz -= this.extendGrid;
        this.maxz += this.extendGrid;
        this.dim[0] = (int)Math.round(Math.abs(this.maxx - this.minx) / this.latticeConstant);
        this.dim[1] = (int)Math.round(Math.abs(this.maxy - this.miny) / this.latticeConstant);
        this.dim[2] = (int)Math.round(Math.abs(this.maxz - this.minz) / this.latticeConstant);
        this.grid = new double[this.dim[0] + 1][this.dim[1] + 1][this.dim[2] + 1];
    }

    public void initializeGrid(double value) {
        for (int i = 0; i < this.grid.length; ++i) {
            for (int j = 0; j < this.grid[0].length; ++j) {
                for (int k = 0; k < this.grid[0][0].length; ++k) {
                    this.grid[k][j][i] = value;
                }
            }
        }
    }

    public double[][][] initializeGrid(double[][][] grid, double value) {
        for (int i = 0; i < grid.length; ++i) {
            for (int j = 0; j < grid[0].length; ++j) {
                for (int k = 0; k < grid[0][0].length; ++k) {
                    grid[k][j][i] = value;
                }
            }
        }
        return grid;
    }

    public double[] gridToGridArray(double[][][] grid) {
        if (grid == null) {
            grid = this.grid;
        }
        this.gridArray = new double[this.dim[0] * this.dim[1] * this.dim[2] + 3];
        int dimCounter = 0;
        for (int z = 0; z < grid[0][0].length; ++z) {
            for (int y = 0; y < grid[0].length; ++y) {
                for (double[][] doubles : grid) {
                    this.gridArray[dimCounter] = doubles[y][z];
                    ++dimCounter;
                }
            }
        }
        return this.gridArray;
    }

    public Point3d getCoordinatesFromGridPoint(Point3d gridPoint) {
        double dx = this.minx + this.latticeConstant * gridPoint.x;
        double dy = this.miny + this.latticeConstant * gridPoint.y;
        double dz = this.minz + this.latticeConstant * gridPoint.z;
        return new Point3d(dx, dy, dz);
    }

    public Point3d getCoordinatesFromGridPoint(int gridPoint) {
        int dimCounter = 0;
        Point3d point = new Point3d(0.0, 0.0, 0.0);
        for (int z = 0; z < this.grid[0][0].length; ++z) {
            for (int y = 0; y < this.grid[0].length; ++y) {
                for (int x = 0; x < this.grid.length; ++x) {
                    if (dimCounter == gridPoint) {
                        point.x = this.minx + this.latticeConstant * (double)x;
                        point.y = this.miny + this.latticeConstant * (double)y;
                        point.z = this.minz + this.latticeConstant * (double)z;
                        return point;
                    }
                    ++dimCounter;
                }
            }
        }
        return point;
    }

    public Point3d getGridPointFrom3dCoordinates(Point3d coord) throws Exception {
        Point3d gridPoint = new Point3d();
        if (!(coord.x >= this.minx & coord.x <= this.maxx)) {
            throw new Exception("CDKGridError: Given coordinates are not in grid");
        }
        gridPoint.x = (int)Math.round(Math.abs(this.minx - coord.x) / this.latticeConstant);
        if (!(coord.y >= this.miny & coord.y <= this.maxy)) {
            throw new Exception("CDKGridError: Given coordinates are not in grid");
        }
        gridPoint.y = (int)Math.round(Math.abs(this.miny - coord.y) / this.latticeConstant);
        if (!(coord.z >= this.minz & coord.z <= this.maxz)) {
            throw new Exception("CDKGridError: Given coordinates are not in grid");
        }
        gridPoint.z = (int)Math.round(Math.abs(this.minz - coord.z) / this.latticeConstant);
        return gridPoint;
    }

    public void writeGridInPmeshFormat(String outPutFileName) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outPutFileName + ".pmesh"));){
            int numberOfGridPoints = this.grid.length * this.grid[0].length * this.grid[0][0].length;
            writer.write(numberOfGridPoints + "\n");
            for (int z = 0; z < this.grid[0][0].length; ++z) {
                for (int y = 0; y < this.grid[0].length; ++y) {
                    for (int x = 0; x < this.grid.length; ++x) {
                        Point3d coords = this.getCoordinatesFromGridPoint(new Point3d((double)x, (double)y, (double)z));
                        writer.write(coords.x + "\t" + coords.y + "\t" + coords.z + "\n");
                    }
                }
            }
        }
    }

    public void writeGridInPmeshFormat(String outPutFileName, double cutOff) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outPutFileName + ".pmesh"));){
            int y;
            int z;
            boolean negative = cutOff < 0.0;
            int numberOfGridPoints = 0;
            for (z = 0; z < this.grid[0][0].length; ++z) {
                for (y = 0; y < this.grid[0].length; ++y) {
                    for (double[][] doubles : this.grid) {
                        if (negative) {
                            if (!(doubles[y][z] <= cutOff)) continue;
                            ++numberOfGridPoints;
                            continue;
                        }
                        if (!(doubles[y][z] >= cutOff)) continue;
                        ++numberOfGridPoints;
                    }
                }
            }
            writer.write(numberOfGridPoints + "\n");
            for (z = 0; z < this.grid[0][0].length; ++z) {
                for (y = 0; y < this.grid[0].length; ++y) {
                    for (int x = 0; x < this.grid.length; ++x) {
                        Point3d coords = this.getCoordinatesFromGridPoint(new Point3d((double)x, (double)y, (double)z));
                        if (negative) {
                            if (!(this.grid[x][y][z] <= cutOff)) continue;
                            writer.write(coords.x + "\t" + coords.y + "\t" + coords.z + "\n");
                            continue;
                        }
                        if (!(this.grid[x][y][z] >= cutOff)) continue;
                        writer.write(coords.x + "\t" + coords.y + "\t" + coords.z + "\n");
                    }
                }
            }
        }
    }

    public String toString() {
        return "Dim:" + this.dim + " SizeX:" + this.grid.length + " SizeY:" + this.grid[0].length + " SizeZ:" + this.grid[0][0].length + "\nminx:" + this.minx + " maxx:" + this.maxx + "\nminy:" + this.miny + " maxy:" + this.maxy + "\nminz:" + this.minz + " maxz:" + this.maxz;
    }

    public int[] getDim() {
        return this.dim;
    }

    public void setDim(int[] dim) {
        this.dim = dim;
    }

    public double getExtendGrid() {
        return this.extendGrid;
    }

    public void setExtendGrid(double extendGrid) {
        this.extendGrid = extendGrid;
    }

    public double[][][] getGrid() {
        return this.grid;
    }

    public void setGrid(double[][][] grid) {
        this.grid = grid;
    }

    public double getLatticeConstant() {
        return this.latticeConstant;
    }

    public void setLatticeConstant(double latticeConstant) {
        this.latticeConstant = latticeConstant;
    }

    public double[] getGridArray() {
        return this.gridArray;
    }

    public double getMaxx() {
        return this.maxx;
    }

    public double getMaxy() {
        return this.maxy;
    }

    public double getMaxz() {
        return this.maxz;
    }

    public double getMinx() {
        return this.minx;
    }

    public double getMiny() {
        return this.miny;
    }

    public double getMinz() {
        return this.minz;
    }
}

