/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.binary;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.binary.CouplesTable;
import org.chocosolver.solver.constraints.extension.binary.PropBinCSP;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

public class PropBinAC2001
extends PropBinCSP {
    private final IStateInt[] currentSupport0;
    private final IStateInt[] currentSupport1;
    private final int offset0;
    private final int offset1;
    private final IntIterableBitSet vrms;

    public PropBinAC2001(IntVar x, IntVar y, Tuples tuples) {
        this(x, y, new CouplesTable(tuples, x, y));
    }

    private PropBinAC2001(IntVar x, IntVar y, CouplesTable table) {
        super(x, y, table);
        int i;
        this.offset0 = x.getLB();
        this.offset1 = y.getLB();
        this.currentSupport0 = new IStateInt[x.getUB() - this.offset0 + 1];
        this.currentSupport1 = new IStateInt[y.getUB() - this.offset1 + 1];
        IEnvironment environment = this.model.getEnvironment();
        for (i = 0; i < this.currentSupport0.length; ++i) {
            this.currentSupport0[i] = environment.makeInt();
            this.currentSupport0[i].set(-1);
        }
        for (i = 0; i < this.currentSupport1.length; ++i) {
            this.currentSupport1[i] = environment.makeInt();
            this.currentSupport1[i].set(-1);
        }
        this.vrms = new IntIterableBitSet();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int support = 0;
        boolean found = false;
        this.vrms.clear();
        this.vrms.setOffset(((IntVar[])this.vars)[0].getLB());
        int ub0 = ((IntVar[])this.vars)[0].getUB();
        int val0 = ((IntVar[])this.vars)[0].getLB();
        while (val0 <= ub0) {
            int ub1 = ((IntVar[])this.vars)[1].getUB();
            int val1 = ((IntVar[])this.vars)[1].getLB();
            while (val1 <= ub1) {
                if (this.relation.isConsistent(val0, val1)) {
                    support = val1;
                    found = true;
                    break;
                }
                val1 = ((IntVar[])this.vars)[1].nextValue(val1);
            }
            if (!found) {
                this.vrms.add(val0);
            } else {
                this.currentSupport0[val0 - this.offset0].set(support);
            }
            found = false;
            val0 = ((IntVar[])this.vars)[0].nextValue(val0);
        }
        ((IntVar[])this.vars)[0].removeValues(this.vrms, this);
        found = false;
        this.vrms.clear();
        this.vrms.setOffset(((IntVar[])this.vars)[1].getLB());
        int ub1 = ((IntVar[])this.vars)[1].getUB();
        int val1 = ((IntVar[])this.vars)[1].getLB();
        while (val1 <= ub1) {
            ub0 = ((IntVar[])this.vars)[0].getUB();
            int val02 = ((IntVar[])this.vars)[0].getLB();
            while (val02 <= ub0) {
                if (this.relation.isConsistent(val02, val1)) {
                    support = val02;
                    found = true;
                    break;
                }
                val02 = ((IntVar[])this.vars)[0].nextValue(val02);
            }
            if (!found) {
                this.vrms.add(val1);
            } else {
                this.currentSupport1[val1 - this.offset1].set(support);
            }
            found = false;
            val1 = ((IntVar[])this.vars)[1].nextValue(val1);
        }
        ((IntVar[])this.vars)[1].removeValues(this.vrms, this);
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        if (IntEventType.isInstantiate(mask)) {
            this.onInstantiationOf(idxVarInProp);
        } else if (idxVarInProp == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public String toString() {
        return "Bin_AC2001(" + ((IntVar[])this.vars)[0].getName() + ", " + ((IntVar[])this.vars)[1].getName() + ", " + this.relation.getClass().getSimpleName() + ")";
    }

    private void reviseV1() throws ContradictionException {
        this.vrms.clear();
        this.vrms.setOffset(((IntVar[])this.vars)[1].getLB());
        int ub1 = ((IntVar[])this.vars)[1].getUB();
        int val1 = ((IntVar[])this.vars)[1].getLB();
        while (val1 <= ub1) {
            if (!((IntVar[])this.vars)[0].contains(this.currentSupport1[val1 - this.offset1].get())) {
                boolean found = false;
                int support = this.currentSupport1[val1 - this.offset1].get();
                int max1 = ((IntVar[])this.vars)[0].getUB();
                while (!found && support < max1) {
                    if (!this.relation.isConsistent(support = ((IntVar[])this.vars)[0].nextValue(support), val1)) continue;
                    found = true;
                }
                if (found) {
                    this.currentSupport1[val1 - this.offset1].set(support);
                } else {
                    this.vrms.add(val1);
                }
            }
            val1 = ((IntVar[])this.vars)[1].nextValue(val1);
        }
        ((IntVar[])this.vars)[1].removeValues(this.vrms, this);
    }

    private void reviseV0() throws ContradictionException {
        this.vrms.clear();
        this.vrms.setOffset(((IntVar[])this.vars)[0].getLB());
        int ub0 = ((IntVar[])this.vars)[0].getUB();
        int val0 = ((IntVar[])this.vars)[0].getLB();
        while (val0 <= ub0) {
            if (!((IntVar[])this.vars)[1].contains(this.currentSupport0[val0 - this.offset0].get())) {
                boolean found = false;
                int support = this.currentSupport0[val0 - this.offset0].get();
                int max2 = ((IntVar[])this.vars)[1].getUB();
                while (!found && support < max2) {
                    if (!this.relation.isConsistent(val0, support = ((IntVar[])this.vars)[1].nextValue(support))) continue;
                    found = true;
                }
                if (found) {
                    this.currentSupport0[val0 - this.offset0].set(support);
                } else {
                    this.vrms.add(val0);
                }
            }
            val0 = ((IntVar[])this.vars)[0].nextValue(val0);
        }
        ((IntVar[])this.vars)[0].removeValues(this.vrms, this);
    }

    private void onInstantiationOf(int idx) throws ContradictionException {
        if (idx == 0) {
            int value = ((IntVar[])this.vars)[0].getValue();
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[1].getLB());
            int ub1 = ((IntVar[])this.vars)[1].getUB();
            int val1 = ((IntVar[])this.vars)[1].getLB();
            while (val1 <= ub1) {
                if (!this.relation.isConsistent(value, val1)) {
                    this.vrms.add(val1);
                }
                val1 = ((IntVar[])this.vars)[1].nextValue(val1);
            }
            ((IntVar[])this.vars)[1].removeValues(this.vrms, this);
        } else {
            int value = ((IntVar[])this.vars)[1].getValue();
            this.vrms.clear();
            this.vrms.setOffset(((IntVar[])this.vars)[0].getLB());
            int ub0 = ((IntVar[])this.vars)[0].getUB();
            int val0 = ((IntVar[])this.vars)[0].getLB();
            while (val0 <= ub0) {
                if (!this.relation.isConsistent(val0, value)) {
                    this.vrms.add(val0);
                }
                val0 = ((IntVar[])this.vars)[0].nextValue(val0);
            }
            ((IntVar[])this.vars)[0].removeValues(this.vrms, this);
        }
    }
}

