/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone;

import com.nexagis.jawbone.IndexTerm;
import com.nexagis.jawbone.ParseIndexFile;
import com.nexagis.jawbone.PartOfSpeech;
import com.nexagis.jawbone.Synset;
import com.nexagis.jawbone.filter.TermFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Dictionary {
    private static Dictionary dict = new Dictionary();
    private static String path = null;
    private static boolean pathChanged = true;
    private static boolean pathValid = false;

    private Dictionary() {
    }

    public static void initialize(String string) {
        pathChanged = true;
        path = string;
        pathValid = Dictionary.pathIsValid();
        pathChanged = false;
    }

    public static Dictionary getInstance() {
        return dict;
    }

    public static String getDataFilesPath() {
        return path;
    }

    private static boolean pathIsValid() {
        if (!pathChanged) {
            return pathValid;
        }
        pathChanged = false;
        pathValid = true;
        if (path == null || path.length() < 1) {
            pathValid = false;
        } else {
            File file = new File(path);
            if (!file.isDirectory()) {
                file = null;
                pathValid = false;
            } else {
                file = new File(path, "data.noun");
                if (!file.equals(file) || !file.isFile()) {
                    return false;
                }
            }
        }
        return pathValid;
    }

    public Iterator<IndexTerm> getIndexTermIterator(PartOfSpeech partOfSpeech, int n) {
        return this.getIndexTermIterator(partOfSpeech, n, null);
    }

    public Iterator<IndexTerm> getIndexTermIterator(PartOfSpeech partOfSpeech, TermFilter termFilter) {
        return this.getIndexTermIterator(partOfSpeech, -1, termFilter);
    }

    public Iterator<IndexTerm> getIndexTermIterator(PartOfSpeech partOfSpeech, int n, TermFilter termFilter) {
        if (!Dictionary.pathIsValid()) {
            throw new RuntimeException("The data path is either not set or is invalid");
        }
        List<IndexTerm> list = ParseIndexFile.parseFile(partOfSpeech, n, termFilter);
        return list.iterator();
    }

    public Iterator<IndexTerm> getIndexTermIterator(PartOfSpeech partOfSpeech) {
        return this.getIndexTermIterator(partOfSpeech, -1);
    }

    public Iterator<IndexTerm> getIndexTermIterator(int n, TermFilter termFilter) {
        PartOfSpeech[] partOfSpeechArray = new PartOfSpeech[]{PartOfSpeech.ADJECTIVE, PartOfSpeech.ADVERB, PartOfSpeech.NOUN, PartOfSpeech.VERB};
        int n2 = n > 0 ? n * 4 : 100;
        ArrayList<IndexTerm> arrayList = new ArrayList<IndexTerm>(n2);
        for (int i = 0; i < partOfSpeechArray.length; ++i) {
            Iterator<IndexTerm> iterator = this.getIndexTermIterator(partOfSpeechArray[i], n, termFilter);
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
        Collections.sort(arrayList);
        if (arrayList.size() > n) {
            return arrayList.subList(0, n).iterator();
        }
        return arrayList.iterator();
    }

    public Synset getSynset(long l, char c) {
        return this.getSynset(l, PartOfSpeech.getInstance(c));
    }

    public Synset getSynset(long l, PartOfSpeech partOfSpeech) {
        return new Synset(l, partOfSpeech);
    }

    public Synset getSynset(long l) {
        char c;
        int n = (int)(l / 100000000L);
        switch (n) {
            case 1: {
                c = 'n';
                break;
            }
            case 2: {
                c = 'v';
                break;
            }
            case 3: {
                c = 'a';
                break;
            }
            case 4: {
                c = 'r';
                break;
            }
            default: {
                return null;
            }
        }
        return this.getSynset(l % 100000000L, c);
    }
}

