## ----setup, include=FALSE-----------------------------------------------------
library(chronicler)
library(ggplot2)
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
r_plot <- record_ggplot(
  ggplot(mtcars, aes(x = mpg, y = hp)) +
    geom_point() +
  geom_smooth(method = "lm", formula = y~x)
)

## -----------------------------------------------------------------------------
unveil(r_plot)

## -----------------------------------------------------------------------------
read_log(r_plot)

## -----------------------------------------------------------------------------
r_bad <- record_ggplot(
  ggplot(mtcars, aes(x = mpg, y = hpp)) +  # typo: 'hpp'
    geom_point()
)

# Printing the object shows the error plot, not a crash
r_bad

# The log tells you exactly what went wrong
read_log(r_bad)

## -----------------------------------------------------------------------------
r_plot_strict <- record_ggplot(
  ggplot(mtcars, aes(x = mpg, y = hp)) +
    geom_point() +
    geom_smooth(method = "lm"),
  strict = 3
)

## -----------------------------------------------------------------------------
unveil(r_plot_strict)

