/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe.iterator;

import cc.mallet.pipe.Noop;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureSequence;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;

public class DBInstanceIterator
implements Iterator<Instance> {
    public static final int EMPTY = 0;
    public static final int STRING = 1;
    public static final int FEATURE_VECTOR = 2;
    public static final int FEATURE_SEQUENCE = 3;
    public static final int FEATURE_VECTOR_SEQUENCE = 4;
    public static final int LABEL = 5;
    boolean debug = false;
    Connection connection = null;
    Statement statement = null;
    Alphabet dataAlphabet = null;
    Alphabet targetAlphabet = null;
    ResultSet instanceResults;
    int instancesReturned = 0;
    boolean atLeastOneMore = false;

    public DBInstanceIterator(String dbName) throws Exception {
        String entryValue;
        int insertedID;
        int entryID;
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");
        String connectionURL = "jdbc:derby:" + dbName + ";create=true";
        this.connection = DriverManager.getConnection(connectionURL);
        this.dataAlphabet = new Alphabet();
        this.targetAlphabet = new Alphabet();
        this.statement = this.connection.createStatement();
        ResultSet alphabetResults = this.statement.executeQuery("SELECT * FROM data_alphabet ORDER BY entry_id");
        while (alphabetResults.next()) {
            entryID = alphabetResults.getInt(1);
            if (entryID == (insertedID = this.dataAlphabet.lookupIndex(entryValue = alphabetResults.getString(2)))) continue;
            throw new Exception("Index mismatch in data alphabet for " + entryValue + " expecting " + entryID + " got " + insertedID);
        }
        alphabetResults.close();
        alphabetResults = this.statement.executeQuery("SELECT * FROM target_alphabet ORDER BY entry_id");
        while (alphabetResults.next()) {
            entryID = alphabetResults.getInt(1);
            if (entryID == (insertedID = this.targetAlphabet.lookupIndex(entryValue = alphabetResults.getString(2)))) continue;
            throw new Exception("Index mismatch in target alphabet for " + entryValue + " expecting " + entryID + " got " + insertedID);
        }
        alphabetResults.close();
        if (this.targetAlphabet.size() == 0) {
            this.targetAlphabet = null;
        }
        this.instanceResults = this.statement.executeQuery("SELECT * FROM instances ORDER BY instance_id");
        this.atLeastOneMore = this.instanceResults.next();
    }

    public static int[] byteArrayToIntArray(byte[] src) {
        int dstLength = src.length >>> 2;
        int[] dst = new int[dstLength];
        for (int i = 0; i < dstLength; ++i) {
            int j = i << 2;
            int x = 0;
            x += (src[j++] & 0xFF) << 0;
            x += (src[j++] & 0xFF) << 8;
            x += (src[j++] & 0xFF) << 16;
            dst[i] = x += (src[j++] & 0xFF) << 24;
        }
        return dst;
    }

    public Pipe getPipe() {
        return new Noop(this.dataAlphabet, this.targetAlphabet);
    }

    @Override
    public boolean hasNext() {
        return this.atLeastOneMore;
    }

    @Override
    public Instance next() {
        String name = null;
        FeatureSequence data = null;
        String target = null;
        Object source = null;
        try {
            int dataType;
            int targetType;
            int instanceID = this.instanceResults.getInt(1);
            if (instanceID != this.instancesReturned) {
                throw new Exception("Expecting instance " + this.instancesReturned + ", found instance " + instanceID);
            }
            int nameType = this.instanceResults.getInt(3);
            if (nameType == 1) {
                name = this.instanceResults.getString(2);
            }
            if ((targetType = this.instanceResults.getInt(5)) == 1) {
                target = this.instanceResults.getString(4);
            }
            if ((dataType = this.instanceResults.getInt(7)) == 3) {
                int[] features = DBInstanceIterator.byteArrayToIntArray(this.instanceResults.getBytes(6));
                for (int i = 0; i < features.length; ++i) {
                    if (features[i] < this.dataAlphabet.size()) continue;
                    System.err.println("found " + features[i] + ", expecting size " + this.dataAlphabet.size());
                }
                data = new FeatureSequence(this.dataAlphabet, features);
            }
            this.atLeastOneMore = this.instanceResults.next();
        }
        catch (Exception e) {
            System.err.println("problem returning instance " + this.instancesReturned + ": " + e.getMessage());
        }
        ++this.instancesReturned;
        return new Instance(data, target, name, source);
    }

    public static InstanceList getInstances(String dbName) throws Exception {
        DBInstanceIterator dbIterator = new DBInstanceIterator(dbName);
        InstanceList instances = new InstanceList(dbIterator.getPipe());
        instances.addThruPipe(dbIterator);
        dbIterator.cleanup();
        return instances;
    }

    public void cleanup() throws Exception {
        String sqlState = "";
        this.instanceResults.close();
        this.statement.close();
        this.connection.close();
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException se) {
            sqlState = se.getSQLState();
        }
        if (sqlState.equals("XJ015")) {
            System.err.println("shutdown successful: " + sqlState);
        }
    }

    @Override
    public void remove() {
        throw new IllegalStateException("This Iterator<Instance> does not support remove().");
    }
}

