/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.types.Dirichlet;
import cc.mallet.util.MalletLogger;
import cc.mallet.util.Maths;
import cc.mallet.util.Univariate;
import java.util.logging.Logger;

public final class StatFunctions {
    private static Logger logger = MalletLogger.getLogger(StatFunctions.class.getName());

    public static double cov(Univariate x, Univariate y) {
        double sumxy = 0.0;
        int n = x.size() >= y.size() ? x.size() : y.size();
        try {
            for (int i = 0; i < x.size(); ++i) {
                sumxy += (x.elementAt(i) - x.mean()) * (y.elementAt(i) - y.mean());
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.info("size of x != size of y");
            e.printStackTrace();
        }
        return sumxy / (double)(n - 1);
    }

    public static double corr(Univariate x, Univariate y) {
        double cov = StatFunctions.cov(x, y);
        return cov / (x.stdev() * y.stdev());
    }

    public static double[] ols(Univariate x, Univariate y) {
        double[] coef = new double[2];
        int n = x.size() <= y.size() ? x.size() : y.size();
        double sxy = 0.0;
        double sxx = 0.0;
        double xbar = x.mean();
        double ybar = y.mean();
        for (int i = 0; i < n; ++i) {
            double xi = x.elementAt(i);
            double yi = y.elementAt(i);
            sxy += (xi - xbar) * (yi - ybar);
            sxx += (xi - xbar) * (xi - xbar);
        }
        coef[0] = sxy / sxx;
        coef[1] = ybar - coef[0] * xbar;
        return coef;
    }

    public static double qnorm(double p, boolean upper) {
        double ppnd;
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("Illegal argument " + p + " for qnorm(p).");
        }
        double split = 0.42;
        double a0 = 2.50662823884;
        double a1 = -18.61500062529;
        double a2 = 41.39119773534;
        double a3 = -25.44106049637;
        double b1 = -8.4735109309;
        double b2 = 23.08336743743;
        double b3 = -21.06224101826;
        double b4 = 3.13082909833;
        double c0 = -2.78718931138;
        double c1 = -2.29796479134;
        double c2 = 4.85014127135;
        double c3 = 2.32121276858;
        double d1 = 3.54388924762;
        double d2 = 1.63706781897;
        double q = p - 0.5;
        if (Math.abs(q) <= split) {
            double r = q * q;
            ppnd = q * (((a3 * r + a2) * r + a1) * r + a0) / ((((b4 * r + b3) * r + b2) * r + b1) * r + 1.0);
        } else {
            double r = p;
            if (q > 0.0) {
                r = 1.0 - p;
            }
            if (r > 0.0) {
                r = Math.sqrt(-Math.log(r));
                ppnd = (((c3 * r + c2) * r + c1) * r + c0) / ((d2 * r + d1) * r + 1.0);
                if (q < 0.0) {
                    ppnd = -ppnd;
                }
            } else {
                ppnd = 0.0;
            }
        }
        if (upper) {
            ppnd = 1.0 - ppnd;
        }
        return ppnd;
    }

    public static double qnorm(double p, boolean upper, double mu, double sigma2) {
        return StatFunctions.qnorm(p, upper) * Math.sqrt(sigma2) + mu;
    }

    public static double pnorm(double z, boolean upper) {
        double alnorm;
        double ltone = 7.0;
        double utzero = 18.66;
        double con = 1.28;
        double a1 = 0.398942280444;
        double a2 = 0.399903438504;
        double a3 = 5.75885480458;
        double a4 = 29.8213557808;
        double a5 = 2.62433121679;
        double a6 = 48.6959930692;
        double a7 = 5.92885724438;
        double b1 = 0.398942280385;
        double b2 = 3.8052E-8;
        double b3 = 1.00000615302;
        double b4 = 3.98064794E-4;
        double b5 = 1.986153813664;
        double b6 = 0.151679116635;
        double b7 = 5.29330324926;
        double b8 = 4.8385912808;
        double b9 = 15.1508972451;
        double b10 = 0.742380924027;
        double b11 = 30.789933034;
        double b12 = 3.99019417011;
        if (z < 0.0) {
            upper = !upper;
            z = -z;
        }
        if (z <= ltone || upper && z <= utzero) {
            double y = 0.5 * z * z;
            alnorm = z > con ? b1 * Math.exp(-y) / (z - b2 + b3 / (z + b4 + b5 / (z - b6 + b7 / (z + b8 - b9 / (z + b10 + b11 / (z + b12)))))) : 0.5 - z * (a1 - a2 * y / (y + a3 - a4 / (y + a5 + a6 / (y + a7))));
        } else {
            alnorm = 0.0;
        }
        if (!upper) {
            alnorm = 1.0 - alnorm;
        }
        return alnorm;
    }

    public static double pnorm(double x, boolean upper, double mu, double sigma2) {
        return StatFunctions.pnorm((x - mu) / Math.sqrt(sigma2), upper);
    }

    public static double qt(double p, double ndf, boolean lower_tail) {
        double q;
        double P;
        boolean neg;
        if (p <= 0.0 || p >= 1.0 || ndf < 1.0) {
            throw new IllegalArgumentException("Invalid p or df in call to qt(double,double,boolean).");
        }
        double eps = 1.0E-12;
        double M_PI_2 = 1.5707963267948966;
        if (lower_tail && p > 0.5 || !lower_tail && p < 0.5) {
            neg = false;
            P = 2.0 * (lower_tail ? 1.0 - p : p);
        } else {
            neg = true;
            P = 2.0 * (lower_tail ? p : 1.0 - p);
        }
        if (Math.abs(ndf - 2.0) < eps) {
            q = Math.sqrt(2.0 / (P * (2.0 - P)) - 2.0);
        } else if (ndf < 1.0 + eps) {
            double prob = P * M_PI_2;
            q = Math.cos(prob) / Math.sin(prob);
        } else {
            double a = 1.0 / (ndf - 0.5);
            double b = 48.0 / (a * a);
            double c = ((20700.0 * a / b - 98.0) * a - 16.0) * a + 96.36;
            double d = ((94.5 / (b + c) - 3.0) / b + 1.0) * Math.sqrt(a * M_PI_2) * ndf;
            double y = Math.pow(d * P, 2.0 / ndf);
            if (y > 0.05 + a) {
                double x = StatFunctions.qnorm(0.5 * P, false);
                y = x * x;
                if (ndf < 5.0) {
                    c += 0.3 * (ndf - 4.5) * (x + 0.6);
                }
                c = (((0.05 * d * x - 5.0) * x - 7.0) * x - 2.0) * x + b + c;
                y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x;
                y = (y = a * y * y) > 0.002 ? Math.exp(y) - 1.0 : (0.5 * y + 1.0) * y;
            } else {
                y = ((1.0 / (((ndf + 6.0) / (ndf * y) - 0.089 * d - 0.822) * (ndf + 2.0) * 3.0) + 0.5 / (ndf + 4.0)) * y - 1.0) * (ndf + 1.0) / (ndf + 2.0) + 1.0 / y;
            }
            q = Math.sqrt(ndf * y);
        }
        if (neg) {
            q = -q;
        }
        return q;
    }

    public static double pt(double t, double df) {
        double ks;
        double g1 = 0.3183098862;
        if (df < 1.0) {
            throw new IllegalArgumentException("Illegal argument df for pt(t,df).");
        }
        double idf = df;
        double a = t / Math.sqrt(idf);
        double b = idf / (idf + t * t);
        double im2 = df - 2.0;
        double ioe = idf % 2.0;
        double s = 1.0;
        double c = 1.0;
        idf = 1.0;
        double fk = ks = 2.0 + ioe;
        if (im2 >= 2.0) {
            for (double k = ks; k <= im2; k += 2.0) {
                if ((s += (c = c * b * (fk - 1.0) / fk)) == idf) continue;
                idf = s;
                fk += 2.0;
            }
        }
        if (ioe != 1.0) {
            return 0.5 + 0.5 * a * Math.sqrt(b) * s;
        }
        if (df == 1.0) {
            s = 0.0;
        }
        return 0.5 + (a * b * s + Math.atan(a)) * g1;
    }

    public double pchisq(double q, double df) {
        double prob;
        double df2 = df * 0.5;
        double q2 = q * 0.5;
        int n = 5;
        if (q <= 0.0 || df <= 0.0) {
            throw new IllegalArgumentException("Illegal argument " + q + " or " + df + " for qnorm(p).");
        }
        if (q < df) {
            double tk = q2 * ((double)(1 - n) - df2) / (df2 + (double)(2 * n) - 1.0 + (double)n * q2 / (df2 + (double)(2 * n)));
            for (int k = n - 1; k > 1; --k) {
                tk = q2 * ((double)(1 - k) - df2) / (df2 + (double)(2 * k) - 1.0 + (double)k * q2 / (df2 + (double)(2 * k) + tk));
            }
            double CFL = 1.0 - q2 / (df2 + 1.0 + q2 / (df2 + 2.0 + tk));
            prob = Math.exp(df2 * Math.log(q2) - q2 - Maths.logGamma(df2 + 1.0) - Math.log(CFL));
        } else {
            double tk = ((double)n - df2) / (q2 + (double)n);
            for (int k = n - 1; k > 1; --k) {
                tk = ((double)k - df2) / (q2 + (double)k / (1.0 + tk));
            }
            double CFU = 1.0 + (1.0 - df2) / (q2 + 1.0 / (1.0 + tk));
            prob = 1.0 - Math.exp((df2 - 1.0) * Math.log(q2) - q2 - Maths.logGamma(df2) - Math.log(CFU));
        }
        return prob;
    }

    public static double betainv(double x, double p, double q) {
        boolean indx;
        double qq;
        double pp;
        double x2;
        double beta = Maths.logBeta(p, q);
        double acu = 1.0E-14;
        if (p <= 0.0 || q <= 0.0) {
            return -1.0;
        }
        if (x <= 0.0 || x >= 1.0) {
            return -1.0;
        }
        double psq = p + q;
        double cx = 1.0 - x;
        if (p < psq * x) {
            x2 = cx;
            cx = x;
            pp = q;
            qq = p;
            indx = true;
        } else {
            x2 = x;
            pp = p;
            qq = q;
            indx = false;
        }
        double term = 1.0;
        double ai = 1.0;
        double betain = 1.0;
        double ns = qq + cx * psq;
        double rx = x2 / cx;
        double temp = qq - ai;
        if (ns == 0.0) {
            rx = x2;
        }
        while (temp > acu && temp > acu * betain) {
            term = term * temp * rx / (pp + ai);
            betain += term;
            temp = Math.abs(term);
            if (!(temp > acu) || !(temp > acu * betain)) continue;
            ai += 1.0;
            if ((ns -= 1.0) >= 0.0) {
                temp = qq - ai;
                if (ns != 0.0) continue;
                rx = x2;
                continue;
            }
            temp = psq;
            psq += 1.0;
        }
        betain *= Math.exp(pp * Math.log(x2) + (qq - 1.0) * Math.log(cx) - beta) / pp;
        if (indx) {
            betain = 1.0 - betain;
        }
        return betain;
    }

    public static double pf(double x, double df1, double df2) {
        return StatFunctions.betainv(df1 * x / (df1 * x + df2), 0.5 * df1, 0.5 * df2);
    }

    public static double gammaPDF(double x, double shape, double scale) {
        return Math.exp(-Dirichlet.logGammaStirling(shape) - shape * Math.log(scale) + (shape - 1.0) * Math.log(x) - x / scale);
    }

    public static double gammaCDF(double x, double shape, double scale) {
        return Maths.regularizedGammaP(shape, x / scale);
    }

    public static double gammaInverseCDF(double p, double shape, double scale) {
        if (p <= 0.0) {
            return 0.0;
        }
        if (p >= 1.0) {
            return Double.MAX_VALUE;
        }
        double x = shape * scale;
        double cdfAtX = StatFunctions.gammaCDF(x, shape, scale);
        while (Math.abs(cdfAtX - p) > 1.0E-7) {
            x -= (cdfAtX - p) / StatFunctions.gammaPDF(x, shape, scale);
            cdfAtX = StatFunctions.gammaCDF(x, shape, scale);
        }
        return x;
    }
}

