/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.Nucleotides;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.oldevomodel.substmodel.AbstractCodonModel;
import dr.oldevomodel.substmodel.FrequencyModel;

public class YangCodonModel
extends AbstractCodonModel {
    protected Parameter kappaParameter;
    protected Parameter omegaParameter;
    protected byte[] rateMap;
    private Statistic synonymousRateStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "synonymousRate";
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            return YangCodonModel.this.getSynonymousRate();
        }
    };

    public YangCodonModel(Codons codons, Parameter parameter, Parameter parameter2, FrequencyModel frequencyModel) {
        super("yangCodonModel", codons, frequencyModel);
        this.omegaParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter.getDimension()));
        this.kappaParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, parameter2.getDimension()));
        this.constructRateMap();
        this.addStatistic(this.synonymousRateStatistic);
    }

    public void setKappa(double d) {
        this.kappaParameter.setParameterValue(0, d);
        this.updateMatrix = true;
    }

    public double getKappa() {
        return this.kappaParameter.getParameterValue(0);
    }

    public void setOmega(double d) {
        this.omegaParameter.setParameterValue(0, d);
        this.updateMatrix = true;
    }

    public double getOmega() {
        return this.omegaParameter.getParameterValue(0);
    }

    public double getSynonymousRate() {
        double d = this.getKappa();
        double d2 = this.getOmega();
        return (31.0 * d + 36.0) / (31.0 * d + 36.0 + 138.0 * d2 + 58.0 * d2 * d);
    }

    public double getNonSynonymousRate() {
        return 0.0;
    }

    @Override
    public void setupRelativeRates() {
        double d = this.getKappa();
        double d2 = this.getOmega();
        block7: for (int i = 0; i < this.rateCount; ++i) {
            switch (this.rateMap[i]) {
                case 0: {
                    this.relativeRates[i] = 0.0;
                    continue block7;
                }
                case 1: {
                    this.relativeRates[i] = d;
                    continue block7;
                }
                case 2: {
                    this.relativeRates[i] = 1.0;
                    continue block7;
                }
                case 3: {
                    this.relativeRates[i] = d * d2;
                    continue block7;
                }
                case 4: {
                    this.relativeRates[i] = d2;
                }
            }
        }
    }

    protected void constructRateMap() {
        int n = 0;
        this.rateMap = new byte[this.rateCount];
        for (int i = 0; i < this.stateCount; ++i) {
            int[] nArray = this.codonDataType.getTripletStates(i);
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            int n5 = this.codonDataType.getState(n2, n3, n4);
            int n6 = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n5));
            for (int j = i + 1; j < this.stateCount; ++j) {
                nArray = this.codonDataType.getTripletStates(j);
                int n7 = nArray[0];
                int n8 = nArray[1];
                int n9 = nArray[2];
                int n10 = this.codonDataType.getState(n7, n8, n9);
                int n11 = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n10));
                int n12 = -1;
                if (n2 != n7) {
                    n12 = n2 == 0 && n7 == 2 || n2 == 2 && n7 == 0 || n2 == 1 && n7 == 3 || n2 == 3 && n7 == 1 ? 1 : 2;
                }
                if (n3 != n8) {
                    n12 = n12 == -1 ? (n3 == 0 && n8 == 2 || n3 == 2 && n8 == 0 || n3 == 1 && n8 == 3 || n3 == 3 && n8 == 1 ? 1 : 2) : 0;
                }
                if (n4 != n9) {
                    n12 = n12 == -1 ? (n4 == 0 && n9 == 2 || n4 == 2 && n9 == 0 || n4 == 1 && n9 == 3 || n4 == 3 && n9 == 1 ? 1 : 2) : 0;
                }
                if (n12 != 0 && n6 != n11) {
                    n12 = (byte)(n12 + 2);
                }
                this.rateMap[n] = n12;
                ++n;
            }
        }
    }

    public void printRateMap() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        System.out.print("\t");
        for (n6 = 0; n6 < this.stateCount; ++n6) {
            nArray = this.codonDataType.getTripletStates(n6);
            n5 = nArray[0];
            n4 = nArray[1];
            n3 = nArray[2];
            System.out.print("\t" + Nucleotides.INSTANCE.getChar(n5));
            System.out.print(Nucleotides.INSTANCE.getChar(n4));
            System.out.print(Nucleotides.INSTANCE.getChar(n3));
        }
        System.out.println();
        System.out.print("\t");
        for (n6 = 0; n6 < this.stateCount; ++n6) {
            nArray = this.codonDataType.getTripletStates(n6);
            n5 = nArray[0];
            n4 = nArray[1];
            n3 = nArray[2];
            n2 = this.codonDataType.getState(n5, n4, n3);
            n = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n2));
            System.out.print("\t" + AminoAcids.INSTANCE.getChar(n));
        }
        System.out.println();
        for (int i = 0; i < this.stateCount; ++i) {
            nArray = this.codonDataType.getTripletStates(i);
            int n7 = nArray[0];
            int n8 = nArray[1];
            int n9 = nArray[2];
            System.out.print(Nucleotides.INSTANCE.getChar(n7));
            System.out.print(Nucleotides.INSTANCE.getChar(n8));
            System.out.print(Nucleotides.INSTANCE.getChar(n9));
            int n10 = this.codonDataType.getState(n7, n8, n9);
            int n11 = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n10));
            System.out.print("\t" + AminoAcids.INSTANCE.getChar(n11));
            for (n6 = 0; n6 < this.stateCount; ++n6) {
                nArray = this.codonDataType.getTripletStates(n6);
                n5 = nArray[0];
                n4 = nArray[1];
                n3 = nArray[2];
                n2 = this.codonDataType.getState(n5, n4, n3);
                n = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n2));
                int n12 = -1;
                if (n7 != n5) {
                    n12 = n7 == 0 && n5 == 2 || n7 == 2 && n5 == 0 || n7 == 1 && n5 == 3 || n7 == 3 && n5 == 1 ? 1 : 2;
                }
                if (n8 != n4) {
                    n12 = n12 == -1 ? (n8 == 0 && n4 == 2 || n8 == 2 && n4 == 0 || n8 == 1 && n4 == 3 || n8 == 3 && n4 == 1 ? 1 : 2) : 0;
                }
                if (n9 != n3) {
                    n12 = n12 == -1 ? (n9 == 0 && n3 == 2 || n9 == 2 && n3 == 0 || n9 == 1 && n3 == 3 || n9 == 3 && n3 == 1 ? 1 : 2) : 0;
                }
                if (n12 != 0 && n11 != n) {
                    n12 = (byte)(n12 + 2);
                }
                System.out.print("\t" + n12);
            }
            System.out.println();
        }
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>Yang Codon Model</em> kappa = ");
        stringBuffer.append(this.getKappa());
        stringBuffer.append(", omega = ");
        stringBuffer.append(this.getOmega());
        return stringBuffer.toString();
    }
}

