## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(facilityepimath)

## -----------------------------------------------------------------------------
s21 <- 1; s12 <- 2
omega1 <- omega2 <- 0.1
S <- rbind(c(-s21-omega1, s12), c(s21, -s12-omega2))

## -----------------------------------------------------------------------------
c21 <- 0.1; c12 <- 0
r11 <- r22 <- 0.1; r12 <- r21 <- 0
omega3 <- omega4 <- 0.1
C <- rbind(c(-c21-r11-r21-omega3, c12), c(c21, -c12-r12-r22-omega4))

## -----------------------------------------------------------------------------
a11 <- 1; a22 <- 2; a12 <- a21 <- 0
A <- rbind(c(a11,a12),c(a21,a22))

## -----------------------------------------------------------------------------
beta1 <- 0.2; beta2 <- 0.3
transm <- c(beta1, beta2)

## -----------------------------------------------------------------------------
theta1 <- 0.9; theta2 <- 1 - theta1
initS <- c(theta1, theta2)

## -----------------------------------------------------------------------------
facilityR0(S,C,A,transm,initS)

## -----------------------------------------------------------------------------
omega1 <- omega2 <- omega3 <- omega4 <- 0
S <- rbind(c(-s21-omega1, s12), c(s21, -s12-omega2))
C <- rbind(c(-c21-r11-r21-omega3, c12), c(c21, -c12-r12-r22-omega4))

## -----------------------------------------------------------------------------
mgf <- function(x, deriv=0) MGFgamma(x, rate=0.1, shape=3.1, deriv)

## -----------------------------------------------------------------------------
facilityR0(S,C,A,transm,initS,mgf)

## -----------------------------------------------------------------------------
R <- rbind(c(r11,r12),c(r21,r22))

## -----------------------------------------------------------------------------
pa <- 0.05; kappa1 <- 1; kappa2 <- 1-kappa1
init <- c((1-pa)*theta1, (1-pa)*theta2, pa*kappa1, pa*kappa2)

## -----------------------------------------------------------------------------
facilityeq(S, C, A, R, transm, init, mgf)

## -----------------------------------------------------------------------------
omega1 <- omega2 <- omega3 <- omega4 <- 0.1
S <- rbind(c(-s21-omega1, s12), c(s21, -s12-omega2))
C <- rbind(c(-c21-r11-r21-omega3, c12), c(c21, -c12-r12-r22-omega4))
facilityeq(S, C, A, R, transm, init)

